/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchiveFactory;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ClassLoaderSearchUtilDelegator;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.spi.ArchiveFormatAssociable;
import org.jboss.shrinkwrap.spi.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerBase<T extends Archive<T>>
extends AssignableBase<Archive<?>>
implements Archive<T>,
ManifestContainer<T>,
ServiceProviderContainer<T>,
ResourceContainer<T>,
ClassContainer<T>,
LibraryContainer<T>,
ArchiveFormatAssociable {
    private static final String DEFAULT_MANIFEST = "DefaultManifest.MF";
    private static final String DEFAULT_PACKAGE_NAME = "";
    private final Class<T> actualType;

    protected ContainerBase(Class<T> actualType, Archive<?> archive) {
        super(archive);
        Validate.notNull(actualType, "ActualType should be specified");
        this.actualType = actualType;
    }

    public ArchiveFormat getArchiveFormat() {
        return ((Configurable)this.getArchive().as(Configurable.class)).getConfiguration().getExtensionLoader().getArchiveFormatFromExtensionMapping(this.actualType);
    }

    public T add(Archive<?> archive, String path, Class<? extends StreamExporter> exporter) {
        this.getArchive().add(archive, path, exporter);
        return this.covarientReturn();
    }

    public T add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) {
        this.getArchive().add(archive, path, exporter);
        return this.covarientReturn();
    }

    public T add(Asset asset, ArchivePath target) throws IllegalArgumentException {
        this.getArchive().add(asset, target);
        return this.covarientReturn();
    }

    public T add(Asset asset, ArchivePath path, String name) {
        this.getArchive().add(asset, path, name);
        return this.covarientReturn();
    }

    public T add(Asset asset, String target, String name) throws IllegalArgumentException {
        this.getArchive().add(asset, target, name);
        return this.covarientReturn();
    }

    public T add(NamedAsset namedAsset) {
        this.getArchive().add(namedAsset);
        return this.covarientReturn();
    }

    public T addAsDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        this.getArchive().addAsDirectories(paths);
        return this.covarientReturn();
    }

    public T addAsDirectories(String ... paths) throws IllegalArgumentException {
        this.getArchive().addAsDirectories(paths);
        return this.covarientReturn();
    }

    public T addAsDirectory(ArchivePath path) throws IllegalArgumentException {
        this.getArchive().addAsDirectory(path);
        return this.covarientReturn();
    }

    public T addAsDirectory(String path) throws IllegalArgumentException {
        this.getArchive().addAsDirectory(path);
        return this.covarientReturn();
    }

    public T addHandlers(ArchiveEventHandler ... handlers) {
        for (ArchiveEventHandler handler : handlers) {
            this.getArchive().addHandlers(new ArchiveEventHandler[]{handler});
        }
        return this.covarientReturn();
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        this.getArchive().merge(source);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        this.getArchive().merge(source, path);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, path, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, path, filter);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source, String path) throws IllegalArgumentException {
        this.getArchive().merge(source, path);
        return this.covarientReturn();
    }

    public T move(ArchivePath source, ArchivePath target) throws IllegalArgumentException, IllegalArchivePathException {
        this.getArchive().move(source, target);
        return this.covarientReturn();
    }

    public T move(String source, String target) throws IllegalArgumentException, IllegalArchivePathException {
        this.getArchive().move(source, target);
        return this.covarientReturn();
    }

    public T add(Asset asset, String name) {
        this.getArchive().add(asset, name);
        return this.covarientReturn();
    }

    public boolean contains(ArchivePath path) {
        return this.getArchive().contains(path);
    }

    public boolean contains(String path) throws IllegalArgumentException {
        Validate.notNull(path, "Path must be specified");
        return this.contains(ArchivePaths.create((String)path));
    }

    public Node delete(ArchivePath path) {
        return this.getArchive().delete(path);
    }

    public Node delete(String archivePath) {
        Validate.notNull(archivePath, "No path was specified");
        return this.getArchive().delete(archivePath);
    }

    public Node get(ArchivePath path) {
        return this.getArchive().get(path);
    }

    public Node get(String path) throws IllegalArgumentException {
        return this.getArchive().get(path);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        return (X)this.getArchive().getAsType(type, path);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        return (X)this.getArchive().getAsType(type, path);
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        return this.getArchive().getAsType(type, filter);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path, ArchiveFormat archiveCompression) {
        return (X)this.getArchive().getAsType(type, path, archiveCompression);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path, ArchiveFormat archiveCompression) {
        return (X)this.getArchive().getAsType(type, path, archiveCompression);
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter, ArchiveFormat archiveCompression) {
        return this.getArchive().getAsType(type, filter, archiveCompression);
    }

    public Map<ArchivePath, Node> getContent() {
        return this.getArchive().getContent();
    }

    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> filter) {
        return this.getArchive().getContent(filter);
    }

    public String getName() {
        return this.getArchive().getName();
    }

    public String getId() {
        return this.getArchive().getId();
    }

    public Archive<T> shallowCopy() {
        Class<T> actualClass = this.getActualClass();
        Object underlyingArchive = this.getArchive();
        Configuration existingConfig = ((Configurable)underlyingArchive).getConfiguration();
        Domain domain = ShrinkWrap.createDomain((Configuration)existingConfig);
        ArchiveFactory factory = domain.getArchiveFactory();
        Archive newArchive = (Archive)factory.create(actualClass, this.getName());
        Map contents = underlyingArchive.getContent();
        for (ArchivePath path : contents.keySet()) {
            newArchive.add(((Node)contents.get(path)).getAsset(), path);
        }
        return newArchive;
    }

    public String toString() {
        return this.getArchive().toString();
    }

    public String toString(boolean verbose) {
        return this.getArchive().toString(verbose);
    }

    public String toString(Formatter formatter) throws IllegalArgumentException {
        return this.getArchive().toString(formatter);
    }

    public int hashCode() {
        return this.getArchive().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchiveBase) {
            return this.getArchive().equals(obj);
        }
        if (!(obj instanceof ContainerBase)) {
            return false;
        }
        ContainerBase other = (ContainerBase)obj;
        return this.getArchive().equals(other.getArchive());
    }

    protected abstract ArchivePath getManifestPath();

    public final T setManifest(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setManifest((Asset)new ClassLoaderAsset(resourceName));
    }

    public T setManifest(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest((Asset)new FileAsset(resource));
    }

    public T setManifest(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest((Asset)new UrlAsset(resource));
    }

    public T setManifest(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsManifestResource(resource, "MANIFEST.MF");
    }

    public T setManifest(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        return this.setManifest(classloaderResourceName);
    }

    public final T addAsManifestResource(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addAsManifestResource(this.fileFromResource(resourceName), resourceName);
    }

    public T addAsManifestResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsManifestResource(resource, resource.getName());
    }

    public T addAsManifestResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource(this.fileFromResource(resourceName), target);
    }

    public T addAsManifestResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsManifestResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsManifestResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsManifestResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsManifestResource(this.fileFromResource(resourceName), target);
    }

    private T addNestedJarFileResource(File resource, ArchivePath target, ArchivePath base) throws IllegalArgumentException {
        Iterable classLoaders = ((Configurable)this.getArchive()).getConfiguration().getClassLoaders();
        for (ClassLoader classLoader : classLoaders) {
            InputStream in = classLoader.getResourceAsStream(this.resourceAdjustedPath(resource));
            if (in == null) continue;
            ByteArrayAsset asset = new ByteArrayAsset(in);
            return this.add((Asset)asset, base, target.get());
        }
        throw new IllegalArgumentException(resource.getPath() + " was not found in any available ClassLoaders");
    }

    private String resourceAdjustedPath(File resource) {
        String path = resource.getPath();
        String adjustedPath = path.substring(path.indexOf("!" + File.separator) + 2, path.length());
        return adjustedPath.replace(File.separator, "/");
    }

    public T addAsManifestResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        if (resource.isFile()) {
            return this.addAsManifestResource((Asset)new FileAsset(resource), target);
        }
        File[] files = resource.listFiles();
        if (files == null) {
            return this.addNestedJarFileResource(resource, target, this.getManifestPath());
        }
        if (files.length == 0) {
            return this.addAsManifestResource((Asset)new FileAsset(resource), target);
        }
        for (File file : resource.listFiles()) {
            ArchivePath child = ArchivePaths.create((String)file.getName());
            this.addAsManifestResource(file, (ArchivePath)new BasicPath(target, child));
        }
        return this.covarientReturn();
    }

    public T addAsManifestResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        File file = new File(resource.getFile());
        if (file.exists()) {
            return this.addAsManifestResource(file, target);
        }
        return this.addAsManifestResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsManifestResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getManifestPath(), target);
        return this.add(resource, location);
    }

    public T addAsManifestResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsManifestResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsManifestResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsManifestResource(resourcePackage, resourceName, target);
    }

    public T addAsManifestResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsManifestResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsManifestResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsManifestResource((Asset)resource, target);
    }

    public T addManifest() throws IllegalArgumentException {
        return this.addAsManifestResource(DEFAULT_MANIFEST, "MANIFEST.MF");
    }

    public T addAsServiceProvider(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        ServiceProviderAsset asset = new ServiceProviderAsset(serviceImpls);
        BasicPath path = new BasicPath("services", serviceInterface.getName());
        return this.addAsManifestResource((Asset)asset, (ArchivePath)path);
    }

    public T addAsServiceProvider(String serviceInterface, String ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        ServiceProviderAsset asset = new ServiceProviderAsset(serviceImpls);
        BasicPath path = new BasicPath("services", serviceInterface);
        return this.addAsManifestResource((Asset)asset, (ArchivePath)path);
    }

    public T addAsServiceProviderAndClasses(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        this.addAsServiceProvider(serviceInterface, serviceImpls);
        this.addClass(serviceInterface);
        return this.addClasses(serviceImpls);
    }

    protected abstract ArchivePath getResourcePath();

    public final T addAsResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addAsResource(resourceName, resourceName);
    }

    public final T addAsResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsResource(resource, resource.getName());
    }

    public final T addAsResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource(this.fileFromResource(resourceName), target);
    }

    public T addAsResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        File resource = this.fileFromResource(resourceName);
        return this.addAsResource(resource, target);
    }

    public T addAsResource(String resourceName, ArchivePath target, ClassLoader classLoader) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(classLoader, "ClassLoader should be specified");
        return this.addAsResource((Asset)new ClassLoaderAsset(resourceName, classLoader), target);
    }

    public T addAsResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        if (resource.isFile()) {
            return this.addAsResource((Asset)new FileAsset(resource), target);
        }
        File[] files = resource.listFiles();
        if (files == null) {
            return this.addNestedJarFileResource(resource, target, this.getResourcePath());
        }
        if (files.length == 0) {
            return this.addAsDirectory(new BasicPath(this.getResourcePath(), target));
        }
        for (File file : resource.listFiles()) {
            ArchivePath child = ArchivePaths.create((String)file.getName());
            this.addAsResource(file, (ArchivePath)new BasicPath(target, child));
        }
        return this.covarientReturn();
    }

    public T addAsResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        File file = new File(resource.getFile());
        if (file.exists()) {
            return this.addAsResource(file, target);
        }
        return this.addAsResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getResourcePath(), target);
        return this.add(resource, location);
    }

    public T addAsResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsResource(resourcePackage, resourceName, target);
    }

    public T addAsResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsResource((Asset)resource, target);
    }

    protected abstract ArchivePath getClassesPath();

    public T addClass(Class<?> clazz) throws IllegalArgumentException {
        Validate.notNull(clazz, "Clazz must be specified");
        return this.addClasses(clazz);
    }

    public T addClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        Class<?> classToAdd;
        Validate.notNullOrEmpty(fullyQualifiedClassName, "Fully-qualified class name must be specified");
        Iterable<ClassLoader> cls = this.getArchiveClassLoaders();
        assert (cls != null) : "CLs of this archive is not specified:" + this.getArchive();
        try {
            classToAdd = ClassLoaderSearchUtilDelegator.findClassFromClassLoaders(fullyQualifiedClassName, cls);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Could not find the requested Class " + fullyQualifiedClassName + " in any of the configured ClassLoaders for this archive", cnfe);
        }
        return this.addClass(classToAdd);
    }

    public T addClass(String fullyQualifiedClassName, ClassLoader cl) throws IllegalArgumentException {
        Class<?> clazz;
        Validate.notNullOrEmpty(fullyQualifiedClassName, "Fully-qualified class name must be specified");
        Validate.notNull(cl, "ClassLoader must be specified");
        try {
            clazz = Class.forName(fullyQualifiedClassName, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class of name " + fullyQualifiedClassName + " with " + cl, e);
        }
        return this.addClass(clazz);
    }

    public T addClasses(Class<?> ... classes) throws IllegalArgumentException {
        Validate.notNull(classes, "Classes must be specified");
        for (final Class<?> clazz : classes) {
            ClassAsset resource = new ClassAsset(clazz);
            BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
            this.add((Asset)resource, location);
            ClassLoader loadingCl = clazz.getClassLoader();
            ClassLoader adjustedCl = loadingCl == null ? ClassLoader.getSystemClassLoader() : loadingCl;
            this.addPackages(false, new Filter<ArchivePath>(){

                public boolean include(ArchivePath path) {
                    ArchivePath classArchivePath = AssetUtil.getFullPathForClassResource(clazz);
                    String expression = classArchivePath.get().replace(".class", "\\$.*");
                    return path.get().matches(expression);
                }
            }, adjustedCl, clazz.getPackage() == null ? DEFAULT_PACKAGE_NAME : clazz.getPackage().getName());
        }
        return this.covarientReturn();
    }

    public T addPackage(Package pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Pack must be specified");
        return this.addPackage(pack.getName());
    }

    public T addPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(packages, "Packages must be specified");
        return this.addPackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T addPackages(boolean recursive, Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        return this.addPackages(recursive, filter, (ClassLoader)null, packages);
    }

    private T addPackages(boolean recursive, Filter<ArchivePath> filter, ClassLoader cl, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(packages, "Packages must be specified");
        String[] packageNames = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            packageNames[i] = packages[i] == null ? null : packages[i].getName();
        }
        if (cl == null) {
            return this.addPackages(recursive, filter, packageNames);
        }
        return this.addPackages(recursive, filter, cl, packageNames);
    }

    public T addPackage(String pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Package must be specified");
        return this.addPackages(false, pack);
    }

    public T addDefaultPackage() {
        return this.addPackages(false, DEFAULT_PACKAGE_NAME);
    }

    public T addPackages(boolean recursive, String ... packages) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(packages, "Pakcages must be specified and can not container null values");
        return this.addPackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T addPackages(boolean recursive, Filter<ArchivePath> filter, String ... packageNames) throws IllegalArgumentException {
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(packageNames, "PackageNames must be specified");
        Iterable<ClassLoader> classLoaders = this.getArchiveClassLoaders();
        for (String packageName : packageNames) {
            for (ClassLoader classLoader : classLoaders) {
                this.addPackage(recursive, filter, classLoader, packageName);
            }
        }
        return this.covarientReturn();
    }

    private T addPackages(boolean recursive, Filter<ArchivePath> filter, ClassLoader classLoader, String ... packageNames) {
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(packageNames, "PackageNames must be specified");
        for (String packageName : packageNames) {
            this.addPackage(recursive, filter, classLoader, packageName);
        }
        return this.covarientReturn();
    }

    private void addPackage(boolean recursive, final Filter<ArchivePath> filter, final ClassLoader classLoader, String packageName) {
        Validate.notNull(packageName, "Package doesn't exist");
        URLPackageScanner.Callback callback = new URLPackageScanner.Callback(){

            public void classFound(String className) {
                ArchivePath classNamePath = AssetUtil.getFullPathForClassResource(className);
                if (!filter.include((Object)classNamePath)) {
                    return;
                }
                ClassLoaderAsset asset = new ClassLoaderAsset(classNamePath.get().substring(1), classLoader);
                BasicPath location = new BasicPath(ContainerBase.this.getClassesPath(), classNamePath);
                ContainerBase.this.add((Asset)asset, location);
            }
        };
        URLPackageScanner scanner = URLPackageScanner.newInstance(recursive, classLoader, callback, packageName);
        scanner.scanPackage();
    }

    public T deleteClass(Class<?> clazz) throws IllegalArgumentException {
        Validate.notNull(clazz, "Class must be specified");
        return this.deleteClasses(clazz);
    }

    public T deleteClass(String fullyQualifiedClassName) throws IllegalArgumentException {
        Validate.notNull(fullyQualifiedClassName, "Class name must be specified");
        BasicPath path = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(fullyQualifiedClassName));
        this.getArchive().delete((ArchivePath)path);
        return this.covarientReturn();
    }

    public T deleteClasses(Class<?> ... classes) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(classes, "Classes must be specified and cannot contain null values");
        for (Class<?> clazz : classes) {
            BasicPath path = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
            for (ArchivePath innerPath : this.getInnerClasses(path)) {
                this.getArchive().delete(innerPath);
            }
            this.getArchive().delete((ArchivePath)path);
        }
        return this.covarientReturn();
    }

    private Set<ArchivePath> getInnerClasses(final ArchivePath path) {
        Map<ArchivePath, Node> content = this.getContent(new Filter<ArchivePath>(){

            public boolean include(ArchivePath object) {
                String expression = path.get().replace(".class", "\\$.*");
                boolean matches = object.get().matches(expression);
                return matches;
            }
        });
        return content.keySet();
    }

    public T deletePackage(Package pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Package name must be specified");
        return this.deletePackages(false, pack);
    }

    public T deletePackage(String pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Package name must be specified");
        return this.deletePackages(false, pack);
    }

    public T deleteDefaultPackage() {
        return this.deletePackage(DEFAULT_PACKAGE_NAME);
    }

    public T deletePackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(packages, "Packages must be specified and must not contain null values");
        return this.deletePackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T deletePackages(boolean recursive, String ... packages) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(packages, "Packages must be specified and must not contain null values");
        return this.deletePackages(recursive, (Filter<ArchivePath>)Filters.includeAll(), packages);
    }

    public T deletePackages(boolean recursive, Filter<ArchivePath> filter, Package ... packages) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(packages, "Packages must be specified and cannot contain null values");
        Validate.notNull(filter, "Filter must be specified");
        String[] packagesName = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            packagesName[i] = packages[i].getName();
        }
        return this.deletePackages(recursive, filter, packagesName);
    }

    public T deletePackages(boolean recursive, Filter<ArchivePath> filter, String ... packages) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(packages, "Packages must be specified and cannot contain null values");
        Validate.notNull(filter, "Filter must be specified");
        for (String packageName : packages) {
            for (ClassLoader cl : this.getArchiveClassLoaders()) {
                this.deletePackage(recursive, filter, packageName, cl);
            }
        }
        return this.covarientReturn();
    }

    private void deletePackage(boolean recursive, final Filter<ArchivePath> filter, String packageName, ClassLoader classLoader) {
        assert (filter != null) : "Filter cannot be null";
        URLPackageScanner.Callback callback = new URLPackageScanner.Callback(){

            public void classFound(String className) {
                ArchivePath classNamePath = AssetUtil.getFullPathForClassResource(className);
                if (!filter.include((Object)classNamePath)) {
                    return;
                }
                BasicPath location = new BasicPath(ContainerBase.this.getClassesPath(), classNamePath);
                ContainerBase.this.delete(location);
            }
        };
        URLPackageScanner scanner = URLPackageScanner.newInstance(recursive, classLoader, callback, packageName);
        scanner.scanPackage();
    }

    protected abstract ArchivePath getLibraryPath();

    public T addAsLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(archive, this.getLibraryPath(), ZipExporter.class);
    }

    public T addAsLibrary(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        File file = this.fileFromResource(resourceName);
        return this.addAsLibrary(file, (ArchivePath)new BasicPath(resourceName));
    }

    public T addAsLibrary(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addAsLibrary(resource, resource.getName());
    }

    public T addAsLibrary(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary(resourceName, (ArchivePath)new BasicPath(target));
    }

    public T addAsLibrary(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsLibrary(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsLibrary(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsLibrary(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsLibrary(this.fileFromResource(resourceName), target);
    }

    public T addAsLibrary(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        if (resource.isFile()) {
            return this.addAsLibrary((Asset)new FileAsset(resource), target);
        }
        if (resource.listFiles().length == 0) {
            return this.addAsLibrary((Asset)new FileAsset(resource), target);
        }
        for (File file : resource.listFiles()) {
            this.addAsLibrary(file, (ArchivePath)new BasicPath(target, file.getName()));
        }
        return this.covarientReturn();
    }

    public T addAsLibrary(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        File resourceFile = new File(resource.getFile());
        if (!resourceFile.exists()) {
            return this.addAsLibrary((Asset)new UrlAsset(resource), target);
        }
        if (resourceFile.isFile()) {
            return this.addAsLibrary((Asset)new UrlAsset(resource), target);
        }
        if (resourceFile.listFiles().length == 0) {
            return this.addAsLibrary((Asset)new UrlAsset(resource), target);
        }
        for (File file : resourceFile.listFiles()) {
            this.addAsLibrary(file, (ArchivePath)new BasicPath(target, file.getName()));
        }
        return this.covarientReturn();
    }

    public T addAsLibrary(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        Validate.notNull(target, "Target must be specified");
        BasicPath location = new BasicPath(this.getLibraryPath(), target);
        return this.add(resource, location);
    }

    public T addAsLibraries(String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourceNames, "ResourceNames must be specified");
        for (String resourceName : resourceNames) {
            this.addAsLibrary(resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsLibraries(File ... resources) throws IllegalArgumentException {
        Validate.notNull(resources, "Resources must be specified");
        for (File resource : resources) {
            this.addAsLibrary(resource);
        }
        return this.covarientReturn();
    }

    public T addAsLibraries(Archive<?> ... archives) throws IllegalArgumentException {
        Validate.notNull(archives, "Archives must be specified");
        for (Archive<?> archive : archives) {
            this.addAsLibrary(archive);
        }
        return this.covarientReturn();
    }

    public T addAsLibraries(Collection<? extends Archive<?>> archives) throws IllegalArgumentException {
        Validate.notNull(archives, "Archives must be specified");
        return this.addAsLibraries((Archive<?>[])archives.toArray(new Archive[archives.size()]));
    }

    public T addAsLibraries(Archive<?>[] ... archives) throws IllegalArgumentException {
        Validate.notNullAndNoNullValues(archives, "Archives must be specified");
        Archive<?>[][] arr$ = archives;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Archive<?>[] archiveArray;
            for (Archive<?> archive : archiveArray = arr$[i$]) {
                this.addAsLibraries((Archive<?>[])new Archive[]{archive});
            }
        }
        return this.covarientReturn();
    }

    public void writeTo(OutputStream outputStream, Formatter formatter) throws IllegalArgumentException {
        this.getArchive().writeTo(outputStream, formatter);
    }

    protected T covarientReturn() {
        return (T)((Archive)this.getActualClass().cast(this));
    }

    protected Class<T> getActualClass() {
        return this.actualType;
    }

    private File fileFromResource(String resourceName) throws IllegalArgumentException {
        URL resourceUrl = AccessController.doPrivileged(GetTcclAction.INSTANCE).getResource(resourceName);
        Validate.notNull(resourceUrl, resourceName + " doesn't exist or can't be accessed");
        String resourcePath = AccessController.doPrivileged(GetTcclAction.INSTANCE).getResource(resourceName).getFile();
        try {
            resourcePath = URLDecoder.decode(resourcePath, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee);
        }
        return new File(resourcePath);
    }

    private Iterable<ClassLoader> getArchiveClassLoaders() {
        Object archive = this.getArchive();
        Iterable cls = ((Configurable)archive).getConfiguration().getClassLoaders();
        return cls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

