/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader;
import org.jboss.shrinkwrap.impl.base.TestSecurityActions;
import org.junit.Test;

public class ServiceExtensionLoaderTestCase {
    @Test
    public void shouldBeAbleToLoadExtension() throws Exception {
        Extension extension = (Extension)this.createLoaderUsingTccl().load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((extension.getClass() == ExtensionImpl.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeAbleToOverrideExtension() throws Exception {
        Extension extension = (Extension)this.createLoaderUsingTccl().addOverride(Extension.class, ExtensionImpl2.class).load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((extension.getClass() == ExtensionImpl2.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldBePlacedInCacheAfterLoad() throws Exception {
        ServiceExtensionLoader loader = this.createLoaderUsingTccl();
        loader.load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assert.assertTrue((String)"Should be placed in cache", (boolean)loader.isCached(Extension.class));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionOnMissingExtension() throws Exception {
        this.createLoaderUsingTccl().load(MissingExtension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionOnWrongImplType() throws Exception {
        this.createLoaderUsingTccl().load(WrongImplExtension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
    }

    private ServiceExtensionLoader createLoaderUsingTccl() {
        ArrayList<ClassLoader> cls = new ArrayList<ClassLoader>(1);
        cls.add(TestSecurityActions.getThreadContextClassLoader());
        return new ServiceExtensionLoader(cls);
    }

    public static interface MissingExtension
    extends Assignable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionImpl2
    extends AssignableBase<Archive<?>>
    implements Extension {
        public ExtensionImpl2(Archive<?> archive) {
            super(archive);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionImpl
    extends AssignableBase<Archive<?>>
    implements Extension {
        public ExtensionImpl(Archive<?> archive) {
            super(archive);
        }
    }

    public static interface Extension
    extends Assignable {
    }

    public static interface WrongImplExtension
    extends Assignable {
    }
}

