/*
 * Decompiled with CFR 0.152.
 */
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultPackageAddTestCase {
    private static final Logger log = Logger.getLogger(DefaultPackageAddTestCase.class.getName());
    private ArchivePath classInDefaultPackagePath;
    private ArchivePath innerClassInDefaultPackagePath;

    @Before
    public void setupPaths() {
        this.classInDefaultPackagePath = ArchivePaths.create((String)"/ClassInDefaultPackage.class");
        this.innerClassInDefaultPackagePath = ArchivePaths.create((String)"/ClassInDefaultPackage$InnerClassInDefaultPackage.class");
    }

    @After
    public void cleanupPaths() {
        this.classInDefaultPackagePath = null;
        this.innerClassInDefaultPackagePath = null;
    }

    @Test
    public void canAddClassFromDefaultPackage() throws Exception {
        JavaArchive archive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClass(ClassInDefaultPackage.class);
        log.info(archive.toString(true));
        this.assertClassesWereAdded(archive);
    }

    @Test
    public void testAddDefaultPackage() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addDefaultPackage();
        this.assertClassesWereAdded(archive);
        int expectedSize = 3;
        int size = archive.getContent().size();
        Assert.assertEquals((String)"Not the expected number of assets added to the archive", (long)3L, (long)size);
    }

    private void assertClassesWereAdded(JavaArchive archive) {
        Assert.assertTrue((String)"Class in default package was not added to archive", (boolean)archive.contains(this.classInDefaultPackagePath));
        Assert.assertTrue((String)"Inner class in default package was not added to archive", (boolean)archive.contains(this.innerClassInDefaultPackagePath));
    }
}

