/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassA;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AddPackageFromJarContainingWebInfTest {
    private Domain domain;
    private Path temp;

    @Before
    public void setUp() throws IOException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"my.jar");
        jar.addClass(DummyClassA.class);
        jar.add((Asset)new StringAsset("stuff"), "WEB-INF/classes/stuff.txt");
        this.temp = Files.createTempFile("test", ".jar", new FileAttribute[0]);
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(this.temp.toFile(), true);
        URL jarUrl = this.temp.toUri().toURL();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        URLClassLoader jarCl = new URLClassLoader(new URL[]{jarUrl}, null);
        classLoaders.add(jarCl);
        FilteringClassLoader shrinkwrapCl = new FilteringClassLoader(this.getClass().getClassLoader());
        classLoaders.add(shrinkwrapCl);
        builder.classLoaders(classLoaders);
        this.domain = ShrinkWrap.createDomain((Configuration)builder.build());
    }

    @After
    public void tearDown() throws IOException {
        Files.delete(this.temp);
    }

    @Test
    public void testAddPackage() {
        WebArchive war = (WebArchive)this.domain.getArchiveFactory().create(WebArchive.class);
        war.addPackage(DummyClassA.class.getPackage());
        Assert.assertNotNull((Object)war.get("/WEB-INF/classes/" + DummyClassA.class.getName().replace('.', '/') + ".class"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringClassLoader
    extends ClassLoader {
        public FilteringClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.contains("donotchange")) {
                return null;
            }
            return super.loadClass(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.contains("donotchange")) {
                return Collections.emptyEnumeration();
            }
            return super.getResources(name);
        }
    }
}

