/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveWriteToTestCase {
    private static final String TEST_ARCHIVE = "org/jboss/shrinkwrap/impl/base/importer/test.zip";

    @Test
    public void shouldBufferWritesCorrectly() throws IOException {
        MockOutputStream outputStream = new MockOutputStream();
        byte[] content = new byte[9202];
        for (int i = 0; i < content.length; ++i) {
            content[i] = (i + "").getBytes()[0];
        }
        IOUtil.bufferedWriteWithFlush((OutputStream)outputStream, (byte[])content);
        Assert.assertArrayEquals((String)"Inconsistent writes?", (byte[])content, (byte[])outputStream.getContents());
    }

    @Test
    public void archiveWriteToShouldWriteToStream() throws Exception {
        MockOutputStream outputStream = new MockOutputStream();
        File testFile = TestIOUtil.createFileFromResourceName(TEST_ARCHIVE);
        Archive archive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile);
        byte[] archiveToString = archive.toString((Formatter)Formatters.SIMPLE).getBytes();
        archive.writeTo((OutputStream)outputStream, (Formatter)Formatters.SIMPLE);
        Assert.assertArrayEquals((String)"Inconsistent writes?", (byte[])archiveToString, (byte[])outputStream.getContents());
        outputStream = new MockOutputStream();
        archiveToString = archive.toString((Formatter)Formatters.VERBOSE).getBytes();
        archive.writeTo((OutputStream)outputStream, (Formatter)Formatters.VERBOSE);
        Assert.assertArrayEquals((String)"Inconsistent writes?", (byte[])archiveToString, (byte[])outputStream.getContents());
    }

    private class MockOutputStream
    extends PrintStream {
        ArrayList<Byte> contents;

        public MockOutputStream() {
            super(System.out);
            this.contents = new ArrayList();
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            for (int i = off; i < off + len; ++i) {
                this.contents.add(buf[i]);
            }
        }

        public byte[] getContents() {
            byte[] bytes = new byte[this.contents.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = this.contents.get(i);
            }
            return bytes;
        }
    }
}

