/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.TarExporter;
import org.jboss.shrinkwrap.api.importer.TarImporter;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.importer.StreamImporterImplTestBase;
import org.jboss.shrinkwrap.impl.base.importer.TarContentAssertionDelegate;
import org.jboss.shrinkwrap.impl.base.io.tar.TarInputStream;

public class TarImporterImplTestCase
extends StreamImporterImplTestBase<TarImporter> {
    private static final Logger log = Logger.getLogger(TarImporterImplTestCase.class.getName());
    private static final TarContentAssertionDelegate delegate = new TarContentAssertionDelegate();

    @Override
    protected ContentAssertionDelegateBase getDelegate() {
        return delegate;
    }

    @Override
    protected Class<TarImporter> getImporterClass() {
        return TarImporter.class;
    }

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return TarExporter.class;
    }

    protected TarInputStream getExceptionThrowingInputStream() {
        try {
            return ExceptionThrowingTarInputStream.create();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not occur in test setup", e);
        }
    }

    @Override
    protected ArchiveFormat getArchiveFormat() {
        return ArchiveFormat.TAR;
    }

    private static final class ExceptionThrowingTarInputStream
    extends TarInputStream {
        static ExceptionThrowingTarInputStream create() throws IOException {
            byte[] test = "Something".getBytes();
            ByteArrayInputStream in = new ByteArrayInputStream(test);
            return new ExceptionThrowingTarInputStream(in);
        }

        private ExceptionThrowingTarInputStream(InputStream in) throws IOException {
            super(in);
        }

        public int read() throws IOException {
            throw new RuntimeException("Mock Exception, should be wrapped in the import process");
        }

        public int read(byte[] buf) throws IOException {
            return this.read();
        }

        public int read(byte[] buf, int offset, int numToRead) throws IOException {
            return this.read();
        }
    }
}

