/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileAttributes;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileAttributesTestCase {
    private static final Logger log = Logger.getLogger(FileAttributesTestCase.class.getName());
    private FileSystem fs;
    private JavaArchive archive;

    @Before
    public void createStore() throws IOException {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
        this.fs = fs;
    }

    @After
    public void closeFs() throws IOException {
        this.fs.close();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getLastModifiedTime() throws IOException {
        this.getAttributes("path", true).lastModifiedTime();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void lastAccessTime() throws IOException {
        this.getAttributes("path", true).lastAccessTime();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void creationTime() throws IOException {
        this.getAttributes("path", true).creationTime();
    }

    @Test
    public void isRegularFile() throws IOException {
        Assert.assertTrue((boolean)this.getAttributes("path", true).isRegularFile());
    }

    @Test
    public void isRegularFileFalse() throws IOException {
        Assert.assertFalse((boolean)this.getAttributes("path/", true).isRegularFile());
    }

    @Test
    public void isDirectory() throws IOException {
        Assert.assertTrue((boolean)this.getAttributes("path/", true).isDirectory());
    }

    @Test
    public void isDirectoryFalse() throws IOException {
        Assert.assertFalse((boolean)this.getAttributes("path", true).isDirectory());
    }

    @Test
    public void isOther() throws IOException {
        Assert.assertFalse((boolean)this.getAttributes("alwaysFalse", true).isOther());
    }

    @Test
    public void isSymbolicLink() throws IOException {
        Assert.assertFalse((boolean)this.getAttributes("alwaysFalse", true).isSymbolicLink());
    }

    @Test
    public void size() throws IOException {
        int size = 1024;
        Asset kiloAsset = new Asset(){

            public InputStream openStream() {
                return new ByteArrayInputStream(new byte[1024]);
            }
        };
        String path = "path";
        this.archive.add(kiloAsset, "path");
        Assert.assertEquals((String)"Size not reported as expected", (long)1024L, (long)this.getAttributes("path", false).size());
    }

    @Test
    public void fileKey() throws IOException {
        String path = "path";
        String expected = this.archive.getId() + "/" + "path";
        Assert.assertEquals((String)"Filekey not as expected", (Object)expected, (Object)this.getAttributes("path", true).fileKey());
    }

    private ShrinkWrapFileAttributes getAttributes(String pathName, boolean create) {
        String attributesFor = pathName;
        if (create) {
            if (pathName.endsWith("/")) {
                attributesFor = pathName.substring(0, pathName.length() - 1);
                this.archive.addAsDirectory(attributesFor);
            } else {
                this.archive.add((Asset)EmptyAsset.INSTANCE, pathName);
            }
        }
        try {
            return Files.readAttributes(this.fs.getPath(attributesFor, new String[0]), ShrinkWrapFileAttributes.class, new LinkOption[]{null});
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

