/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.FileAttributesTestCase;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileAttributeView;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileAttributes;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileAttributesViewTestCase {
    private static final Logger log = Logger.getLogger(FileAttributesTestCase.class.getName());
    private FileSystem fs;
    private JavaArchive archive;

    @Before
    public void createStore() throws IOException {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
        this.fs = fs;
    }

    @After
    public void closeFs() throws IOException {
        this.fs.close();
    }

    @Test
    public void getShrinkwrapAttributesView() {
        ShrinkWrapFileAttributeView attributeView = this.getAttributesView("path");
        Assert.assertEquals((String)"Attributes view wrong name", (String)ShrinkWrapFileAttributeView.class.getSimpleName(), (String)attributeView.name());
        Assert.assertTrue((String)"Attribute view is not an instance of ShrinkWrapFileAttributeView", (boolean)(attributeView instanceof ShrinkWrapFileAttributeView));
    }

    @Test
    public void readAttributes() throws IOException {
        ShrinkWrapFileAttributeView attributeView = this.getAttributesView("path");
        Assert.assertNotNull((String)"Attribute view should not be null", (Object)attributeView);
        BasicFileAttributes attributes = attributeView.readAttributes();
        Assert.assertTrue((String)"Atrributes are not instance of ShrinkWrapFileAttributes", (boolean)(attributes instanceof ShrinkWrapFileAttributes));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void setTimes() throws IOException {
        ShrinkWrapFileAttributeView attributeView = this.getAttributesView("path");
        FileTime fileTime = FileTime.fromMillis(0L);
        attributeView.setTimes(fileTime, fileTime, fileTime);
    }

    private ShrinkWrapFileAttributeView getAttributesView(String pathName) {
        this.archive.add((Asset)EmptyAsset.INSTANCE, pathName);
        return Files.getFileAttributeView(this.fs.getPath(pathName, new String[0]), ShrinkWrapFileAttributeView.class, new LinkOption[]{null});
    }
}

