/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileStoreTestCase {
    private static final Logger log = Logger.getLogger(FileStoreTestCase.class.getName());
    private JavaArchive archive;
    private FileStore fileStore;
    private FileSystem fileSystem;

    @Before
    public void createStore() throws IOException {
        FileStore fileStore;
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.fileStore = fileStore = fs.getFileStores().iterator().next();
        this.archive = archive;
        this.fileSystem = fs;
    }

    @After
    public void closeFs() throws IOException {
        this.fileSystem.close();
    }

    @Test
    public void usedSpace() throws IOException {
        Class<Asset> classToAdd = Asset.class;
        this.archive.addClass(classToAdd);
        String pathToClass = classToAdd.getName().replace('.', '/') + ".class";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathToClass);
        long thisClassFileSize = 0L;
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            thisClassFileSize += (long)read;
        }
        long sizeOfArchive = ((ShrinkWrapFileStore)this.fileStore).getUsedSpace();
        Assert.assertEquals((String)"Size of archive as reported by file store is not equal to the size of the contained class", (long)thisClassFileSize, (long)sizeOfArchive);
    }

    @Test
    public void totalSpace() throws IOException {
        Assert.assertTrue((String)"Total space is not returning a positive integer", (this.fileStore.getTotalSpace() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void usableSpace() throws IOException {
        Assert.assertTrue((String)"Usable space is not returning a positive integer", (this.fileStore.getUsableSpace() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void unallocatedSpace() throws IOException {
        Assert.assertTrue((String)"Unallocated space is not returning a positive integer", (this.fileStore.getUnallocatedSpace() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void name() {
        Assert.assertEquals((String)"Name of the file store should be equal to the name of the underlying archive", (Object)this.archive.getName(), (Object)this.fileStore.name());
    }

    @Test
    public void type() {
        Assert.assertEquals((String)"Type of the file store should be \"shrinkwrap\"", (Object)"shrinkwrap", (Object)this.fileStore.type());
    }

    @Test
    public void readOnly() {
        Assert.assertEquals((String)"ShrinkWrap file stores are not read-only", (Object)false, (Object)this.fileStore.isReadOnly());
    }

    @Test
    public void supportsBasicFileAttributeView() {
        Assert.assertEquals((String)"ShrinkWrap file store must support basic file attribute view", (Object)true, (Object)this.fileStore.supportsFileAttributeView("basic"));
    }

    @Test
    public void supportsBasicFileAttributeViewType() {
        Assert.assertEquals((String)"ShrinkWrap file store must support basic file attribute view", (Object)true, (Object)this.fileStore.supportsFileAttributeView(BasicFileAttributeView.class));
    }

    @Test
    public void supportsOtherFileAttributeView() {
        Assert.assertEquals((String)"ShrinkWrap file store should not support other file attribute views", (Object)false, (Object)this.fileStore.supportsFileAttributeView("somethingelse"));
    }

    @Test
    public void supportsOtherFileAttributeViewType() {
        Assert.assertEquals((String)"ShrinkWrap file store should not support other file attribute views", (Object)false, (Object)this.fileStore.supportsFileAttributeView(new FileAttributeView(){

            @Override
            public String name() {
                return "mock";
            }
        }.getClass()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getAttribute() throws IOException {
        this.fileStore.getAttribute("something");
    }

    @Test
    public void getFileStoreAttributeView() throws IOException {
        Assert.assertNull((Object)this.fileStore.getFileStoreAttributeView(FileStoreAttributeView.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullArgsProhibited() {
        new ShrinkWrapFileStore(null);
    }
}

