/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileStore;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystemProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileSystemTestCase {
    private static final Logger log = Logger.getLogger(FileSystemTestCase.class.getName());
    private FileSystem fileSystem;
    private JavaArchive archive;

    @Before
    public void createFileSystem() throws URISyntaxException, IOException {
        FileSystem fs;
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        this.fileSystem = fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
    }

    @After
    public void closeFs() throws IOException {
        this.fileSystem.close();
    }

    @Test
    public void rootDirectories() {
        Iterable<Path> paths = this.fileSystem.getRootDirectories();
        int count = 0;
        for (Path path : paths) {
            ++count;
            Assert.assertEquals((String)"Root was not in expected form", (Object)ArchivePaths.root().get(), (Object)path.toString());
        }
        Assert.assertEquals((String)"Should only be one root path per FS", (long)1L, (long)count);
    }

    @Test
    public void fileSeparator() {
        String fileSeparator = this.fileSystem.getSeparator();
        Assert.assertEquals((String)"File separator was not as expected", (Object)ArchivePath.SEPARATOR_STRING, (Object)fileSeparator);
    }

    @Test
    public void provider() {
        FileSystemProvider provider = this.fileSystem.provider();
        Assert.assertNotNull((String)"Provider must be linked from file system", (Object)provider);
        Assert.assertTrue((String)"Provider supplied is of wrong type", (boolean)(provider instanceof ShrinkWrapFileSystemProvider));
    }

    @Test
    public void isReadOnly() {
        Assert.assertFalse((String)"ShrinkWrap File Systems are not read-only", (boolean)this.fileSystem.isReadOnly());
    }

    @Test
    public void isOpen() {
        Assert.assertTrue((String)"Should report as open", (boolean)this.fileSystem.isOpen());
    }

    @Test
    public void isOpenAfterClose() throws IOException {
        this.fileSystem.close();
        Assert.assertFalse((String)"Should report as closed", (boolean)this.fileSystem.isOpen());
    }

    @Test
    public void getFileStores() {
        Iterable<FileStore> fileStores = this.fileSystem.getFileStores();
        int count = 0;
        for (FileStore fileStore : fileStores) {
            ++count;
            Assert.assertTrue((String)"file store is not of correct type", (boolean)(fileStore instanceof ShrinkWrapFileStore));
        }
        Assert.assertEquals((String)"Should only be one file store per file system", (long)1L, (long)count);
    }

    @Test
    public void supportedFileAttributeViews() {
        Set<String> fileAttrViews = this.fileSystem.supportedFileAttributeViews();
        Assert.assertEquals((String)"Only support \"basic\" file att view", (long)1L, (long)fileAttrViews.size());
        Assert.assertTrue((String)"By contract we must support the \"basic\" view", (boolean)fileAttrViews.contains("basic"));
    }

    @Test
    public void getPathRoot() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Assert.assertEquals((String)"Root path not obtained correctly", (Object)ArchivePaths.root().get(), (Object)path.toString());
    }

    @Test
    public void getPathRootFromEmptyString() {
        Path path = this.fileSystem.getPath("", new String[0]);
        Assert.assertNull((String)"Root path of empty string should be null", (Object)path.getRoot());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPathNull() {
        this.fileSystem.getPath(null, new String[0]);
    }

    @Test
    public void getHierarchicalPath() {
        Path path = this.fileSystem.getPath("toplevel", "parent", "child");
        Assert.assertEquals((String)"Path not obtained correctly from hierarchical input", (Object)"toplevel/parent/child", (Object)path.toString());
    }

    @Test
    public void getHierarchicalPathFromAbsolute() {
        Path path = this.fileSystem.getPath("/toplevel", "parent", "child");
        Assert.assertEquals((String)"Path not obtained correctly from hierarchical input", (Object)"/toplevel/parent/child", (Object)path.toString());
    }

    @Test
    public void getHierarchicalPathFromMixedInput() {
        Path path = this.fileSystem.getPath("toplevel/parent", "child");
        Assert.assertEquals((String)"Path not obtained correctly from mixed hierarchical input", (Object)"toplevel/parent/child", (Object)path.toString());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getUserPrincipalLookupService() {
        this.fileSystem.getUserPrincipalLookupService();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void newWatchService() throws IOException {
        this.fileSystem.newWatchService();
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void fileSystemAlreadyExists() throws IllegalArgumentException, IOException {
        ShrinkWrapFileSystems.newFileSystem((Archive)this.archive);
    }

    @Test
    public void fileSystemClosedNewIsntanceCreated() throws IllegalArgumentException, IOException {
        this.fileSystem.close();
        Assert.assertNotNull((String)"", (Object)ShrinkWrapFileSystems.newFileSystem((Archive)this.archive));
    }

    @Test
    public void getFileSystem() {
        URI uri = ShrinkWrapFileSystems.getRootUri((Archive)this.archive);
        Assert.assertEquals((String)"getFileSystem should return same existing file system", (Object)this.fileSystem, (Object)FileSystems.getFileSystem(uri));
    }
}

