/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Iterator;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.MockPath;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathTestCase {
    private static final Logger log = Logger.getLogger(PathTestCase.class.getName());
    private ShrinkWrapFileSystem fileSystem;

    @Before
    public void createFileSystem() throws URISyntaxException, IOException {
        ShrinkWrapFileSystem fs;
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        this.fileSystem = fs = (ShrinkWrapFileSystem)ShrinkWrapFileSystems.newFileSystem((Archive)archive);
    }

    @After
    public void closeFs() throws IOException {
        this.fileSystem.close();
    }

    @Test
    public void rootIsAbsolute() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Assert.assertTrue((String)"Root path must be absolute", (boolean)path.isAbsolute());
        Assert.assertEquals((String)"Root path should be equal to root archive path value", (Object)path.toString(), (Object)ArchivePaths.root().get());
    }

    @Test
    public void getFileSystem() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Assert.assertEquals((String)"FileSystem not obtained correctly via Path", (Object)this.fileSystem, (Object)path.getFileSystem());
    }

    @Test
    public void getPathEmptyPath() {
        String empty = "";
        Path path = this.fileSystem.getPath("", new String[0]);
        Assert.assertEquals((String)"Empty path should be resolved to empty path value", (Object)"", (Object)path.toString());
    }

    @Test
    public void getFileNameEmptyPath() {
        String empty = "";
        Path path = this.fileSystem.getPath("", new String[0]);
        Assert.assertEquals((String)"Empty path should return null file name", null, (Object)path.getFileName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPathNullPath() {
        this.fileSystem.getPath(null, new String[0]);
    }

    @Test
    public void getPathRelative() {
        String relative = "relative";
        Path path = this.fileSystem.getPath("relative", new String[0]);
        Assert.assertFalse((String)"Relative paths must not be adjusted to absolute", (boolean)path.isAbsolute());
        Assert.assertEquals((String)"Relative input was not resolved to path as expected", (Object)"relative", (Object)path.toString());
    }

    @Test
    public void getRoot() {
        Path path = this.fileSystem.getPath("/someNode", new String[0]);
        Path root = path.getRoot();
        Assert.assertEquals((String)"Did not return correct root", (Object)root.toString(), (Object)"/");
    }

    @Test
    public void getRootFromRelative() {
        Path path = this.fileSystem.getPath("someNode", new String[0]);
        Path root = path.getRoot();
        Assert.assertNull((String)"Relative path should have null root", (Object)root);
    }

    @Test
    public void getRootFromNested() {
        Path path = this.fileSystem.getPath("/someNode/child", new String[0]);
        Path root = path.getRoot();
        Assert.assertEquals((String)"Did not return correct root", (Object)root.toString(), (Object)"/");
    }

    @Test
    public void getParent() {
        Path path = this.fileSystem.getPath("parent/child", new String[0]);
        Path parent = path.getParent();
        Assert.assertEquals((String)"Did not return correct parent", (Object)parent.toString(), (Object)"parent");
    }

    @Test
    public void getParentRelative() {
        Path path = this.fileSystem.getPath("relativeName", new String[0]);
        Path parent = path.getParent();
        Assert.assertNull((String)"Single node relative paths should have no parent", (Object)parent);
    }

    @Test
    public void getParentNested() {
        Path path = this.fileSystem.getPath("parent/child/grandchild", new String[0]);
        Path parent = path.getParent();
        Assert.assertEquals((String)"Did not return correct parent", (Object)parent.toString(), (Object)"parent/child");
    }

    @Test
    public void getParentAbsolute() {
        Path path = this.fileSystem.getPath("/parent/child/grandchild", new String[0]);
        Path parent = path.getParent();
        Assert.assertEquals((String)"Did not return correct parent", (Object)parent.toString(), (Object)"/parent/child");
    }

    @Test
    public void getParentRootIsNull() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Path parent = path.getParent();
        Assert.assertNull((String)"Parent of root should be null", (Object)parent);
    }

    @Test
    public void getFileName() {
        String location = "/dir/nestedDir/";
        String fileNameString = "fileName";
        Path path = this.fileSystem.getPath("/dir/nestedDir/fileName", new String[0]);
        Path fileName = path.getFileName();
        Assert.assertEquals((String)"File name was not as expected", (Object)"fileName", (Object)fileName.toString());
    }

    @Test
    public void getRootFileName() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Path fileName = path.getFileName();
        Assert.assertNull((String)"Root file name should be null", (Object)fileName);
    }

    @Test
    public void getRootNameCount() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        int count = path.getNameCount();
        Assert.assertEquals((String)"Root should have no name count", (long)0L, (long)count);
    }

    @Test
    public void getTopLevelNameCount() {
        Path path = this.fileSystem.getPath("/toplevel", new String[0]);
        int count = path.getNameCount();
        Assert.assertEquals((String)"Top-level element should have name count 1", (long)1L, (long)count);
    }

    @Test
    public void getTopLevelAppendedSlashNameCount() {
        Path path = this.fileSystem.getPath("/toplevel/", new String[0]);
        int count = path.getNameCount();
        Assert.assertEquals((String)"Top-level element should have name count 1", (long)1L, (long)count);
    }

    @Test
    public void getTopLevelNoPrecedingSlashNameCount() {
        Path path = this.fileSystem.getPath("toplevel/", new String[0]);
        int count = path.getNameCount();
        Assert.assertEquals((String)"Top-level element should have name count 1", (long)1L, (long)count);
    }

    @Test
    public void nestedNameCount() {
        Path path = this.fileSystem.getPath("toplevel/nested", new String[0]);
        int count = path.getNameCount();
        Assert.assertEquals((String)"nested-level element should have name count 2", (long)2L, (long)count);
    }

    @Test
    public void toAbsolutePath() {
        Path path = this.fileSystem.getPath("toplevel", new String[0]);
        Assert.assertEquals((String)"toAbsolute should return the absolute form of the Path", (Object)"/toplevel", (Object)path.toAbsolutePath().toString());
    }

    @Test
    public void toAbsolutePathAlreadyAbsolute() {
        String absolutePath = "/absolute";
        Path path = this.fileSystem.getPath("/absolute", new String[0]);
        Assert.assertEquals((String)"toAbsolute should return the absolute form of the Path", (Object)"/absolute", (Object)path.toAbsolutePath().toString());
    }

    @Test
    public void isAbsolute() {
        Path path = this.fileSystem.getPath("/absolute", new String[0]);
        Assert.assertTrue((boolean)path.isAbsolute());
    }

    @Test
    public void isAbsoluteFalse() {
        Path path = this.fileSystem.getPath("relative", new String[0]);
        Assert.assertFalse((boolean)path.isAbsolute());
    }

    @Test
    public void iterator() {
        Path path = this.fileSystem.getPath("toplevel/second/third/fourth", new String[0]);
        Iterator<Path> paths = path.iterator();
        Assert.assertEquals((Object)"/toplevel", (Object)paths.next().toString());
        Assert.assertEquals((Object)"/toplevel/second", (Object)paths.next().toString());
        Assert.assertEquals((Object)"/toplevel/second/third", (Object)paths.next().toString());
        Assert.assertEquals((Object)"/toplevel/second/third/fourth", (Object)paths.next().toString());
    }

    @Test
    public void iteratorRoot() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Iterator<Path> paths = path.iterator();
        Assert.assertFalse((String)"Iterator should not return root element", (boolean)paths.hasNext());
    }

    @Test
    public void toUri() {
        Path path = this.fileSystem.getPath("/toplevel/second", new String[0]);
        URI uri = path.toUri();
        String expected = "shrinkwrap://" + this.fileSystem.getArchive().getId() + path.toString();
        Assert.assertEquals((String)"toUri did not return form as expected", (Object)expected, (Object)uri.toString());
    }

    @Test
    public void getName() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        Path second = path.getName(2);
        Assert.assertEquals((Object)"/toplevel/second/third", (Object)second.toString());
    }

    @Test
    public void getNameRoot() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        Path second = path.getName(0);
        Assert.assertEquals((Object)"/toplevel", (Object)second.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathNegativeBegin() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(-1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathNegativeEnd() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(0, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathEndBeforeBegin() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(2, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathBeginTooLarge() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(4, 5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void subpathEndTooLarge() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(2, 4);
    }

    @Test
    public void subpath() {
        Path subpath = this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(1, 2);
        Assert.assertEquals((Object)"/toplevel/second", (Object)subpath.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void startsWithNullPathInput() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).startsWith((Path)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void startsWithNullStringInput() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).startsWith((String)null);
    }

    @Test
    public void startsWithOtherPathImpl() {
        boolean startsWith = this.fileSystem.getPath("/toplevel/second/third", new String[0]).startsWith(new MockPath());
        Assert.assertFalse((boolean)startsWith);
    }

    @Test
    public void startsWithOtherFs() throws IOException {
        FileSystem otherFs = ShrinkWrapFileSystems.newFileSystem((Archive)((Archive)ShrinkWrap.create(GenericArchive.class)));
        String pathName = "/toplevel/second";
        Path otherPath = otherFs.getPath("/toplevel/second", new String[0]);
        boolean startsWith = this.fileSystem.getPath("/toplevel/second", new String[0]).startsWith(otherPath);
        Assert.assertFalse((boolean)startsWith);
    }

    @Test
    public void startsWith() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/toplevel/second/", new String[0]));
        Assert.assertTrue((boolean)startsWith);
    }

    @Test
    public void startsWithRelative() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("toplevel/second/", new String[0]));
        Assert.assertTrue((boolean)startsWith);
    }

    @Test
    public void startsWithAbsolute() {
        Path path = this.fileSystem.getPath("toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/toplevel/second/third", new String[0]));
        Assert.assertFalse((String)"Other absolute pah and this relative path cannot match startsWith", (boolean)startsWith);
    }

    @Test
    public void startsWithString() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith("/toplevel/second/");
        Assert.assertTrue((boolean)startsWith);
    }

    @Test
    public void startsWithNegative() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/top", new String[0]));
        Assert.assertFalse((boolean)startsWith);
    }

    @Test
    public void startsWithBiggerThan() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/toplevel/second/third/fourth", new String[0]));
        Assert.assertFalse((boolean)startsWith);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void toFile() {
        this.fileSystem.getPath("/toplevel", new String[0]).toFile();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void register() throws IOException {
        this.fileSystem.getPath("/toplevel", new String[0]).register(null, new WatchEvent.Kind[]{null});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void registerLongform() throws IOException {
        this.fileSystem.getPath("/toplevel", new String[0]).register(null, new WatchEvent.Kind[]{null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void endsWithNullPathInput() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith((Path)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void endsWithNullStringInput() {
        this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith((String)null);
    }

    @Test
    public void endsWithOtherPathImpl() {
        boolean endsWith = this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith(new MockPath());
        Assert.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithOtherFs() throws IOException {
        FileSystem otherFs = ShrinkWrapFileSystems.newFileSystem((Archive)((Archive)ShrinkWrap.create(GenericArchive.class)));
        Path otherPath = otherFs.getPath("/otherpath", new String[0]);
        boolean endsWith = this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith(otherPath);
        Assert.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWith() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("third", new String[0]));
        Assert.assertTrue((String)"Should have identified path ends with last name component", (boolean)endsWith);
    }

    @Test
    public void endsString() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("third", new String[0]).toString());
        Assert.assertTrue((String)"Should have identified path ends with last name component", (boolean)endsWith);
    }

    @Test
    public void endsWithNested() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("second/third", new String[0]));
        Assert.assertTrue((String)"Should have identified path ends with last and penultimate name component", (boolean)endsWith);
    }

    @Test
    public void endsWithPartial() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("ird", new String[0]));
        Assert.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithIncorrectRoot() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("/third", new String[0]));
        Assert.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithNegative() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("/toplevel", new String[0]));
        Assert.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithBiggerThan() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("/toplevel/second/third/fourth", new String[0]));
        Assert.assertFalse((boolean)endsWith);
    }

    @Test
    public void toRealPath() throws IOException {
        String newPathName = "/toplevel/myAsset";
        this.fileSystem.getArchive().add((Asset)EmptyAsset.INSTANCE, "/toplevel/myAsset");
        Path path = this.fileSystem.getPath("/toplevel/myAsset", new String[0]);
        Path realPath = path.toRealPath(null);
        Assert.assertEquals((Object)path.toString(), (Object)realPath.toString());
    }

    @Test(expected=FileNotFoundException.class)
    public void toRealPathDoesntExist() throws IOException {
        String newPathName = "/toplevel/myAsset";
        Path path = this.fileSystem.getPath("/toplevel/myAsset", new String[0]);
        path.toRealPath(null);
    }

    @Test
    public void normalizeNoop() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path normalized = path.normalize();
        Assert.assertEquals((Object)path.toString(), (Object)normalized.toString());
    }

    @Test
    public void normalizeRelative() {
        Path path = this.fileSystem.getPath("a/b", new String[0]);
        Path normalized = path.normalize();
        Assert.assertEquals((Object)path.toString(), (Object)normalized.toString());
    }

    @Test
    public void normalizeCurrentDirRefs() {
        Path path = this.fileSystem.getPath("/a/./b/./c/d/./e", new String[0]);
        Path normalized = path.normalize();
        Assert.assertEquals((Object)"/a/b/c/d/e", (Object)normalized.toString());
    }

    @Test
    public void normalizeBackDirRefs() {
        Path path = this.fileSystem.getPath("/a/../b/./c/d/../e", new String[0]);
        Path normalized = path.normalize();
        Assert.assertEquals((Object)"/b/c/e", (Object)normalized.toString());
    }

    @Test
    public void relativizeSuperset() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path other = this.fileSystem.getPath("/a/b/c/d", new String[0]);
        Path relativized = path.relativize(other);
        Assert.assertEquals((Object)"c/d", (Object)relativized.toString());
    }

    @Test
    public void relativizeSuperset2() {
        Path path = this.fileSystem.getPath("/a/b/c", new String[0]);
        Path other = this.fileSystem.getPath("/a/b/c/d", new String[0]);
        Path relativized = path.relativize(other);
        Assert.assertEquals((Object)"d", (Object)relativized.toString());
    }

    @Test
    public void relativizeCommonNode() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path other = this.fileSystem.getPath("/a/c", new String[0]);
        Path relativized = path.relativize(other);
        Assert.assertEquals((Object)"../c", (Object)relativized.toString());
    }

    @Test
    public void relativizeCommonNode2() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path other = this.fileSystem.getPath("/a/c/d", new String[0]);
        Path relativized = path.relativize(other);
        Assert.assertEquals((Object)"../c/d", (Object)relativized.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void relativizeNull() {
        Path path = this.fileSystem.getPath("/toplevel/myAsset", new String[0]);
        path.relativize(null);
    }

    @Test
    public void resolve() {
        Path path = this.fileSystem.getPath("/topLevel/secondLevel", new String[0]);
        Path other = this.fileSystem.getPath("thirdLevel", new String[0]);
        Path resolved = path.resolve(other);
        Assert.assertEquals((String)"Resolve should join other to this", (Object)"/topLevel/secondLevel/thirdLevel", (Object)resolved.toString());
    }

    @Test
    public void resolveTrailingSlashOnThis() {
        Path path = this.fileSystem.getPath("/topLevel/secondLevel/", new String[0]);
        Path other = this.fileSystem.getPath("thirdLevel", new String[0]);
        Path resolved = path.resolve(other);
        Assert.assertEquals((String)"Resolve should join other to this", (Object)"/topLevel/secondLevel/thirdLevel", (Object)resolved.toString());
    }

    @Test
    public void resolveEmpty() {
        String thisLocation = "/topLevel/secondLevel";
        Path path = this.fileSystem.getPath("/topLevel/secondLevel", new String[0]);
        Path other = this.fileSystem.getPath("", new String[0]);
        Path resolved = path.resolve(other);
        Assert.assertEquals((String)"Resolve of empty path should return this path", (Object)"/topLevel/secondLevel", (Object)resolved.toString());
    }

    @Test
    public void resolveAbsolute() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolve(other);
        Assert.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveNull() {
        this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolve((Path)null);
    }

    @Test
    public void resolveString() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        String otherName = "/toplevel/myDir/myAsset";
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolve("/toplevel/myDir/myAsset");
        Assert.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveNullString() {
        this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolve((String)null);
    }

    @Test
    public void roundtripResolveRelativizeOfNormalizedPaths() {
        Path path = this.fileSystem.getPath("/a/b/f/../", new String[0]);
        Path other = this.fileSystem.getPath("a/b/../c", new String[0]);
        Path pathNormalized = path.normalize();
        Path otherNormalized = other.normalize();
        Assert.assertTrue((String)"Failed check that relativize undoes resolve, taking into account normalization", (boolean)pathNormalized.relativize(pathNormalized.resolve(otherNormalized)).equals(otherNormalized));
    }

    @Test
    public void resolveSibling() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolveSibling(other);
        Assert.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveSiblingNull() {
        this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolveSibling((Path)null);
    }

    @Test
    public void resolveSiblingString() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        String otherName = "/toplevel/myDir/myAsset";
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolveSibling("/toplevel/myDir/myAsset");
        Assert.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveSublingNullString() {
        this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolveSibling((String)null);
    }

    @Test
    public void compareToGreaterValue() {
        Path path = this.fileSystem.getPath("/toplevel/a", new String[0]);
        String otherName = "/toplevel/b";
        Path other = this.fileSystem.getPath("/toplevel/b", new String[0]);
        int compare = path.compareTo(other);
        Assert.assertEquals((long)-1L, (long)compare);
    }

    @Test
    public void compareToLesserValue() {
        Path path = this.fileSystem.getPath("/toplevel/b", new String[0]);
        String otherName = "/toplevel/a";
        Path other = this.fileSystem.getPath("/toplevel/a", new String[0]);
        int compare = path.compareTo(other);
        Assert.assertEquals((long)1L, (long)compare);
    }

    @Test
    public void compareToEqualValue() {
        Path path = this.fileSystem.getPath("/toplevel/a", new String[0]);
        String otherName = "/toplevel/a";
        Path other = this.fileSystem.getPath("/toplevel/a", new String[0]);
        int compare = path.compareTo(other);
        Assert.assertEquals((long)0L, (long)compare);
    }

    @Test(expected=IllegalArgumentException.class)
    public void compareToNull() throws IOException {
        this.fileSystem.getPath("/toplevel/a", new String[0]).compareTo(null);
    }
}

