/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapPath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathsTestCase {
    private static final Logger log = Logger.getLogger(PathsTestCase.class.getName());
    private FileSystem fs;
    private Archive<?> archive;

    @Before
    public void createFileSystem() throws IOException {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        this.fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
    }

    @After
    public void closeFileSystem() throws IOException {
        if (this.fs.isOpen()) {
            this.fs.close();
        }
    }

    @Test
    public void get() throws URISyntaxException {
        Path path = Paths.get(ShrinkWrapFileSystems.getRootUri(this.archive));
        Assert.assertTrue((String)"Wrong Path implementation returned", (boolean)(path instanceof ShrinkWrapPath));
        Assert.assertEquals((String)"Path returned is not correct", (Object)ArchivePaths.root().get(), (Object)path.toString());
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void getNonexistantFilesystem() throws URISyntaxException {
        Paths.get(new URI("shrinkwrap://fakeId"));
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void getClosedFilesystem() throws URISyntaxException, IOException {
        this.fs.close();
        Paths.get(ShrinkWrapFileSystems.getRootUri(this.archive));
    }
}

