/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.util.HashMap;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class ShrinkWrapFileSystemsTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void newFileSystemArchiveRequired() throws IOException {
        ShrinkWrapFileSystems.newFileSystem(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getRootUriArchiveRequired() {
        ShrinkWrapFileSystems.getRootUri(null);
    }

    @Test
    public void protocol() {
        Assert.assertEquals((String)"Protocol is not as expected", (Object)"shrinkwrap", (Object)"shrinkwrap");
    }

    @Test
    public void fsEnvKeyArchive() {
        Assert.assertEquals((String)"FS environment key for archives is not as expected", (Object)"archive", (Object)"archive");
    }

    @Test
    public void getRootUri() {
        GenericArchive archive = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        URI uri = ShrinkWrapFileSystems.getRootUri((Archive)archive);
        String expected = "shrinkwrap://" + archive.getId() + "/";
        Assert.assertEquals((String)"Root URI is not as expected", (Object)expected, (Object)uri.toString());
    }

    @Test
    public void newFileSystem() throws IOException {
        GenericArchive archive = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        ShrinkWrapFileSystem fs = (ShrinkWrapFileSystem)ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        Assert.assertNotNull((String)"Did not obtain a new File System as expected", (Object)fs);
        Assert.assertTrue((String)"Backing archive was not as expected", (archive == fs.getArchive() ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void noArchiveInEnvShouldResultInIAE() throws Exception {
        FileSystems.newFileSystem(ShrinkWrapFileSystems.getRootUri((Archive)((Archive)ShrinkWrap.create(JavaArchive.class))), new HashMap());
    }
}

