/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Before;

public abstract class AddPackageTestBase {
    private static final Logger LOG = Logger.getLogger(AddPackageTestBase.class.getName());
    protected Domain domain;
    private File tempFile;

    @Before
    public void setUp() throws IOException {
        Archive<?> archive = this.buildArchive();
        this.tempFile = File.createTempFile("test", archive instanceof WebArchive ? ".war" : ".jar");
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(this.tempFile, true);
        URL archiveUrl = this.tempFile.toURI().toURL();
        URLClassLoader archiveCl = this.buildArchiveClassLoader(archiveUrl);
        FilteringClassLoader shrinkwrapCl = new FilteringClassLoader(this.getClass().getClassLoader());
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.classLoaders(Arrays.asList(archiveCl, shrinkwrapCl));
        this.domain = ShrinkWrap.createDomain((Configuration)builder.build());
    }

    protected abstract Archive<?> buildArchive();

    protected URLClassLoader buildArchiveClassLoader(URL archiveUrl) {
        return new URLClassLoader(new URL[]{archiveUrl}, null);
    }

    @After
    public void tearDown() {
        if (this.tempFile.isFile() && !this.tempFile.delete()) {
            LOG.warning("Potential file leak: Could not delete " + this.tempFile);
        }
    }

    private static class FilteringClassLoader
    extends ClassLoader {
        private static final Enumeration<URL> EMPTY_ENUMERATION = new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }
        };

        public FilteringClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.contains("donotchange")) {
                return null;
            }
            return super.loadClass(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.contains("donotchange")) {
                return EMPTY_ENUMERATION;
            }
            return super.getResources(name);
        }
    }
}

