/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.After;
import org.junit.Before;

@ArchiveType(value=JavaArchive.class)
public class JavaArchiveImplTestCase
extends DynamicContainerTestBase<JavaArchive> {
    private static final ArchivePath PATH_MANIFEST = new BasicPath("META-INF");
    private static final ArchivePath PATH_CLASS = new BasicPath("/");
    private static final ArchivePath PATH_RESOURCE = new BasicPath();
    private JavaArchive archive;

    @Before
    public void createArchive() {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected JavaArchive getArchive() {
        return this.archive;
    }

    protected JavaArchive createNewArchive() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
    }

    @Override
    protected ResourceContainer<JavaArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ClassContainer<JavaArchive> getClassContainer() {
        return this.getArchive();
    }

    @Override
    protected ManifestContainer<JavaArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ServiceProviderContainer<JavaArchive> getServiceProviderContainer() {
        return this.getArchive();
    }

    @Override
    protected LibraryContainer<JavaArchive> getLibraryContainer() {
        throw new UnsupportedOperationException("JavaArchive does not support libraries");
    }

    @Override
    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected ArchivePath getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected ArchivePath getClassPath() {
        return PATH_CLASS;
    }

    @Override
    protected ArchivePath getLibraryPath() {
        throw new UnsupportedOperationException("JavaArchive does not support libraries");
    }

    @Override
    protected ArchiveFormat getExpectedArchiveFormat() {
        return ArchiveFormat.ZIP;
    }
}

