/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyClassForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyInterfaceForTest;
import org.junit.Test;

public abstract class DynamicWebContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    public abstract ArchivePath getWebPath();

    public abstract ArchivePath getWebInfPath();

    public abstract WebContainer<T> getWebContainer();

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLResource() throws Exception {
        this.getWebContainer().setWebXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLResourceInPackage() throws Exception {
        this.getWebContainer().setWebXML(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLFile() throws Exception {
        this.getWebContainer().setWebXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLURL() throws Exception {
        this.getWebContainer().setWebXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testSetWebXMLAsset() throws Exception {
        this.getWebContainer().setWebXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "web.xml");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceResource() throws Exception {
        this.getWebContainer().addAsWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceFile() throws Exception {
        this.getWebContainer().addAsWebResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getWebContainer().addAsWebResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getWebPath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetResource() throws Exception {
        this.getWebContainer().addAsWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetFile() throws Exception {
        this.getWebContainer().addAsWebResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetURL() throws Exception {
        this.getWebContainer().addAsWebResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourceStringTargetAsset() throws Exception {
        this.getWebContainer().addAsWebResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetResource() throws Exception {
        this.getWebContainer().addAsWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetFile() throws Exception {
        this.getWebContainer().addAsWebResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetURL() throws Exception {
        this.getWebContainer().addAsWebResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePathTargetAsset() throws Exception {
        this.getWebContainer().addAsWebResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackage() throws Exception {
        this.getWebContainer().addAsWebResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getWebPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackages() throws Exception {
        this.getWebContainer().addAsWebResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getWebPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getWebPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackageStringTarget() throws Exception {
        this.getWebContainer().addAsWebResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebResourcePackagePathTarget() throws Exception {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getWebContainer().addAsWebResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getWebPath(), targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceResource() throws Exception {
        this.getWebContainer().addAsWebInfResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceFile() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getWebContainer().addAsWebInfResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getWebInfPath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetResource() throws Exception {
        this.getWebContainer().addAsWebInfResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetFile() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetURL() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourceStringTargetAsset() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetResource() throws Exception {
        this.getWebContainer().addAsWebInfResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetFile() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetURL() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePathTargetAsset() throws Exception {
        this.getWebContainer().addAsWebInfResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackage() throws Exception {
        this.getWebContainer().addAsWebInfResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackages() throws Exception {
        this.getWebContainer().addAsWebInfResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getWebInfPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackageStringTarget() throws Exception {
        this.getWebContainer().addAsWebInfResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfResourcePackagePathTarget() throws Exception {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getWebContainer().addAsWebInfResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getWebInfPath(), targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebStringTargetResourceFromJar() throws Exception {
        this.getWebContainer().addAsWebResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getWebPath(), "String.class");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void testAddWebInfStringTargetResourceFromJar() throws Exception {
        this.getWebContainer().addAsWebInfResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getWebInfPath(), "String.class");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=WebContainer.class)
    public void canDeleteEmbeddedArchiveAddedAsLibrary() {
        String name = "test.jar";
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries(new Archive[]{((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)name)).add((Asset)EmptyAsset.INSTANCE, "some")});
        ArchivePath path = ArchivePaths.create((String)"WEB-INF/lib", (String)name);
        Assert.assertTrue((boolean)war.contains(path));
        war.delete(path);
        Assert.assertFalse((String)"Path should have been deleted", (boolean)war.contains(path));
    }

    @Override
    @Test
    public void testAddServiceProvider() throws Exception {
        ServiceProviderPathExposingWebArchive webArchive = new ServiceProviderPathExposingWebArchive((Archive)ShrinkWrap.create(WebArchive.class));
        webArchive.addAsServiceProvider(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        ArchivePath testPath = webArchive.getServiceProvidersPath();
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)webArchive.contains(testPath));
        testPath = new BasicPath(webArchive.getServiceProvidersPath(), DummyInterfaceForTest.class.getName());
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)webArchive.contains(testPath));
    }

    @Override
    @Test
    public void testAddServiceProviderString() throws Exception {
        String serviceInterface = "do.not.exist.api.Dummy";
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        ServiceProviderPathExposingWebArchive webArchive = new ServiceProviderPathExposingWebArchive((Archive)ShrinkWrap.create(WebArchive.class));
        webArchive.addAsServiceProvider(serviceInterface, impls);
        BasicPath testPath = new BasicPath(webArchive.getServiceProvidersPath(), "/do.not.exist.api.Dummy");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)webArchive.contains((ArchivePath)testPath));
        this.assertServiceProviderContent(webArchive.get((ArchivePath)testPath), impls);
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void testAddServiceProviderStringInterfaceValidation() throws Exception {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        ((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider(null, impls);
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void testAddServiceProviderStringImplementationsValidation() throws Exception {
        ((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider("do.not.exist.impl.Dummy", (String[])null);
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void testAddServiceProviderStringImplementationsValueValidation() throws Exception {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", null};
        ((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider("do.not.exist.impl.Dummy", impls);
    }

    @Override
    @Test
    @ArchiveType(value=ServiceProviderContainer.class)
    public void testAddServiceProviderWithClasses() throws Exception {
        Class[] expectedResources;
        ServiceProviderPathExposingWebArchive webArchive = new ServiceProviderPathExposingWebArchive((Archive)ShrinkWrap.create(WebArchive.class));
        webArchive.addAsServiceProviderAndClasses(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        ArchivePath testPath = webArchive.getServiceProvidersPath();
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)webArchive.contains(testPath));
        testPath = new BasicPath(webArchive.getServiceProvidersPath(), DummyInterfaceForTest.class.getName());
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)webArchive.contains(testPath));
        for (Class expectedResource : expectedResources = new Class[]{DummyInterfaceForTest.class, DummyClassForTest.class}) {
            BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((Class)expectedResource));
            Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)webArchive.contains((ArchivePath)expectedClassPath));
        }
    }

    private class ServiceProviderPathExposingWebArchive
    extends WebArchiveImpl {
        private ServiceProviderPathExposingWebArchive(Archive<?> delegate) {
            super(delegate);
        }

        public ArchivePath getServiceProvidersPath() {
            return super.getServiceProvidersPath();
        }
    }
}

