/*
 * Decompiled with CFR 0.152.
 */
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class DefaultPackageAddTestCase {
    private static final Logger log = Logger.getLogger(DefaultPackageAddTestCase.class.getName());
    private ArchivePath classInDefaultPackagePath;
    private ArchivePath innerClassInDefaultPackagePath;

    @BeforeEach
    public void setupPaths() {
        this.classInDefaultPackagePath = ArchivePaths.create((String)"/ClassInDefaultPackage.class");
        this.innerClassInDefaultPackagePath = ArchivePaths.create((String)"/ClassInDefaultPackage$InnerClassInDefaultPackage.class");
    }

    @AfterEach
    public void cleanupPaths() {
        this.classInDefaultPackagePath = null;
        this.innerClassInDefaultPackagePath = null;
    }

    @Test
    public void canAddClassFromDefaultPackage() {
        JavaArchive archive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClass(ClassInDefaultPackage.class);
        log.info(archive.toString(true));
        this.assertClassesWereAdded(archive);
    }

    @Disabled
    @Test
    public void testAddDefaultPackage() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addDefaultPackage();
        this.assertClassesWereAdded(archive);
        Assertions.assertEquals((int)3, (int)archive.getContent().size(), (String)("Not the expected number of assets added to the archive, CONTENT: " + archive.getContent()));
    }

    private void assertClassesWereAdded(JavaArchive archive) {
        Assertions.assertTrue((boolean)archive.contains(this.classInDefaultPackagePath), (String)"Class in default package was not added to archive");
        Assertions.assertTrue((boolean)archive.contains(this.innerClassInDefaultPackagePath), (String)"Inner class in default package was not added to archive");
    }
}

