/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConfigurationBuilderTestCase {
    private ConfigurationBuilder builder;

    @BeforeEach
    public void createDefaultBuilder() {
        this.builder = new ConfigurationBuilder();
    }

    @Test
    public void defaultsExecutorService() {
        this.builder.build();
        ExecutorService service = this.builder.getExecutorService();
        Assertions.assertNull((Object)service, (String)("The builder should not default an " + ExecutorService.class.getSimpleName()));
    }

    @Test
    public void defaultsExtensionLoader() {
        this.builder.build();
        ExtensionLoader loader = this.builder.getExtensionLoader();
        Assertions.assertNotNull((Object)loader, (String)("The builder should default an " + ExtensionLoader.class.getSimpleName()));
    }

    @Test
    public void allowsUserDefinedExecutorService() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        this.builder.executorService(service).build();
        Assertions.assertEquals((Object)service, (Object)this.builder.getExecutorService(), (String)("Building should not override the user-supplied " + ExecutorService.class.getSimpleName()));
    }

    @Test
    public void allowsUserDefinedExtensionLoader() {
        ExtensionLoader loader = new ExtensionLoader(){

            public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
                return null;
            }

            public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
                return null;
            }

            public <T extends Assignable> String getExtensionFromExtensionMapping(Class<T> type) {
                return null;
            }

            public <T extends Archive<T>> ArchiveFormat getArchiveFormatFromExtensionMapping(Class<T> extensionClass) {
                return null;
            }
        };
        this.builder.extensionLoader(loader).build();
        Assertions.assertEquals((Object)loader, (Object)this.builder.getExtensionLoader(), (String)("Building should not override the user-supplied " + ExtensionLoader.class.getSimpleName()));
    }

    @Test
    public void createsConfiguration() {
        Configuration configuration = this.builder.build();
        ExecutorService service = this.builder.getExecutorService();
        ExtensionLoader loader = this.builder.getExtensionLoader();
        Assertions.assertEquals((Object)service, (Object)configuration.getExecutorService(), (String)(ExecutorService.class.getSimpleName() + " in the config does not match that in the builder"));
        Assertions.assertEquals((Object)loader, (Object)configuration.getExtensionLoader(), (String)(ExtensionLoader.class.getSimpleName() + " in the config does not match that in the builder"));
    }
}

