/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FiltersTestCase {
    @Test
    public void shouldIncludeAll() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includeAll());
        Assertions.assertArrayEquals((Object[])paths.toArray(), (Object[])filteredPaths.toArray(), (String)"Should include all paths");
    }

    @Test
    public void shouldIncludePathRegExp() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.include((String)".*META-INF.*"));
        Assertions.assertEquals((int)1, (int)filteredPaths.size(), (String)"Should only contain one");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/META-INF/"), (Object)filteredPaths.get(0), (String)"Should only contain metainf");
    }

    @Test
    public void shouldExcludePathRegExp() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/META-INF/"), ArchivePaths.create((String)"/WEB-INF/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.exclude((String)".*META-INF.*"));
        Assertions.assertEquals((int)1, (int)filteredPaths.size(), (String)"Should only contain one");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/WEB-INF/"), (Object)filteredPaths.get(0), (String)"Should only contain webinf");
    }

    @Test
    public void shouldIncludePathsStringArray() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includePaths((String[])new String[]{"A", "B/"}));
        Assertions.assertEquals((int)2, (int)filteredPaths.size(), (String)"Should contain two");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/A"), (Object)filteredPaths.get(0), (String)"Should contain A");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/B"), (Object)filteredPaths.get(1), (String)"Should contain B");
    }

    @Test
    public void shouldIncludePathsCollection() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.includePaths(Arrays.asList("A", "B/")));
        Assertions.assertEquals((int)2, (int)filteredPaths.size(), (String)"Should contain two");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/A"), (Object)filteredPaths.get(0), (String)"Should contain A");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/B"), (Object)filteredPaths.get(1), (String)"Should contain B");
    }

    @Test
    public void shouldExcludePathsStringArray() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.excludePaths((String[])new String[]{"/A", "/B/"}));
        Assertions.assertEquals((int)1, (int)filteredPaths.size(), (String)"Should only contain one");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/C"), (Object)filteredPaths.get(0), (String)"Should only contain C");
    }

    @Test
    public void shouldExcludePathsCollection() {
        List<ArchivePath> paths = Arrays.asList(ArchivePaths.create((String)"/A"), ArchivePaths.create((String)"/B/"), ArchivePaths.create((String)"/C/"));
        List<ArchivePath> filteredPaths = this.executeFilter(ArchivePath.class, paths, Filters.excludePaths(Arrays.asList("/A", "/B/")));
        Assertions.assertEquals((int)1, (int)filteredPaths.size(), (String)"Should only contain one");
        Assertions.assertEquals((Object)ArchivePaths.create((String)"/C"), (Object)filteredPaths.get(0), (String)"Should only contain C");
    }

    private <T> List<T> executeFilter(Class<T> clazz, List<T> items, Filter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            if (!filter.include(item)) continue;
            result.add(item);
        }
        return result;
    }
}

