/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PreserveOrderOfEntriesTestCase {
    @Test
    public void canPreserveOrder() throws Exception {
        File target = new File("target");
        target.mkdirs();
        File testJar = new File(target, "test.jar");
        testJar.delete();
        if (testJar.exists()) {
            throw new Exception("Test setup failed");
        }
        ArrayList<String> expectedOrder = new ArrayList<String>();
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)testJar.getName());
        Random random = new Random(0L);
        for (int i = 0; i < 5; ++i) {
            String name = "f" + Long.toHexString(random.nextLong());
            expectedOrder.add(name);
            archive.addAsResource((Asset)new StringAsset("content"), name);
        }
        Assertions.assertEquals(expectedOrder, this.getPaths(archive));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(testJar, true);
        Assertions.assertTrue((boolean)testJar.exists());
        ArrayList<String> actualOrder = new ArrayList<String>();
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(testJar));
        ZipEntry nextEntry = zipInputStream.getNextEntry();
        while (nextEntry != null) {
            actualOrder.add(nextEntry.getName());
            nextEntry = zipInputStream.getNextEntry();
        }
        Assertions.assertEquals(expectedOrder, actualOrder);
        JavaArchive archive2 = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)testJar.getName());
        ((ZipImporter)archive2.as(ZipImporter.class)).importFrom(testJar);
        Assertions.assertEquals(expectedOrder, this.getPaths(archive2));
        testJar.delete();
    }

    private ArrayList<String> getPaths(JavaArchive archive2) {
        ArrayList<String> rc = new ArrayList<String>();
        for (ArchivePath path : archive2.getContent().keySet()) {
            String file = path.get();
            file = file.substring(1);
            rc.add(file);
        }
        return rc;
    }
}

