/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader;
import org.jboss.shrinkwrap.impl.base.TestSecurityActions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServiceExtensionLoaderTestCase {
    @Test
    public void shouldBeAbleToLoadExtension() {
        Extension extension = (Extension)this.createLoaderUsingTccl().load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertSame(extension.getClass(), ExtensionImpl.class);
    }

    @Test
    public void shouldBeAbleToOverrideExtension() {
        Extension extension = (Extension)this.createLoaderUsingTccl().addOverride(Extension.class, ExtensionImpl2.class).load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertSame(extension.getClass(), ExtensionImpl2.class);
    }

    @Test
    public void shouldBePlacedInCacheAfterLoad() {
        ServiceExtensionLoader loader = this.createLoaderUsingTccl();
        loader.load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assertions.assertTrue((boolean)loader.isCached(Extension.class), (String)"Should be placed in cache");
    }

    @Test
    public void shouldThrowExceptionOnMissingExtension() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            MissingExtension cfr_ignored_0 = (MissingExtension)this.createLoaderUsingTccl().load(MissingExtension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        });
    }

    @Test
    public void shouldThrowExceptionOnWrongImplType() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            WrongImplExtension cfr_ignored_0 = (WrongImplExtension)this.createLoaderUsingTccl().load(WrongImplExtension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        });
    }

    private ServiceExtensionLoader createLoaderUsingTccl() {
        ArrayList<ClassLoader> cls = new ArrayList<ClassLoader>(1);
        cls.add(TestSecurityActions.getThreadContextClassLoader());
        return new ServiceExtensionLoader(cls);
    }

    public static interface MissingExtension
    extends Assignable {
    }

    public static class ExtensionImpl2
    extends AssignableBase<Archive<?>>
    implements Extension {
        public ExtensionImpl2(Archive<?> archive) {
            super(archive);
        }
    }

    public static class ExtensionImpl
    extends AssignableBase<Archive<?>>
    implements Extension {
        public ExtensionImpl(Archive<?> archive) {
            super(archive);
        }
    }

    public static interface Extension
    extends Assignable {
    }

    public static interface WrongImplExtension
    extends Assignable {
    }
}

