/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFactory;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.UnknownExtensionTypeException;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.GenericArchiveImpl;
import org.jboss.shrinkwrap.impl.base.TestSecurityActions;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.importer.ZipContentAssertionDelegate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShrinkWrapTestCase {
    private static final ZipContentAssertionDelegate delegate = new ZipContentAssertionDelegate();
    private static final String NAME_FILE_NON_ZIP = "nonzipfile.txt";

    @Test
    public void createNewArchiveUnderDefaultDomain() {
        String archiveName = "test.war";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.war");
        Assertions.assertNotNull((Object)archive, (String)"A archive should have been created");
        Assertions.assertEquals((Object)"test.war", (Object)archive.getName(), (String)"Should have the same name as given input");
    }

    @Test
    public void createIsolatedDomains() {
        Domain domain1 = ShrinkWrap.createDomain();
        Domain domain2 = ShrinkWrap.createDomain();
        Assertions.assertNotNull((Object)domain1, (String)"Domain should exist");
        Assertions.assertNotNull((Object)domain2, (String)"Domain should exist");
        Assertions.assertNotSame((Object)domain1, (Object)domain2, (String)"Creation of domains should return new instances");
        Assertions.assertNotSame((Object)domain1.getConfiguration(), (Object)domain2.getConfiguration(), (String)"Creation of domains should have unique / isolated configurations");
    }

    @Test
    public void createDomainWithExplicitConfiguration() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MockExtensionLoader loader = new MockExtensionLoader();
        Domain domain = ShrinkWrap.createDomain((Configuration)new ConfigurationBuilder().executorService(service).extensionLoader((ExtensionLoader)loader).build());
        Assertions.assertEquals((Object)service, (Object)domain.getConfiguration().getExecutorService(), (String)(ExecutorService.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()));
        Assertions.assertEquals((Object)loader, (Object)domain.getConfiguration().getExtensionLoader(), (String)(ExtensionLoader.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()));
    }

    @Test
    public void createDomainWithExplicitConfigurationBuilder() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MockExtensionLoader loader = new MockExtensionLoader();
        Domain domain = ShrinkWrap.createDomain((ConfigurationBuilder)new ConfigurationBuilder().executorService(service).extensionLoader((ExtensionLoader)loader));
        Assertions.assertEquals((Object)service, (Object)domain.getConfiguration().getExecutorService(), (String)(ExecutorService.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()));
        Assertions.assertEquals((Object)loader, (Object)domain.getConfiguration().getExtensionLoader(), (String)(ExtensionLoader.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()));
    }

    @Test
    public void serviceExtensionLoadingUsesExplicitDomainClassLoader() {
        Class<CustomArchive> assignable = CustomArchive.class;
        try {
            ShrinkWrap.create(assignable);
        }
        catch (UnknownExtensionTypeException unknownExtensionTypeException) {
            // empty catch block
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(TestSecurityActions.getThreadContextClassLoader());
        classLoaders.add(new URLClassLoader(new URL[0]){

            @Override
            public InputStream getResourceAsStream(String name) {
                String thisClassName = this.getClass().getName().substring(0, this.getClass().getName().length() - 1);
                String searchName = "META-INF/services/" + thisClassName + CustomArchive.class.getSimpleName();
                if (name.equals(searchName)) {
                    return new ByteArrayInputStream(("implementingClassName=" + thisClassName + CustomArchiveImpl.class.getSimpleName() + "\nextension=.jar").getBytes());
                }
                return super.getResourceAsStream(name);
            }
        });
        ConfigurationBuilder builder = new ConfigurationBuilder().classLoaders(classLoaders);
        ArchiveFactory factory = ShrinkWrap.createDomain((ConfigurationBuilder)builder).getArchiveFactory();
        Assignable archive = factory.create(assignable);
        Assertions.assertNotNull((Object)archive, (String)"Archive using custom extension available in explicit CL should have been loaded");
    }

    @Test
    public void newDomainRequiresConfiguration() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShrinkWrap.createDomain((Configuration)null));
    }

    @Test
    public void newDomainRequiresConfigurationBuilder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShrinkWrap.createDomain((ConfigurationBuilder)null));
    }

    @Test
    public void getDefaultDomain() {
        Domain domain1 = ShrinkWrap.getDefaultDomain();
        Domain domain2 = ShrinkWrap.getDefaultDomain();
        Assertions.assertNotNull((Object)domain1, (String)"Domain should exist");
        Assertions.assertNotNull((Object)domain2, (String)"Domain should exist");
        Assertions.assertSame((Object)domain1, (Object)domain2, (String)"Obtaining the default domain should always return the same instance (idempotent operation)");
    }

    @Test
    public void shouldBeAbleToAddOverride() {
        Domain domain = ShrinkWrap.createDomain();
        domain.getConfiguration().getExtensionLoader().addOverride(JavaArchive.class, MockJavaArchiveImpl.class);
        JavaArchive archive = (JavaArchive)domain.getArchiveFactory().create(JavaArchive.class, "test.jar");
        Assertions.assertEquals(MockJavaArchiveImpl.class, archive.getClass(), (String)"Should have overridden normal JavaArchive impl");
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForJavaArchive() {
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        String archiveExtension = javaArchive.getName().substring(javaArchive.getName().lastIndexOf("."));
        Assertions.assertEquals((Object)".jar", (Object)archiveExtension, (String)"JavaArchive should have proper extension");
    }

    @Test
    public void shouldCreateJavaArchiveWithGivenName() {
        String archiveName = "testArchive";
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archiveName);
        Assertions.assertEquals((Object)archiveName, (Object)javaArchive.getName(), (String)"JavaArchive should have given name");
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForWebArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class);
        String archiveExtension = webArchive.getName().substring(webArchive.getName().lastIndexOf("."));
        Assertions.assertEquals((Object)".war", (Object)archiveExtension, (String)"WebArchive should have proper extension");
    }

    @Test
    public void shouldCreateWebArchiveWithGivenName() {
        String archiveName = "testArchive";
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)archiveName);
        Assertions.assertEquals((Object)archiveName, (Object)webArchive.getName(), (String)"WebArchive should have given name");
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForEnterpriseArchive() {
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class);
        String archiveExtension = enterpriseArchive.getName().substring(enterpriseArchive.getName().lastIndexOf("."));
        Assertions.assertEquals((Object)".ear", (Object)archiveExtension, (String)"EnterpriseArchive should have proper extension");
    }

    @Test
    public void shouldCreateEnterpriseArchiveWithGivenName() {
        String archiveName = "testArchive";
        EnterpriseArchive enterpriseArchive = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)archiveName);
        Assertions.assertEquals((Object)archiveName, (Object)enterpriseArchive.getName(), (String)"EnterpriseArchive should have given name");
    }

    @Test
    public void shouldCreateArchiveWithCorrectExtensionForResourceAdapterArchive() {
        ResourceAdapterArchive resourceAdapterArchive = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class);
        String archiveExtension = resourceAdapterArchive.getName().substring(resourceAdapterArchive.getName().lastIndexOf("."));
        Assertions.assertEquals((Object)".rar", (Object)archiveExtension, (String)"ResourceAdapterArchive should have proper extension");
    }

    @Test
    public void shouldCreateResourceAdapterArchiveWithGivenName() {
        String archiveName = "testArchive";
        ResourceAdapterArchive resourceAdapterArchive = (ResourceAdapterArchive)ShrinkWrap.create(ResourceAdapterArchive.class, (String)archiveName);
        Assertions.assertEquals((Object)archiveName, (Object)resourceAdapterArchive.getName(), (String)"ResourceAdapterArchive should have given name");
    }

    @Test
    public void shouldBeAbleToImportZipFileViaShrinkWrap() throws Exception {
        File testFile = delegate.getExistingResource();
        JavaArchive archive = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)testFile);
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        Assertions.assertEquals((Object)testFile.getName(), (Object)archive.getName(), (String)"name of the archive imported from a ZIP file was not as expected");
        delegate.assertContent((Archive<?>)archive, testFile);
    }

    @Test
    public void shouldBeAbleToImportZipFileViaArchiveFactory() throws Exception {
        File testFile = delegate.getExistingResource();
        JavaArchive archive = (JavaArchive)ShrinkWrap.getDefaultDomain().getArchiveFactory().createFromZipFile(JavaArchive.class, testFile);
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        Assertions.assertEquals((Object)testFile.getName(), (Object)archive.getName(), (String)"name of the archive imported from a ZIP file was not as expected");
        delegate.assertContent((Archive<?>)archive, testFile);
    }

    @Test
    public void importFromNonZipFileThrowsException() throws Exception {
        File nonZipFile = new File(TestSecurityActions.getThreadContextClassLoader().getResource(NAME_FILE_NON_ZIP).toURI());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)nonZipFile);
        });
    }

    @Test
    public void importFromNullFileThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, null);
        });
    }

    @Test
    public void importFromNonexistentFileThrowsException() {
        File file = new File("fileThatDoesntExist.tmp");
        Assertions.assertFalse((boolean)file.exists(), (String)("Error in test setup, file should not exist: " + file.getAbsolutePath()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, null);
        });
    }

    @Test
    public void shouldThrowExceptionOnNoConfiguredMappingForType() {
        Assertions.assertThrows(UnknownExtensionTypeException.class, () -> {
            MockAssignable cfr_ignored_0 = (MockAssignable)ShrinkWrap.create(MockAssignable.class);
        });
    }

    private static class MockAssignable
    implements Assignable {
        private MockAssignable() {
        }

        public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
            return null;
        }
    }

    public static class MockJavaArchiveImpl
    extends ContainerBase<JavaArchive>
    implements JavaArchive {
        public MockJavaArchiveImpl(Archive<?> archive) {
            super(JavaArchive.class, archive);
        }

        protected ArchivePath getClassesPath() {
            return ArchivePaths.root();
        }

        protected ArchivePath getLibraryPath() {
            return ArchivePaths.root();
        }

        protected ArchivePath getManifestPath() {
            return ArchivePaths.root();
        }

        protected ArchivePath getResourcePath() {
            return ArchivePaths.root();
        }

        public String toString(Formatter formatter) throws IllegalArgumentException {
            return formatter.format((Archive)this);
        }
    }

    private static class MockExtensionLoader
    implements ExtensionLoader {
        private MockExtensionLoader() {
        }

        public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
            return null;
        }

        public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
            return null;
        }

        public <T extends Assignable> String getExtensionFromExtensionMapping(Class<T> extensionClass) {
            return null;
        }

        public <T extends Archive<T>> ArchiveFormat getArchiveFormatFromExtensionMapping(Class<T> extensionClass) {
            return null;
        }
    }

    public static class CustomArchiveImpl
    extends GenericArchiveImpl
    implements CustomArchive {
        public CustomArchiveImpl(Archive<?> delegate) {
            super(delegate);
        }
    }

    public static interface CustomArchive
    extends Assignable {
    }
}

