/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssetUtilTestCase {
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";

    @Test
    public void shouldBeAbleToGetPathForClassloaderResource() {
        ArchivePath foundResourcePath = AssetUtil.getPathForClassloaderResource((String)EXISTING_RESOURCE);
        Assertions.assertEquals((Object)new BasicPath("org/jboss/shrinkwrap/impl/base/asset"), (Object)foundResourcePath, (String)"The classloader resource path should not contain the file name");
    }

    @Test
    public void shouldBeAbleToGetNameForClassloaderResource() {
        String foundResourceName = AssetUtil.getNameForClassloaderResource((String)EXISTING_RESOURCE);
        Assertions.assertEquals((Object)"Test.properties", (Object)foundResourceName, (String)"The classloader resource name should not contain the path");
    }

    @Test
    public void shouldBeAbleToGetFullPathForClassResource() {
        ArchivePath foundClassResourcePath = AssetUtil.getFullPathForClassResource(this.getClass());
        Assertions.assertEquals((Object)new BasicPath("/org/jboss/shrinkwrap/impl/base/asset/AssetUtilTestCase.class"), (Object)foundClassResourcePath, (String)"The class resource should have a / delimiter and a .class extension");
    }
}

