/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.InputStream;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServiceProviderAssetTestCase {
    @Test
    public void shouldCreateServiceProviderFile() {
        ServiceProviderAsset asset = new ServiceProviderAsset(new Class[]{TestImpl1.class, TestImpl2.class});
        byte[] expectedContent = (TestImpl1.class.getName() + "\n" + TestImpl2.class.getName() + "\n").getBytes();
        byte[] content = IOUtil.asByteArray((InputStream)asset.openStream());
        Assertions.assertArrayEquals((byte[])expectedContent, (byte[])content);
    }

    @Test
    public void shouldThrowExceptionOnNullArgument() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ServiceProviderAsset((Class[])null));
    }

    @Test
    public void shouldThrowExceptionOnNullArgumentValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ServiceProviderAsset(new Class[]{null}));
    }

    private class TestImpl2
    implements TestIF {
        private TestImpl2() {
        }
    }

    private class TestImpl1
    implements TestIF {
        private TestImpl1() {
        }
    }

    private static interface TestIF {
    }
}

