/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.classloader;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.classloader.LoadedTestClass;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShrinkWrapClassLoaderTestCase {
    private static final Logger log = Logger.getLogger(ShrinkWrapClassLoaderTestCase.class.getName());
    private static final Class<?> applicationClassLoaderClass = LoadedTestClass.class;
    private static final JavaArchive archive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(applicationClassLoaderClass);
    private ClassLoader shrinkWrapClassLoader;

    @BeforeEach
    public void createClassLoader() {
        this.shrinkWrapClassLoader = new ShrinkWrapClassLoader((ClassLoader)null, new Archive[]{archive});
    }

    @AfterEach
    public void closeClassLoader() {
        if (this.shrinkWrapClassLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.shrinkWrapClassLoader)).close();
            }
            catch (IOException e) {
                log.warning("Could not close the " + this.shrinkWrapClassLoader + ": " + e);
            }
        }
    }

    @Test
    public void shouldBeAbleToLoadClassFromArchive() throws ClassNotFoundException {
        Class<?> loadedTestClass = Class.forName(applicationClassLoaderClass.getName(), false, this.shrinkWrapClassLoader);
        ClassLoader loadedTestClassClassLoader = loadedTestClass.getClassLoader();
        log.info("Got " + loadedTestClass + " from " + loadedTestClassClassLoader);
        Assertions.assertNotNull(loadedTestClass, (String)"Test class could not be found via the ClassLoader");
        Assertions.assertSame((Object)this.shrinkWrapClassLoader, (Object)loadedTestClassClassLoader, (String)"Test class should have been loaded via the archive ClassLoader");
        Assertions.assertNotSame(loadedTestClass, applicationClassLoaderClass, (String)"Class Loaded from the CL should not be the same as the one on the appCL");
    }

    @Test
    public void shouldBeAbleToLoadClassFromWebArchive() throws ClassNotFoundException {
        WebArchive webArchive = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(applicationClassLoaderClass);
        ShrinkWrapClassLoader webArchiveClassLoader = new ShrinkWrapClassLoader((ClassLoader)null, "WEB-INF/classes", new Archive[]{webArchive});
        Class<?> loadedTestClass = Class.forName(applicationClassLoaderClass.getName(), false, (ClassLoader)webArchiveClassLoader);
        ClassLoader loadedTestClassClassLoader = loadedTestClass.getClassLoader();
        log.info("Got " + loadedTestClass + " from " + loadedTestClassClassLoader);
        Assertions.assertNotNull(loadedTestClass, (String)"Test class could not be found via the ClassLoader");
        Assertions.assertSame((Object)webArchiveClassLoader, (Object)loadedTestClassClassLoader, (String)"Test class should have been loaded via the web archive ClassLoader");
        Assertions.assertNotSame(loadedTestClass, applicationClassLoaderClass, (String)"Class Loaded from the CL should not be the same as the one on the appCL");
    }

    @Test
    public void shouldBeAbleToOpenStreamOnDirectoryUrl() throws IOException {
        String nestedResourceName = "nested/test";
        StringAsset testAsset = new StringAsset("testContent");
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)testAsset, "nested/test");
        ShrinkWrapClassLoader swCl = new ShrinkWrapClassLoader(new Archive[]{archive});
        URL nestedResourceUrl = swCl.getResource("nested/test");
        URL nestedResourceUpALevelUrl = new URL(nestedResourceUrl, "../");
        InputStream in = nestedResourceUpALevelUrl.openStream();
        Assertions.assertNull((Object)in, (String)"URLs pointing to a directory should openStream as null");
    }

    @Test
    public void shouldNotBeAbleToOpenStreamOnNonexistentAsset() throws IOException {
        String nestedResourceName = "nested/test";
        StringAsset testAsset = new StringAsset("testContent");
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)testAsset, "nested/test");
        ShrinkWrapClassLoader swCl = new ShrinkWrapClassLoader(new Archive[]{archive});
        URL nestedResourceUrl = swCl.getResource("nested/test");
        URL nestedResourceThatDoesntExistUrl = new URL(nestedResourceUrl, "../fake");
        Assertions.assertThrows(FileNotFoundException.class, nestedResourceThatDoesntExistUrl::openStream);
    }

    @Test
    public void shouldBeAbleToLoadResourceFromArchive() {
        URL resource = this.shrinkWrapClassLoader.getResource(ShrinkWrapClassLoaderTestCase.getResourceNameOfClass(applicationClassLoaderClass));
        Assertions.assertNotNull((Object)resource);
    }

    @Test
    public void shouldBeAbleToLoadAResourceFromArchiveMultipleTimes() throws Exception {
        String resourceName = ShrinkWrapClassLoaderTestCase.getResourceNameOfClass(applicationClassLoaderClass);
        URL resource = this.shrinkWrapClassLoader.getResource(resourceName);
        Assertions.assertNotNull((Object)resource);
        IOUtil.copyWithClose((InputStream)resource.openStream(), (OutputStream)new ByteArrayOutputStream());
        resource = this.shrinkWrapClassLoader.getResource(resourceName);
        Assertions.assertNotNull((Object)resource);
        IOUtil.copyWithClose((InputStream)resource.openStream(), (OutputStream)new ByteArrayOutputStream());
    }

    @Test
    public void shouldBeAbleToFindServiceProviderInWAR() throws Exception {
        WebArchive archive = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider(Cloneable.class, new Class[]{String.class});
        ShrinkWrapClassLoader cl = new ShrinkWrapClassLoader((ClassLoader)null, new Archive[]{archive});
        Enumeration found = cl.findResources("META-INF/services/java.lang.Cloneable");
        Assertions.assertTrue((boolean)found.hasMoreElements(), (String)"Service provider not found in WAR");
    }

    @Test
    public void shouldBeAbleToFindServiceProviderInWARWithSlash() throws Exception {
        WebArchive archive = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsServiceProvider(Cloneable.class, new Class[]{String.class});
        ShrinkWrapClassLoader cl = new ShrinkWrapClassLoader((ClassLoader)null, new Archive[]{archive});
        Enumeration found = cl.findResources("/META-INF/services/java.lang.Cloneable");
        Assertions.assertTrue((boolean)found.hasMoreElements(), (String)"Service provider not found in WAR");
    }

    private static String getResourceNameOfClass(Class<?> clazz) {
        assert (clazz != null) : "clazz must be specified";
        StringBuilder sb = new StringBuilder();
        String className = clazz.getName().replace('.', '/');
        sb.append(className);
        sb.append(".class");
        return sb.toString();
    }
}

