/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.exporter.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExplodedExporterTestCase
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(ExplodedExporterTestCase.class.getName());
    private static final String EXTENSION = ".jar";

    @Override
    protected String getArchiveExtension() {
        return EXTENSION;
    }

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return ZipExporter.class;
    }

    @Test
    public void testExportExploded() throws Exception {
        log.info("testExportExploded");
        File tempDirectory = this.createTempDirectory("testExportExploded");
        Archive<?> archive = this.createArchiveWithAssets();
        File explodedDirectory = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(tempDirectory);
        Assertions.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, archive.getName());
        Assertions.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        this.assertAssetInExploded(explodedDirectory, PATH_ONE, ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportExplodedChangingExplodedDirectoryName() throws Exception {
        log.info("testExportExploded");
        File tempDirectory = this.createTempDirectory("testExportExplodedChangingExplodedDirectoryName");
        Archive<?> archive = this.createArchiveWithAssets();
        File explodedDirectory = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(tempDirectory, "EXPLODEDtestArchive");
        Assertions.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, "EXPLODEDtestArchive");
        Assertions.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        this.assertAssetInExploded(explodedDirectory, PATH_ONE, ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportNestedExploded() throws Exception {
        log.info("testExportNestedExploded");
        File tempDirectory = this.createTempDirectory("testExportNestedExploded");
        Archive<?> archive = this.createArchiveWithNestedArchives();
        File explodedDirectory = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(tempDirectory);
        Assertions.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, archive.getName());
        Assertions.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        BasicPath nestedArchivePath = new BasicPath("nestedArchive" + this.getArchiveExtension());
        this.assertAssetInExploded(explodedDirectory, (ArchivePath)new BasicPath((ArchivePath)nestedArchivePath, PATH_ONE), ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, (ArchivePath)new BasicPath((ArchivePath)nestedArchivePath, PATH_TWO), ASSET_TWO);
        BasicPath nestedArchivePathTwo = new BasicPath(NESTED_PATH, "nestedArchive2" + this.getArchiveExtension());
        this.assertAssetInExploded(explodedDirectory, (ArchivePath)new BasicPath((ArchivePath)nestedArchivePathTwo, PATH_ONE), ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, (ArchivePath)new BasicPath((ArchivePath)nestedArchivePathTwo, PATH_TWO), ASSET_TWO);
    }

    @Test
    public void testExportExplodedIntoDirectory() throws Exception {
        log.info("testExportExplodedIntoDirectory");
        File tempDirectory = this.createTempDirectory("testExportExploded");
        Archive<?> archive = this.createArchiveWithAssets();
        File explodedDirectory = ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(tempDirectory);
        Assertions.assertNotNull((Object)explodedDirectory);
        Assertions.assertEquals((Object)tempDirectory, (Object)explodedDirectory);
        this.assertAssetInExploded(explodedDirectory, PATH_ONE, ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportExplodedRequiresBaseDirectory() {
        log.info("testExportExplodedRequiresBaseDirectory");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ExplodedExporter)ShrinkWrap.create(ExplodedExporter.class, (String)"test.jar")).exportExploded(null));
    }

    @Test
    public void testExportExplodedRequiresExistingDirectory() {
        log.info("testExportExplodedRequiresExistingDirectory");
        File directory = this.getNonexistentDirectory();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ExplodedExporter)ShrinkWrap.create(ExplodedExporter.class, (String)"test.jar")).exportExploded(directory));
    }

    @Test
    public void testExportExplodedRequiresValidDirectory() {
        log.info("testExportExplodedRequiresValidDirectory");
        File nonDirectory = new File(this.getTarget(), "tempFile.txt");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ExplodedExporter)ShrinkWrap.create(ExplodedExporter.class, (String)"test.jar")).exportExploded(nonDirectory));
    }

    @Test
    public void testExportExplodedOutputDirCreationFails() throws Exception {
        log.info("testExportExplodedOutputDirCreationFails");
        File directory = this.createTempDirectory("testExportExplodedOutpuDirCreationFails");
        directory.deleteOnExit();
        Assertions.assertThrows(ArchiveExportException.class, () -> ((ExplodedExporter)ShrinkWrap.create(ExplodedExporter.class, (String)"test/testArchive")).exportExploded(directory));
    }

    @Test
    public void testExportExplodedThrowsExceptionOnAssetWrite() throws Exception {
        log.info("testExportExplodedThrowsExceptionOnAssetWrite");
        Archive<?> archive = this.createArchiveWithAssets();
        archive.add(() -> {
            throw new RuntimeException("Mock Exception getting Stream");
        }, (ArchivePath)new BasicPath("badAsset"));
        File directory = this.createTempDirectory("testExportExplodedThrowsExceptionOnAssetWrite");
        Assertions.assertThrows(ArchiveExportException.class, () -> ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(directory));
    }

    @Test
    public void testShouldBeAbleToUseExistingDirectoryAsParent() {
        Archive<?> archive = this.createArchiveWithAssets();
        File existingParentFolder = new File("target/");
        existingParentFolder.mkdirs();
        Assertions.assertTrue((boolean)existingParentFolder.exists(), (String)"Internal error, the directory need to exist for test case to work");
        File archiveFolder = new File(existingParentFolder, archive.getName());
        archiveFolder.mkdirs();
        Assertions.assertTrue((boolean)existingParentFolder.exists(), (String)"Internal error, the directory need to exist for test case to work");
        ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExploded(existingParentFolder);
        Assertions.assertTrue((boolean)new File(existingParentFolder, archive.getName()).exists(), (String)"A subfolder with archive name should have been created");
    }

    @Test
    public void testExportExplodedOutputDirIsAFile() throws Exception {
        log.info("testExportExplodedOutputDirIsAFile");
        File directory = this.createTempDirectory("testExportExplodedOutpuDirIsAFile");
        File existingFile = new File(directory, "testArchive" + this.getArchiveExtension());
        boolean created = existingFile.createNewFile();
        IOUtil.copyWithClose((InputStream)new ByteArrayInputStream("test-test".getBytes()), (OutputStream)new FileOutputStream(existingFile));
        Assertions.assertTrue((boolean)created, (String)"Could not create test file");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ExplodedExporter)this.createArchiveWithAssets().as(ExplodedExporter.class)).exportExploded(directory));
    }

    private File getNonexistentDirectory() {
        File directory = new File(this.getTarget(), "someNonExistentDirectory");
        if (directory.exists()) {
            TestIOUtil.deleteDirectory(directory);
        }
        Assertions.assertFalse((boolean)directory.exists(), (String)("Precondition Failure: Directory should not exist: " + directory));
        return directory;
    }

    private void assertAssetInExploded(File explodedDirectory, ArchivePath path, Asset asset) throws FileNotFoundException {
        File assetFile = new File(explodedDirectory, path.get());
        Assertions.assertNotNull((Object)assetFile);
        Assertions.assertTrue((boolean)assetFile.exists());
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        FileInputStream inputStream = new FileInputStream(assetFile);
        byte[] actualContents = IOUtil.asByteArray((InputStream)inputStream);
        Assertions.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }
}

