/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.exporter.FileExistsException;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.exporter.StreamExporterTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ZipExporterTestCase
extends StreamExporterTestBase<ZipImporter> {
    private static final String EXTENSION = ".jar";

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return ZipExporter.class;
    }

    @Override
    protected Class<ZipImporter> getImporterClass() {
        return ZipImporter.class;
    }

    @Override
    protected void ensureInExpectedForm(File file) throws IOException {
        assert (file != null) : "file must be specified";
        ZipFile zip = new ZipFile(file);
        this.ensureZipFileInExpectedForm(zip);
    }

    @Override
    protected InputStream getContentsFromExportedFile(File file, ArchivePath path) throws IOException {
        assert (file != null) : "file must be specified";
        assert (path != null) : "path must be specified";
        ZipFile zipFile = new ZipFile(file);
        ZipEntry entry = zipFile.getEntry(PathUtil.optionallyRemovePrecedingSlash((String)path.get()));
        if (entry == null) {
            return null;
        }
        byte[] actualContents = IOUtil.asByteArray((InputStream)zipFile.getInputStream(entry));
        return new ByteArrayInputStream(actualContents);
    }

    @Override
    protected String getArchiveExtension() {
        return EXTENSION;
    }

    @Test
    public void exportEmptyArchiveAsZip() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ZipExporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"testArchive")).as(ZipExporter.class)).exportAsInputStream());
    }

    @Test
    public void exportShouldFailIfTargetExist() throws IOException {
        File target = new File(this.createTempDirectory("exportShouldFailIfTargetExist").getAbsolutePath() + "exportShouldFailIfTargetExist.jar");
        if (target.exists()) {
            Assertions.assertTrue((boolean)target.delete());
        }
        Assertions.assertFalse((boolean)target.exists());
        ((ZipExporter)this.createArchiveWithAssets().as(ZipExporter.class)).exportTo(target);
        Assertions.assertTrue((boolean)target.exists());
        Assertions.assertThrows(FileExistsException.class, () -> ((ZipExporter)this.createArchiveWithAssets().as(ZipExporter.class)).exportTo(target), (String)"Expected a FileExistsException when exporting to an existing path");
    }

    @Test
    public void testExportImportExport() {
        File target = new File("target");
        File testClasses = new File(target, "test-classes");
        File hsqldbJar = new File(testClasses, "hsqldb.jar");
        Assertions.assertTrue((hsqldbJar.exists() && !hsqldbJar.isDirectory() ? 1 : 0) != 0, (String)"test JAR must exist to run this test");
        File file1 = new File(target, "testExportImportExport1.war");
        File file2 = new File(target, "testExportImportExport2.war");
        WebArchive webArchive = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).add((Asset)new FileAsset(hsqldbJar), "/WEB-INF/lib/hsqldb.jar");
        ((ZipExporter)webArchive.as(ZipExporter.class)).exportTo(file1, true);
        WebArchive webArchive2 = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)file1);
        ((ZipExporter)webArchive2.as(ZipExporter.class)).exportTo(file2, true);
        Assertions.assertEquals((long)file1.length(), (long)file2.length());
    }

    private void ensureZipFileInExpectedForm(ZipFile expectedZip) throws IOException {
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
        this.getEntryFromZip(expectedZip, NESTED_PATH);
        ZipEntry rootEntry = expectedZip.getEntry("/");
        Assertions.assertNull((Object)rootEntry, (String)"ZIP should not have explicit root path written (SHRINKWRAP-96)");
    }

    private void assertAssetInZip(ZipFile expectedZip, ArchivePath path, Asset asset) throws IllegalArgumentException, IOException {
        ZipEntry entry = this.getEntryFromZip(expectedZip, path);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        byte[] actualContents = IOUtil.asByteArray((InputStream)expectedZip.getInputStream(entry));
        Assertions.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    private ZipEntry getEntryFromZip(ZipFile expectedZip, ArchivePath path) throws IllegalArgumentException {
        String entryPath = PathUtil.optionallyRemovePrecedingSlash((String)path.get());
        ZipEntry entry = expectedZip.getEntry(entryPath);
        Assertions.assertNotNull((Object)entry, (String)("Expected path not found in ZIP: " + path));
        return entry;
    }
}

