/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.ZipStoredExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.exporter.StreamExporterTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ZipStoredExporterTestCase
extends StreamExporterTestBase<ZipImporter> {
    private static final String EXTENSION = ".jar";

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return ZipStoredExporter.class;
    }

    @Override
    protected Class<ZipImporter> getImporterClass() {
        return ZipImporter.class;
    }

    @Override
    protected void ensureInExpectedForm(File file) throws IOException {
        assert (file != null) : "file must be specified";
        ZipFile zip = new ZipFile(file);
        this.ensureZipFileInExpectedForm(zip);
    }

    @Override
    protected InputStream getContentsFromExportedFile(File file, ArchivePath path) throws IOException {
        assert (file != null) : "file must be specified";
        assert (path != null) : "path must be specified";
        ZipFile zipFile = new ZipFile(file);
        ZipEntry entry = zipFile.getEntry(PathUtil.optionallyRemovePrecedingSlash((String)path.get()));
        if (entry == null) {
            return null;
        }
        byte[] actualContents = IOUtil.asByteArray((InputStream)zipFile.getInputStream(entry));
        return new ByteArrayInputStream(actualContents);
    }

    @Override
    protected String getArchiveExtension() {
        return EXTENSION;
    }

    @Test
    public void shouldExportToStoredZip() throws IOException {
        File target = new File("target");
        ((ZipStoredExporter)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(ZipStoredExporterTestCase.class)).add((Asset)new StringAsset("My file content"), "content.txt")).as(ZipStoredExporter.class)).exportTo(new File(target, "test-exporter.zip"), true);
        File generatedFile = new File(target, "test-exporter.zip");
        Assertions.assertTrue((generatedFile.length() > 0L ? 1 : 0) != 0);
        InputStream contentsFromExportedFile = this.getContentsFromExportedFile(generatedFile, ArchivePaths.create((String)"/org/jboss/shrinkwrap/impl/base/exporter/ZipStoredExporterTestCase.class"));
        byte[] content = IOUtil.asByteArray((InputStream)contentsFromExportedFile);
        Assertions.assertTrue((content.length > 0 ? 1 : 0) != 0);
        InputStream contentsFromExportedFile2 = this.getContentsFromExportedFile(generatedFile, ArchivePaths.create((String)"/content.txt"));
        byte[] content2 = IOUtil.asByteArray((InputStream)contentsFromExportedFile2);
        Assertions.assertTrue((content.length > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"My file content", (Object)new String(content2));
    }

    private void ensureZipFileInExpectedForm(ZipFile expectedZip) throws IOException {
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
        this.getEntryFromZip(expectedZip, NESTED_PATH);
        ZipEntry rootEntry = expectedZip.getEntry("/");
        Assertions.assertNull((Object)rootEntry, (String)"ZIP should not have explicit root path written (SHRINKWRAP-96)");
    }

    private void assertAssetInZip(ZipFile expectedZip, ArchivePath path, Asset asset) throws IllegalArgumentException, IOException {
        ZipEntry entry = this.getEntryFromZip(expectedZip, path);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        byte[] actualContents = IOUtil.asByteArray((InputStream)expectedZip.getInputStream(entry));
        Assertions.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    private ZipEntry getEntryFromZip(ZipFile expectedZip, ArchivePath path) throws IllegalArgumentException {
        String entryPath = PathUtil.optionallyRemovePrecedingSlash((String)path.get());
        ZipEntry entry = expectedZip.getEntry(entryPath);
        Assertions.assertNotNull((Object)entry, (String)("Expected path not found in ZIP: " + path));
        return entry;
    }
}

