/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.formatter;

import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class FormatterTestBase {
    private static final Logger log = Logger.getLogger(FormatterTestBase.class.getName());
    static final String NAME_ARCHIVE = "testArchive.jar";
    private Archive<?> archive;

    @BeforeEach
    public void createArchive() {
        this.archive = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)NAME_ARCHIVE)).addClasses(new Class[]{FormatterTestBase.class, ArchiveTestBase.class});
    }

    @Test
    public void testFormatter() {
        String formatted = this.archive.toString(this.getFormatter());
        log.info(formatted);
        Assertions.assertEquals((Object)this.getExpectedOutput(), (Object)formatted, (String)"Formatter output did not match that expected");
    }

    abstract Formatter getFormatter();

    abstract String getExpectedOutput();
}

