/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.importer.SecurityActions;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ExplodedImporterTestCase {
    private static final String EXISTING_DIRECTORY_RESOURCE = "exploded_import_test";
    private static final String EXISTING_FILE_RESOURCE = "exploded_import_test/Test.properties";
    private static final String EMPTY_DIR_NAME = "empty_dir";
    private static final String PARENT_DIR_NAME = "parent";

    @BeforeAll
    public static void makeEmptyDirectories() throws URISyntaxException {
        File root = new File(ExplodedImporterTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        File explodedImportTest = new File(root, EXISTING_DIRECTORY_RESOURCE);
        Assertions.assertTrue((boolean)explodedImportTest.exists(), (String)("Import test folder does not exist: " + explodedImportTest.getAbsolutePath()));
        File empty = new File(explodedImportTest, EMPTY_DIR_NAME);
        Assertions.assertTrue((boolean)empty.mkdir(), (String)"Could not create the empty directory");
        File parent = new File(explodedImportTest, PARENT_DIR_NAME);
        File parentEmpty = new File(parent, EMPTY_DIR_NAME);
        Assertions.assertTrue((boolean)parentEmpty.mkdirs(), (String)"Could not create the parent empty directory");
        parentEmpty.deleteOnExit();
        empty.deleteOnExit();
    }

    @Test
    public void shouldBeAbleToImportADirectory() throws Exception {
        Archive archive = (Archive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"test.jar")).importDirectory(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_DIRECTORY_RESOURCE).toURI().getPath()).as(JavaArchive.class);
        Logger.getLogger(ExplodedImporterTestCase.class.getName()).info(archive.toString(true));
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/Test.properties")), (String)"Root files should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/META-INF/MANIFEST.FM")), (String)"Nested files should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/org/jboss/Test.properties")), (String)"Nested files should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/empty_dir")), (String)"Empty directories should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/parent/empty_dir")), (String)"Nested empty directories should be imported");
    }

    @Test
    public void shouldThrowExceptionIfImportingAFile() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"test.jar")).importDirectory(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_FILE_RESOURCE).toURI().getPath()));
    }

    @Test
    public void shouldBeAbleToImportADirectoryWithIncludeFilter() throws Exception {
        String fileName = SecurityActions.getThreadContextClassLoader().getResource(EXISTING_DIRECTORY_RESOURCE).toURI().getPath();
        Archive archive = (Archive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"test.jar")).importDirectory(fileName, Filters.include((String)".*META-INF.*")).as(JavaArchive.class);
        Logger.getLogger(ExplodedImporterTestCase.class.getName()).info(archive.toString(true));
        Assertions.assertEquals((int)2, (int)archive.getContent().size(), (String)"Archive should contains only 2 paths");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/META-INF/MANIFEST.FM")), (String)"Nested files should be imported");
    }

    @Test
    public void shouldBeAbleToImportADirectoryWithExcludeFilter() throws Exception {
        String fileName = SecurityActions.getThreadContextClassLoader().getResource(EXISTING_DIRECTORY_RESOURCE).toURI().getPath();
        Archive archive = (Archive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"test.jar")).importDirectory(fileName, Filters.exclude((String)".*META-INF.*")).as(JavaArchive.class);
        Logger.getLogger(ExplodedImporterTestCase.class.getName()).info(archive.toString(true));
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/Test.properties")), (String)"Root files should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/org/jboss/Test.properties")), (String)"Nested files should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/empty_dir")), (String)"Empty directories should be imported");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)new BasicPath("/parent/empty_dir")), (String)"Nested empty directories should be imported");
    }

    @Test
    public void shouldHaveEmptyDefaultExtension() {
        ExplodedImporter explodedImporter = (ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class);
        String explodedImporterArchiveName = ((JavaArchive)explodedImporter.as(JavaArchive.class)).getName();
        Assertions.assertFalse((boolean)explodedImporterArchiveName.contains("."));
    }

    @Test
    public void shouldImportDirectory() throws Exception {
        this.shouldImportDirectory("arbitraryDirectory");
    }

    @Test
    public void shouldImportDirectoryWithNameThatCouldCauseRegexPatternSyntaxException() throws Exception {
        this.shouldImportDirectory("[deploymentExportPath");
    }

    @Test
    public void shouldImportDirectoryWithBracketsInPath() throws Exception {
        this.shouldImportDirectory("[deploymentExportPath]");
    }

    private void shouldImportDirectory(String subdirectory) throws Exception {
        String fileName = SecurityActions.getThreadContextClassLoader().getResource(EXISTING_DIRECTORY_RESOURCE).toURI().getPath();
        File importDirectory = new File(fileName, subdirectory);
        if (!importDirectory.exists()) {
            Assertions.assertTrue((boolean)importDirectory.mkdir(), (String)("Unable to create test folder: " + importDirectory.getAbsolutePath()));
        }
        Assertions.assertTrue((boolean)importDirectory.exists(), (String)("Import test folder does not exist: " + importDirectory.getAbsolutePath()));
        importDirectory.deleteOnExit();
        ((ExplodedExporter)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test.war")).addClass(ExplodedImporter.class)).setWebXML((Asset)new StringAsset("<web-app></web-app>"))).as(ExplodedExporter.class)).exportExploded(importDirectory);
        WebArchive war = (WebArchive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"SHRINKWRAP-453.war")).as(ExplodedImporter.class)).importDirectory(importDirectory).as(WebArchive.class);
        Assertions.assertTrue((boolean)war.contains("/test.war"), (String)"Expected imported web archive to be present at web archive root");
        Assertions.assertTrue((boolean)war.contains("/test.war/WEB-INF/web.xml"), (String)"Expected imported web archive to include web.xml");
    }
}

