/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.StreamImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class StreamImporterImplTestBase<T extends StreamImporter<T>> {
    private static final Logger log = Logger.getLogger(StreamImporterImplTestBase.class.getName());
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";

    protected abstract ContentAssertionDelegateBase getDelegate();

    protected abstract Class<T> getImporterClass();

    protected abstract Class<? extends StreamExporter> getExporterClass();

    protected abstract InputStream getExceptionThrowingInputStream();

    protected abstract ArchiveFormat getArchiveFormat();

    @Test
    public void shouldBeAbleToImportFile() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        Archive archive = (Archive)((StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar")).importFrom(testFile).as(JavaArchive.class);
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        delegate.assertContent(archive, testFile);
    }

    @Test
    public void shouldBeAbleToImportFileWithFilter() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        Archive archive = (Archive)((StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar")).importFrom(testFile, Filters.include((String)".*MANIFEST\\.MF")).as(JavaArchive.class);
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        Assertions.assertEquals((int)2, (int)archive.getContent().size());
        Assertions.assertTrue((boolean)archive.contains(ArchivePaths.create((String)"META-INF/MANIFEST.MF")));
    }

    @Test
    public void shouldNotBeAbleToImportDirectory() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testDir = delegate.getExistingResource().getParentFile();
        Class importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StreamImporter)ShrinkWrap.create((Class)importerClass, (String)"test.jar")).importFrom(testDir), (String)"Should have received IllegalArgumentException on attempt to import a dir");
    }

    @Test
    public void shouldBeAbleToImportAddAndExport() throws Exception {
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        Archive archive = (Archive)((StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar")).importFrom(testFile).as(JavaArchive.class);
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        archive.add((Asset)new ClassLoaderAsset(EXISTING_RESOURCE), ArchivePaths.create((String)"test.properties"));
        File tempFile = new File("target/testOutput");
        tempFile.deleteOnExit();
        Class<StreamExporter> exporterClass = this.getExporterClass();
        Assertions.assertNotNull(exporterClass, (String)"Exporter class must be specified by implementations");
        InputStream stream = ((StreamExporter)archive.as(exporterClass)).exportAsInputStream();
        IOUtil.copyWithClose((InputStream)stream, (OutputStream)new FileOutputStream(tempFile));
        delegate.assertContent(archive, tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToImportInputStream() throws Exception {
        Archive archive;
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        FileInputStream stream = new FileInputStream(testFile);
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        StreamImporter importer = (StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar");
        try {
            archive = (Archive)importer.importFrom((InputStream)stream).as(GenericArchive.class);
        }
        finally {
            ((InputStream)stream).close();
        }
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        delegate.assertContent(archive, testFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToImportInputStreamWithFilter() throws Exception {
        Archive archive;
        ContentAssertionDelegateBase delegate = this.getDelegate();
        assert (delegate != null) : "Delegate must be specified by implementations";
        File testFile = delegate.getExistingResource();
        FileInputStream stream = new FileInputStream(testFile);
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        StreamImporter importer = (StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar");
        try {
            archive = (Archive)importer.importFrom((InputStream)stream, Filters.include((String)".*MANIFEST\\.MF")).as(GenericArchive.class);
        }
        finally {
            ((InputStream)stream).close();
        }
        Assertions.assertNotNull((Object)archive, (String)"Should not return a null archive");
        Assertions.assertEquals((int)2, (int)archive.getContent().size());
        Assertions.assertTrue((boolean)archive.contains(ArchivePaths.create((String)"META-INF/MANIFEST.MF")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowExceptionOnErrorInImportFromStream() throws Exception {
        InputStream exceptionIn = this.getExceptionThrowingInputStream();
        Class<T> importerClass = this.getImporterClass();
        assert (importerClass != null) : "Importer class must be specified by implementations";
        StreamImporter importer = (StreamImporter)ShrinkWrap.create(importerClass, (String)"test.jar");
        try {
            Assertions.assertThrows(ArchiveImportException.class, () -> {
                GenericArchive cfr_ignored_0 = (GenericArchive)importer.importFrom(exceptionIn).as(GenericArchive.class);
            });
        }
        finally {
            exceptionIn.close();
        }
    }

    @Test
    public void canRoundTrip() {
        String embeddedArchiveName = "lib.jar";
        String emptyFileName = "empty.file";
        JavaArchive embeddedArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"lib.jar")).add((Asset)EmptyAsset.INSTANCE, "empty.file");
        WebArchive outerArchive = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries(new Archive[]{embeddedArchive});
        JavaArchive roundtrip = (JavaArchive)outerArchive.getAsType(JavaArchive.class, ArchivePaths.create((String)"WEB-INF/lib", (String)"lib.jar"), this.getArchiveFormat());
        Assertions.assertNotNull((Object)roundtrip, (String)"roundtrip could not be obtained");
        Assertions.assertTrue((boolean)roundtrip.contains("empty.file"), (String)"contents of embedded archive are not intact after roundtrip");
    }
}

