/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.exporter.TarBz2Exporter;
import org.jboss.shrinkwrap.api.importer.TarBz2Importer;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.importer.StreamImporterImplTestBase;
import org.jboss.shrinkwrap.impl.base.importer.TarBz2ContentAssertionDelegate;
import org.jboss.shrinkwrap.impl.base.io.tar.TarBzInputStream;
import org.jboss.shrinkwrap.impl.base.io.tar.bzip.BZip2CompressorOutputStream;

public class TarBz2ImporterImplTestCase
extends StreamImporterImplTestBase<TarBz2Importer> {
    private static final TarBz2ContentAssertionDelegate delegate = new TarBz2ContentAssertionDelegate();

    @Override
    protected ContentAssertionDelegateBase getDelegate() {
        return delegate;
    }

    @Override
    protected Class<TarBz2Importer> getImporterClass() {
        return TarBz2Importer.class;
    }

    @Override
    protected Class<? extends StreamExporter> getExporterClass() {
        return TarBz2Exporter.class;
    }

    protected TarBzInputStream getExceptionThrowingInputStream() {
        try {
            return ExceptionThrowingTarBzInputStream.create();
        }
        catch (IOException e) {
            throw new RuntimeException("Should not occur in test setup", e);
        }
    }

    @Override
    protected ArchiveFormat getArchiveFormat() {
        return ArchiveFormat.TAR_BZ;
    }

    private static final class ExceptionThrowingTarBzInputStream
    extends TarBzInputStream {
        static ExceptionThrowingTarBzInputStream create() throws IOException {
            byte[] test = "Something more realistic than a single word".getBytes();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BZip2CompressorOutputStream compressorOutputStream = new BZip2CompressorOutputStream((OutputStream)stream);
            compressorOutputStream.write(test);
            compressorOutputStream.close();
            ByteArrayInputStream in = new ByteArrayInputStream(stream.toByteArray());
            return new ExceptionThrowingTarBzInputStream(in);
        }

        private ExceptionThrowingTarBzInputStream(InputStream in) throws IOException {
            super(in);
        }

        public int read() {
            throw new RuntimeException("Mock Exception, should be wrapped in the import process");
        }
    }
}

