/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.io.tar.TarEntry;
import org.jboss.shrinkwrap.impl.base.io.tar.TarInputStream;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.jupiter.api.Assertions;

public class TarContentAssertionDelegate
extends ContentAssertionDelegateBase {
    private static final Logger log = Logger.getLogger(TarContentAssertionDelegate.class.getName());
    private static final String EXISTING_TAR_RESOURCE = "test.tar";

    @Override
    public void assertContent(Archive<?> importedArchive, File originalSource) throws Exception {
        TarEntry originalEntry;
        Assertions.assertFalse((boolean)importedArchive.getContent().isEmpty(), (String)"Should have imported something");
        boolean containsEmptyDir = false;
        boolean containsEmptyNestedDir = false;
        TarInputStream stream = new TarInputStream((InputStream)new FileInputStream(originalSource));
        while ((originalEntry = stream.getNextEntry()) != null) {
            int readBytes;
            if (originalEntry.isDirectory()) {
                String originalEntryName = PathUtil.optionallyAppendSlash((String)originalEntry.getName());
                log.info(originalEntryName);
                if (originalEntryName.equals("empty_dir/")) {
                    containsEmptyDir = true;
                }
                if (!originalEntryName.equals("parent/empty_dir/")) continue;
                containsEmptyNestedDir = true;
                continue;
            }
            ArchivePath entryName = ArchivePaths.create((String)originalEntry.getName());
            Assertions.assertTrue((boolean)importedArchive.contains(entryName), (String)("Importer should have imported " + entryName.get() + " from " + originalSource));
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            byte[] content = new byte[4096];
            while ((readBytes = stream.read(content, 0, content.length)) != -1) {
                output.write(content, 0, readBytes);
            }
            byte[] originalContent = output.toByteArray();
            Node node = importedArchive.get(entryName);
            byte[] importedContent = IOUtil.asByteArray((InputStream)node.getAsset().openStream());
            Assertions.assertArrayEquals((byte[])importedContent, (byte[])originalContent, (String)("The content of " + originalSource.getName() + " should be equal to the imported content"));
        }
        Assertions.assertTrue((boolean)containsEmptyDir, (String)"Empty directory not imported");
        Assertions.assertTrue((boolean)containsEmptyNestedDir, (String)"Empty nested directory not imported");
    }

    @Override
    protected String getExistingResourceName() {
        return EXISTING_TAR_RESOURCE;
    }
}

