/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.impl.base.importer.ContentAssertionDelegateBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.jupiter.api.Assertions;

public class ZipContentAssertionDelegate
extends ContentAssertionDelegateBase {
    private static final String EXISTING_ZIP_RESOURCE = "org/jboss/shrinkwrap/impl/base/importer/test.zip";

    @Override
    public void assertContent(Archive<?> importedArchive, File originalSource) throws Exception {
        Assertions.assertFalse((boolean)importedArchive.getContent().isEmpty(), (String)"Should have imported something");
        ZipFile testZip = new ZipFile(originalSource);
        ArrayList<? extends ZipEntry> entries = Collections.list(testZip.entries());
        Assertions.assertFalse((boolean)entries.isEmpty(), (String)"Test zip should contain data");
        Assertions.assertEquals((int)entries.size(), (int)importedArchive.getContent().size(), (String)"Should have imported all files and directories");
        boolean containsEmptyDir = false;
        boolean containsEmptyNestedDir = false;
        for (ZipEntry zipEntry : entries) {
            if (zipEntry.isDirectory()) {
                if (zipEntry.getName().equals("empty_dir/")) {
                    containsEmptyDir = true;
                }
                if (!zipEntry.getName().equals("parent/empty_dir/")) continue;
                containsEmptyNestedDir = true;
                continue;
            }
            Assertions.assertTrue((boolean)importedArchive.contains((ArchivePath)new BasicPath(zipEntry.getName())), (String)("Importer should have imported " + zipEntry.getName() + " from " + originalSource));
            byte[] originalContent = IOUtil.asByteArray((InputStream)testZip.getInputStream(zipEntry));
            Node node = importedArchive.get((ArchivePath)new BasicPath(zipEntry.getName()));
            byte[] importedContent = IOUtil.asByteArray((InputStream)node.getAsset().openStream());
            Assertions.assertArrayEquals((byte[])importedContent, (byte[])originalContent, (String)("The content of " + zipEntry.getName() + " should be equal to the imported content"));
        }
        Assertions.assertTrue((boolean)containsEmptyDir, (String)"Empty directory not imported");
        Assertions.assertTrue((boolean)containsEmptyNestedDir, (String)"Empty nested directory not imported");
    }

    @Override
    protected String getExistingResourceName() {
        return EXISTING_ZIP_RESOURCE;
    }
}

