/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileAttributes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileAttributesTestCase {
    private FileSystem fs;
    private JavaArchive archive;

    @BeforeEach
    public void createStore() throws IOException {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
        this.fs = fs;
    }

    @AfterEach
    public void closeFs() throws IOException {
        this.fs.close();
    }

    @Test
    public void getLastModifiedTime() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getAttributes("path", true).lastModifiedTime());
    }

    @Test
    public void lastAccessTime() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getAttributes("path", true).lastAccessTime());
    }

    @Test
    public void creationTime() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getAttributes("path", true).creationTime());
    }

    @Test
    public void isRegularFile() {
        Assertions.assertTrue((boolean)this.getAttributes("path", true).isRegularFile());
    }

    @Test
    public void isRegularFileFalse() {
        Assertions.assertFalse((boolean)this.getAttributes("path/", true).isRegularFile());
    }

    @Test
    public void isDirectory() {
        Assertions.assertTrue((boolean)this.getAttributes("path/", true).isDirectory());
    }

    @Test
    public void isDirectoryFalse() {
        Assertions.assertFalse((boolean)this.getAttributes("path", true).isDirectory());
    }

    @Test
    public void isOther() {
        Assertions.assertFalse((boolean)this.getAttributes("alwaysFalse", true).isOther());
    }

    @Test
    public void isSymbolicLink() {
        Assertions.assertFalse((boolean)this.getAttributes("alwaysFalse", true).isSymbolicLink());
    }

    @Test
    public void size() {
        int size = 1024;
        Asset kiloAsset = () -> new ByteArrayInputStream(new byte[1024]);
        String path = "path";
        this.archive.add(kiloAsset, "path");
        Assertions.assertEquals((long)1024L, (long)this.getAttributes("path", false).size(), (String)"Size not reported as expected");
    }

    @Test
    public void fileKey() {
        String path = "path";
        String expected = this.archive.getId() + "/" + "path";
        Assertions.assertEquals((Object)expected, (Object)this.getAttributes("path", true).fileKey(), (String)"File key not as expected");
    }

    private ShrinkWrapFileAttributes getAttributes(String pathName, boolean create) {
        String attributesFor = pathName;
        if (create) {
            if (pathName.endsWith("/")) {
                attributesFor = pathName.substring(0, pathName.length() - 1);
                this.archive.addAsDirectory(attributesFor);
            } else {
                this.archive.add((Asset)EmptyAsset.INSTANCE, pathName);
            }
        }
        try {
            return Files.readAttributes(this.fs.getPath(attributesFor, new String[0]), ShrinkWrapFileAttributes.class, new LinkOption[]{null});
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

