/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileAttributeView;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileAttributes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileAttributesViewTestCase {
    private FileSystem fs;
    private JavaArchive archive;

    @BeforeEach
    public void createStore() throws IOException {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
        this.fs = fs;
    }

    @AfterEach
    public void closeFs() throws IOException {
        this.fs.close();
    }

    @Test
    public void getShrinkwrapAttributesView() {
        ShrinkWrapFileAttributeView attributeView = this.getAttributesView("path");
        Assertions.assertEquals((Object)ShrinkWrapFileAttributeView.class.getSimpleName(), (Object)attributeView.name(), (String)"Attributes view wrong name");
        Assertions.assertInstanceOf(ShrinkWrapFileAttributeView.class, (Object)attributeView, (String)"Attribute view is not an instance of ShrinkWrapFileAttributeView");
    }

    @Test
    public void readAttributes() {
        ShrinkWrapFileAttributeView attributeView = this.getAttributesView("path");
        Assertions.assertNotNull((Object)attributeView, (String)"Attribute view should not be null");
        BasicFileAttributes attributes = attributeView.readAttributes();
        Assertions.assertInstanceOf(ShrinkWrapFileAttributes.class, (Object)attributes, (String)"Attributes are not instance of ShrinkWrapFileAttributes");
    }

    @Test
    public void setTimes() {
        ShrinkWrapFileAttributeView attributeView = this.getAttributesView("path");
        FileTime fileTime = FileTime.fromMillis(0L);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> FileAttributesViewTestCase.lambda$setTimes$0((BasicFileAttributeView)attributeView, fileTime));
    }

    private ShrinkWrapFileAttributeView getAttributesView(String pathName) {
        this.archive.add((Asset)EmptyAsset.INSTANCE, pathName);
        return Files.getFileAttributeView(this.fs.getPath(pathName, new String[0]), ShrinkWrapFileAttributeView.class, new LinkOption[]{null});
    }

    private static /* synthetic */ void lambda$setTimes$0(BasicFileAttributeView attributeView, FileTime fileTime) throws Throwable {
        attributeView.setTimes(fileTime, fileTime, fileTime);
    }
}

