/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileStoreTestCase {
    private JavaArchive archive;
    private FileStore fileStore;
    private FileSystem fileSystem;

    @BeforeEach
    public void createStore() throws IOException {
        FileStore fileStore;
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.fileStore = fileStore = fs.getFileStores().iterator().next();
        this.archive = archive;
        this.fileSystem = fs;
    }

    @AfterEach
    public void closeFs() throws IOException {
        this.fileSystem.close();
    }

    @Test
    public void usedSpace() throws IOException {
        Class<Asset> classToAdd = Asset.class;
        this.archive.addClass(classToAdd);
        String pathToClass = classToAdd.getName().replace('.', '/') + ".class";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(pathToClass);
        long thisClassFileSize = 0L;
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            thisClassFileSize += (long)read;
        }
        long sizeOfArchive = ((ShrinkWrapFileStore)this.fileStore).getUsedSpace();
        Assertions.assertEquals((long)thisClassFileSize, (long)sizeOfArchive, (String)"Size of archive as reported by file store is not equal to the size of the contained class");
    }

    @Test
    public void totalSpace() throws IOException {
        Assertions.assertTrue((this.fileStore.getTotalSpace() > 0L ? 1 : 0) != 0, (String)"Total space is not returning a positive integer");
    }

    @Test
    public void usableSpace() throws IOException {
        Assertions.assertTrue((this.fileStore.getUsableSpace() > 0L ? 1 : 0) != 0, (String)"Usable space is not returning a positive integer");
    }

    @Test
    public void unallocatedSpace() throws IOException {
        Assertions.assertTrue((this.fileStore.getUnallocatedSpace() > 0L ? 1 : 0) != 0, (String)"Unallocated space is not returning a positive integer");
    }

    @Test
    public void name() {
        Assertions.assertEquals((Object)this.archive.getName(), (Object)this.fileStore.name(), (String)"Name of the file store should be equal to the name of the underlying archive");
    }

    @Test
    public void type() {
        Assertions.assertEquals((Object)"shrinkwrap", (Object)this.fileStore.type(), (String)"Type of the file store should be \"shrinkwrap\"");
    }

    @Test
    public void readOnly() {
        Assertions.assertFalse((boolean)this.fileStore.isReadOnly(), (String)"ShrinkWrap file stores are not read-only");
    }

    @Test
    public void supportsBasicFileAttributeView() {
        Assertions.assertTrue((boolean)this.fileStore.supportsFileAttributeView("basic"), (String)"ShrinkWrap file store must support basic file attribute view");
    }

    @Test
    public void supportsBasicFileAttributeViewType() {
        Assertions.assertTrue((boolean)this.fileStore.supportsFileAttributeView(BasicFileAttributeView.class), (String)"ShrinkWrap file store must support basic file attribute view");
    }

    @Test
    public void supportsOtherFileAttributeView() {
        Assertions.assertFalse((boolean)this.fileStore.supportsFileAttributeView("somethingelse"), (String)"ShrinkWrap file store should not support other file attribute views");
    }

    @Test
    public void supportsOtherFileAttributeViewType() {
        Assertions.assertFalse((boolean)this.fileStore.supportsFileAttributeView(((FileAttributeView)() -> "mock").getClass()), (String)"ShrinkWrap file store should not support other file attribute views");
    }

    @Test
    public void getAttribute() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileStore.getAttribute("something"));
    }

    @Test
    public void getFileStoreAttributeView() {
        Assertions.assertNull((Object)this.fileStore.getFileStoreAttributeView(FileStoreAttributeView.class));
    }

    @Test
    public void nullArgsProhibited() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ShrinkWrapFileStore(null));
    }
}

