/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileSystemProviderTestCase {
    @Test
    public void nullEnvironmentMakesIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystems.newFileSystem(URI.create("shrinkwrap://myArchive.jar"), null));
    }

    @Test
    public void mountExistingArchive() throws Exception {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        FileSystem fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertInstanceOf(ShrinkWrapFileSystem.class, (Object)fs);
    }
}

