/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileStore;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystemProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileSystemTestCase {
    private FileSystem fileSystem;
    private JavaArchive archive;

    @BeforeEach
    public void createFileSystem() throws IOException {
        FileSystem fs;
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        this.fileSystem = fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
    }

    @AfterEach
    public void closeFs() throws IOException {
        this.fileSystem.close();
    }

    @Test
    public void rootDirectories() {
        Iterable<Path> paths = this.fileSystem.getRootDirectories();
        int count = 0;
        for (Path path : paths) {
            ++count;
            Assertions.assertEquals((Object)ArchivePaths.root().get(), (Object)path.toString(), (String)"Root was not in expected form");
        }
        Assertions.assertEquals((int)1, (int)count, (String)"Should only be one root path per FS");
    }

    @Test
    public void fileSeparator() {
        String fileSeparator = this.fileSystem.getSeparator();
        Assertions.assertEquals((Object)ArchivePath.SEPARATOR_STRING, (Object)fileSeparator, (String)"File separator was not as expected");
    }

    @Test
    public void provider() {
        FileSystemProvider provider = this.fileSystem.provider();
        Assertions.assertNotNull((Object)provider, (String)"Provider must be linked from file system");
        Assertions.assertInstanceOf(ShrinkWrapFileSystemProvider.class, (Object)provider, (String)"Provider supplied is of wrong type");
    }

    @Test
    public void isReadOnly() {
        Assertions.assertFalse((boolean)this.fileSystem.isReadOnly(), (String)"ShrinkWrap File Systems are not read-only");
    }

    @Test
    public void isOpen() {
        Assertions.assertTrue((boolean)this.fileSystem.isOpen(), (String)"Should report as open");
    }

    @Test
    public void isOpenAfterClose() throws IOException {
        this.fileSystem.close();
        Assertions.assertFalse((boolean)this.fileSystem.isOpen(), (String)"Should report as closed");
    }

    @Test
    public void getFileStores() {
        Iterable<FileStore> fileStores = this.fileSystem.getFileStores();
        int count = 0;
        for (FileStore fileStore : fileStores) {
            ++count;
            Assertions.assertInstanceOf(ShrinkWrapFileStore.class, (Object)fileStore, (String)"file store is not of correct type");
        }
        Assertions.assertEquals((int)1, (int)count, (String)"Should only be one file store per file system");
    }

    @Test
    public void supportedFileAttributeViews() {
        Set<String> fileAttrViews = this.fileSystem.supportedFileAttributeViews();
        Assertions.assertEquals((int)1, (int)fileAttrViews.size(), (String)"Only support \"basic\" file att view");
        Assertions.assertTrue((boolean)fileAttrViews.contains("basic"), (String)"By contract we must support the \"basic\" view");
    }

    @Test
    public void getPathRoot() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Assertions.assertEquals((Object)ArchivePaths.root().get(), (Object)path.toString(), (String)"Root path not obtained correctly");
    }

    @Test
    public void getPathRootFromEmptyString() {
        Path path = this.fileSystem.getPath("", new String[0]);
        Assertions.assertNull((Object)path.getRoot(), (String)"Root path of empty string should be null");
    }

    @Test
    public void getPathNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath(null, new String[0]));
    }

    @Test
    public void getHierarchicalPath() {
        Path path = this.fileSystem.getPath("toplevel", "parent", "child");
        Assertions.assertEquals((Object)"toplevel/parent/child", (Object)path.toString(), (String)"Path not obtained correctly from hierarchical input");
    }

    @Test
    public void getHierarchicalPathFromAbsolute() {
        Path path = this.fileSystem.getPath("/toplevel", "parent", "child");
        Assertions.assertEquals((Object)"/toplevel/parent/child", (Object)path.toString(), (String)"Path not obtained correctly from hierarchical input");
    }

    @Test
    public void getHierarchicalPathFromMixedInput() {
        Path path = this.fileSystem.getPath("toplevel/parent", "child");
        Assertions.assertEquals((Object)"toplevel/parent/child", (Object)path.toString(), (String)"Path not obtained correctly from mixed hierarchical input");
    }

    @Test
    public void getUserPrincipalLookupService() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileSystem.getUserPrincipalLookupService());
    }

    @Test
    public void newWatchService() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileSystem.newWatchService());
    }

    @Test
    public void fileSystemAlreadyExists() throws IllegalArgumentException {
        Assertions.assertThrows(FileSystemAlreadyExistsException.class, () -> ShrinkWrapFileSystems.newFileSystem((Archive)this.archive));
    }

    @Test
    public void fileSystemClosedNewInstanceCreated() throws IllegalArgumentException, IOException {
        this.fileSystem.close();
        Assertions.assertNotNull((Object)ShrinkWrapFileSystems.newFileSystem((Archive)this.archive));
    }

    @Test
    public void getFileSystem() {
        URI uri = ShrinkWrapFileSystems.getRootUri((Archive)this.archive);
        Assertions.assertEquals((Object)this.fileSystem, (Object)FileSystems.getFileSystem(uri), (String)"getFileSystem should return same existing file system");
    }
}

