/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Iterator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.MockPath;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathTestCase {
    private ShrinkWrapFileSystem fileSystem;

    @BeforeEach
    public void createFileSystem() throws IOException {
        ShrinkWrapFileSystem fs;
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        this.fileSystem = fs = (ShrinkWrapFileSystem)ShrinkWrapFileSystems.newFileSystem((Archive)archive);
    }

    @AfterEach
    public void closeFs() {
        this.fileSystem.close();
    }

    @Test
    public void rootIsAbsolute() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Assertions.assertTrue((boolean)path.isAbsolute(), (String)"Root path must be absolute");
        Assertions.assertEquals((Object)path.toString(), (Object)ArchivePaths.root().get(), (String)"Root path should be equal to root archive path value");
    }

    @Test
    public void getFileSystem() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Assertions.assertEquals((Object)this.fileSystem, (Object)path.getFileSystem(), (String)"FileSystem not obtained correctly via Path");
    }

    @Test
    public void getPathEmptyPath() {
        String empty = "";
        Path path = this.fileSystem.getPath("", new String[0]);
        Assertions.assertEquals((Object)"", (Object)path.toString(), (String)"Empty path should be resolved to empty path value");
    }

    @Test
    public void getFileNameEmptyPath() {
        String empty = "";
        Path path = this.fileSystem.getPath("", new String[0]);
        Assertions.assertNull((Object)path.getFileName(), (String)"Empty path should return null file name");
    }

    @Test
    public void getPathNullPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath(null, new String[0]));
    }

    @Test
    public void getPathRelative() {
        String relative = "relative";
        Path path = this.fileSystem.getPath("relative", new String[0]);
        Assertions.assertFalse((boolean)path.isAbsolute(), (String)"Relative paths must not be adjusted to absolute");
        Assertions.assertEquals((Object)"relative", (Object)path.toString(), (String)"Relative input was not resolved to path as expected");
    }

    @Test
    public void getRoot() {
        Path path = this.fileSystem.getPath("/someNode", new String[0]);
        Path root = path.getRoot();
        Assertions.assertEquals((Object)root.toString(), (Object)"/", (String)"Did not return correct root");
    }

    @Test
    public void getRootFromRelative() {
        Path path = this.fileSystem.getPath("someNode", new String[0]);
        Path root = path.getRoot();
        Assertions.assertNull((Object)root, (String)"Relative path should have null root");
    }

    @Test
    public void getRootFromNested() {
        Path path = this.fileSystem.getPath("/someNode/child", new String[0]);
        Path root = path.getRoot();
        Assertions.assertEquals((Object)root.toString(), (Object)"/", (String)"Did not return correct root");
    }

    @Test
    public void getParent() {
        Path path = this.fileSystem.getPath("parent/child", new String[0]);
        Path parent = path.getParent();
        Assertions.assertEquals((Object)parent.toString(), (Object)"parent", (String)"Did not return correct parent");
    }

    @Test
    public void getParentRelative() {
        Path path = this.fileSystem.getPath("relativeName", new String[0]);
        Path parent = path.getParent();
        Assertions.assertNull((Object)parent, (String)"Single node relative paths should have no parent");
    }

    @Test
    public void getParentNested() {
        Path path = this.fileSystem.getPath("parent/child/grandchild", new String[0]);
        Path parent = path.getParent();
        Assertions.assertEquals((Object)parent.toString(), (Object)"parent/child", (String)"Did not return correct parent");
    }

    @Test
    public void getParentAbsolute() {
        Path path = this.fileSystem.getPath("/parent/child/grandchild", new String[0]);
        Path parent = path.getParent();
        Assertions.assertEquals((Object)parent.toString(), (Object)"/parent/child", (String)"Did not return correct parent");
    }

    @Test
    public void getParentRootIsNull() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Path parent = path.getParent();
        Assertions.assertNull((Object)parent, (String)"Parent of root should be null");
    }

    @Test
    public void getFileName() {
        String location = "/dir/nestedDir/";
        String fileNameString = "fileName";
        Path path = this.fileSystem.getPath("/dir/nestedDir/fileName", new String[0]);
        Path fileName = path.getFileName();
        Assertions.assertEquals((Object)"fileName", (Object)fileName.toString(), (String)"File name was not as expected");
    }

    @Test
    public void getRootFileName() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Path fileName = path.getFileName();
        Assertions.assertNull((Object)fileName, (String)"Root file name should be null");
    }

    @Test
    public void getRootNameCount() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        int count = path.getNameCount();
        Assertions.assertEquals((int)0, (int)count, (String)"Root should have no name count");
    }

    @Test
    public void getTopLevelNameCount() {
        Path path = this.fileSystem.getPath("/toplevel", new String[0]);
        int count = path.getNameCount();
        Assertions.assertEquals((int)1, (int)count, (String)"Top-level element should have name count 1");
    }

    @Test
    public void getTopLevelAppendedSlashNameCount() {
        Path path = this.fileSystem.getPath("/toplevel/", new String[0]);
        int count = path.getNameCount();
        Assertions.assertEquals((int)1, (int)count, (String)"Top-level element should have name count 1");
    }

    @Test
    public void getTopLevelNoPrecedingSlashNameCount() {
        Path path = this.fileSystem.getPath("toplevel/", new String[0]);
        int count = path.getNameCount();
        Assertions.assertEquals((int)1, (int)count, (String)"Top-level element should have name count 1");
    }

    @Test
    public void nestedNameCount() {
        Path path = this.fileSystem.getPath("toplevel/nested", new String[0]);
        int count = path.getNameCount();
        Assertions.assertEquals((int)2, (int)count, (String)"nested-level element should have name count 2");
    }

    @Test
    public void toAbsolutePath() {
        Path path = this.fileSystem.getPath("toplevel", new String[0]);
        Assertions.assertEquals((Object)"/toplevel", (Object)path.toAbsolutePath().toString(), (String)"toAbsolute should return the absolute form of the Path");
    }

    @Test
    public void toAbsolutePathAlreadyAbsolute() {
        String absolutePath = "/absolute";
        Path path = this.fileSystem.getPath("/absolute", new String[0]);
        Assertions.assertEquals((Object)"/absolute", (Object)path.toAbsolutePath().toString(), (String)"toAbsolute should return the absolute form of the Path");
    }

    @Test
    public void isAbsolute() {
        Path path = this.fileSystem.getPath("/absolute", new String[0]);
        Assertions.assertTrue((boolean)path.isAbsolute());
    }

    @Test
    public void isAbsoluteFalse() {
        Path path = this.fileSystem.getPath("relative", new String[0]);
        Assertions.assertFalse((boolean)path.isAbsolute());
    }

    @Test
    public void iterator() {
        Path path = this.fileSystem.getPath("toplevel/second/third/fourth", new String[0]);
        Iterator<Path> paths = path.iterator();
        Assertions.assertEquals((Object)"/toplevel", (Object)paths.next().toString());
        Assertions.assertEquals((Object)"/toplevel/second", (Object)paths.next().toString());
        Assertions.assertEquals((Object)"/toplevel/second/third", (Object)paths.next().toString());
        Assertions.assertEquals((Object)"/toplevel/second/third/fourth", (Object)paths.next().toString());
    }

    @Test
    public void iteratorRoot() {
        Path path = this.fileSystem.getPath("/", new String[0]);
        Iterator<Path> paths = path.iterator();
        Assertions.assertFalse((boolean)paths.hasNext(), (String)"Iterator should not return root element");
    }

    @Test
    public void toUri() {
        Path path = this.fileSystem.getPath("/toplevel/second", new String[0]);
        URI uri = path.toUri();
        String expected = "shrinkwrap://" + this.fileSystem.getArchive().getId() + path;
        Assertions.assertEquals((Object)expected, (Object)uri.toString(), (String)"toUri did not return form as expected");
    }

    @Test
    public void getName() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        Path second = path.getName(2);
        Assertions.assertEquals((Object)"/toplevel/second/third", (Object)second.toString());
    }

    @Test
    public void getNameRoot() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        Path second = path.getName(0);
        Assertions.assertEquals((Object)"/toplevel", (Object)second.toString());
    }

    @Test
    public void subpathNegativeBegin() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(-1, 1));
    }

    @Test
    public void subpathNegativeEnd() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(0, -1));
    }

    @Test
    public void subpathEndBeforeBegin() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(2, 1));
    }

    @Test
    public void subpathBeginTooLarge() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(4, 5));
    }

    @Test
    public void subpathEndTooLarge() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(2, 4));
    }

    @Test
    public void subpath() {
        Path subpath = this.fileSystem.getPath("/toplevel/second/third", new String[0]).subpath(1, 2);
        Assertions.assertEquals((Object)"/toplevel/second", (Object)subpath.toString());
    }

    @Test
    public void startsWithNullPathInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).startsWith((Path)null));
    }

    @Test
    public void startsWithNullStringInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).startsWith((String)null));
    }

    @Test
    public void startsWithOtherPathImpl() {
        boolean startsWith = this.fileSystem.getPath("/toplevel/second/third", new String[0]).startsWith(new MockPath());
        Assertions.assertFalse((boolean)startsWith);
    }

    @Test
    public void startsWithOtherFs() throws IOException {
        FileSystem otherFs = ShrinkWrapFileSystems.newFileSystem((Archive)((Archive)ShrinkWrap.create(GenericArchive.class)));
        String pathName = "/toplevel/second";
        Path otherPath = otherFs.getPath("/toplevel/second", new String[0]);
        boolean startsWith = this.fileSystem.getPath("/toplevel/second", new String[0]).startsWith(otherPath);
        Assertions.assertFalse((boolean)startsWith);
    }

    @Test
    public void startsWith() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/toplevel/second/", new String[0]));
        Assertions.assertTrue((boolean)startsWith);
    }

    @Test
    public void startsWithRelative() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("toplevel/second/", new String[0]));
        Assertions.assertTrue((boolean)startsWith);
    }

    @Test
    public void startsWithAbsolute() {
        Path path = this.fileSystem.getPath("toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/toplevel/second/third", new String[0]));
        Assertions.assertFalse((boolean)startsWith, (String)"Other absolute pah and this relative path cannot match startsWith");
    }

    @Test
    public void startsWithString() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith("/toplevel/second/");
        Assertions.assertTrue((boolean)startsWith);
    }

    @Test
    public void startsWithNegative() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/top", new String[0]));
        Assertions.assertFalse((boolean)startsWith);
    }

    @Test
    public void startsWithBiggerThan() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean startsWith = path.startsWith(this.fileSystem.getPath("/toplevel/second/third/fourth", new String[0]));
        Assertions.assertFalse((boolean)startsWith);
    }

    @Test
    public void toFile() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileSystem.getPath("/toplevel", new String[0]).toFile());
    }

    @Test
    public void register() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileSystem.getPath("/toplevel", new String[0]).register(null, new WatchEvent.Kind[]{null}));
    }

    @Test
    public void registerLongform() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.fileSystem.getPath("/toplevel", new String[0]).register(null, new WatchEvent.Kind[]{null, null}));
    }

    @Test
    public void endsWithNullPathInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith((Path)null));
    }

    @Test
    public void endsWithNullStringInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith((String)null));
    }

    @Test
    public void endsWithOtherPathImpl() {
        boolean endsWith = this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith(new MockPath());
        Assertions.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithOtherFs() throws IOException {
        FileSystem otherFs = ShrinkWrapFileSystems.newFileSystem((Archive)((Archive)ShrinkWrap.create(GenericArchive.class)));
        Path otherPath = otherFs.getPath("/otherpath", new String[0]);
        boolean endsWith = this.fileSystem.getPath("/toplevel/second/third", new String[0]).endsWith(otherPath);
        Assertions.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWith() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("third", new String[0]));
        Assertions.assertTrue((boolean)endsWith, (String)"Should have identified path ends with last name component");
    }

    @Test
    public void endsString() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("third", new String[0]).toString());
        Assertions.assertTrue((boolean)endsWith, (String)"Should have identified path ends with last name component");
    }

    @Test
    public void endsWithNested() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("second/third", new String[0]));
        Assertions.assertTrue((boolean)endsWith, (String)"Should have identified path ends with last and penultimate name component");
    }

    @Test
    public void endsWithPartial() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("ird", new String[0]));
        Assertions.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithIncorrectRoot() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("/third", new String[0]));
        Assertions.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithNegative() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("/toplevel", new String[0]));
        Assertions.assertFalse((boolean)endsWith);
    }

    @Test
    public void endsWithBiggerThan() {
        Path path = this.fileSystem.getPath("/toplevel/second/third", new String[0]);
        boolean endsWith = path.endsWith(this.fileSystem.getPath("/toplevel/second/third/fourth", new String[0]));
        Assertions.assertFalse((boolean)endsWith);
    }

    @Test
    public void toRealPath() throws IOException {
        String newPathName = "/toplevel/myAsset";
        this.fileSystem.getArchive().add((Asset)EmptyAsset.INSTANCE, "/toplevel/myAsset");
        Path path = this.fileSystem.getPath("/toplevel/myAsset", new String[0]);
        Path realPath = path.toRealPath(null);
        Assertions.assertEquals((Object)path.toString(), (Object)realPath.toString());
    }

    @Test
    public void toRealPathDoesntExist() throws IOException {
        String newPathName = "/toplevel/myAsset";
        Path path = this.fileSystem.getPath("/toplevel/myAsset", new String[0]);
        Assertions.assertThrows(FileNotFoundException.class, () -> path.toRealPath(null));
    }

    @Test
    public void normalizeNoop() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path normalized = path.normalize();
        Assertions.assertEquals((Object)path.toString(), (Object)normalized.toString());
    }

    @Test
    public void normalizeRelative() {
        Path path = this.fileSystem.getPath("a/b", new String[0]);
        Path normalized = path.normalize();
        Assertions.assertEquals((Object)path.toString(), (Object)normalized.toString());
    }

    @Test
    public void normalizeCurrentDirRefs() {
        Path path = this.fileSystem.getPath("/a/./b/./c/d/./e", new String[0]);
        Path normalized = path.normalize();
        Assertions.assertEquals((Object)"/a/b/c/d/e", (Object)normalized.toString());
    }

    @Test
    public void normalizeBackDirRefs() {
        Path path = this.fileSystem.getPath("/a/../b/./c/d/../e", new String[0]);
        Path normalized = path.normalize();
        Assertions.assertEquals((Object)"/b/c/e", (Object)normalized.toString());
    }

    @Test
    public void relativizeSuperset() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path other = this.fileSystem.getPath("/a/b/c/d", new String[0]);
        Path relativized = path.relativize(other);
        Assertions.assertEquals((Object)"c/d", (Object)relativized.toString());
    }

    @Test
    public void relativizeSuperset2() {
        Path path = this.fileSystem.getPath("/a/b/c", new String[0]);
        Path other = this.fileSystem.getPath("/a/b/c/d", new String[0]);
        Path relativized = path.relativize(other);
        Assertions.assertEquals((Object)"d", (Object)relativized.toString());
    }

    @Test
    public void relativizeCommonNode() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path other = this.fileSystem.getPath("/a/c", new String[0]);
        Path relativized = path.relativize(other);
        Assertions.assertEquals((Object)"../c", (Object)relativized.toString());
    }

    @Test
    public void relativizeCommonNode2() {
        Path path = this.fileSystem.getPath("/a/b", new String[0]);
        Path other = this.fileSystem.getPath("/a/c/d", new String[0]);
        Path relativized = path.relativize(other);
        Assertions.assertEquals((Object)"../c/d", (Object)relativized.toString());
    }

    @Test
    public void relativizeNull() {
        Path path = this.fileSystem.getPath("/toplevel/myAsset", new String[0]);
        Assertions.assertThrows(IllegalArgumentException.class, () -> path.relativize(null));
    }

    @Test
    public void resolve() {
        Path path = this.fileSystem.getPath("/topLevel/secondLevel", new String[0]);
        Path other = this.fileSystem.getPath("thirdLevel", new String[0]);
        Path resolved = path.resolve(other);
        Assertions.assertEquals((Object)"/topLevel/secondLevel/thirdLevel", (Object)resolved.toString(), (String)"Resolve should join other to this");
    }

    @Test
    public void resolveTrailingSlashOnThis() {
        Path path = this.fileSystem.getPath("/topLevel/secondLevel/", new String[0]);
        Path other = this.fileSystem.getPath("thirdLevel", new String[0]);
        Path resolved = path.resolve(other);
        Assertions.assertEquals((Object)"/topLevel/secondLevel/thirdLevel", (Object)resolved.toString(), (String)"Resolve should join other to this");
    }

    @Test
    public void resolveEmpty() {
        String thisLocation = "/topLevel/secondLevel";
        Path path = this.fileSystem.getPath("/topLevel/secondLevel", new String[0]);
        Path other = this.fileSystem.getPath("", new String[0]);
        Path resolved = path.resolve(other);
        Assertions.assertEquals((Object)"/topLevel/secondLevel", (Object)resolved.toString(), (String)"Resolve of empty path should return this path");
    }

    @Test
    public void resolveAbsolute() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolve(other);
        Assertions.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test
    public void resolveNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolve((Path)null));
    }

    @Test
    public void resolveString() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        String otherName = "/toplevel/myDir/myAsset";
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolve("/toplevel/myDir/myAsset");
        Assertions.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test
    public void resolveNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolve((String)null));
    }

    @Test
    public void roundtripResolveRelativizeOfNormalizedPaths() {
        Path path = this.fileSystem.getPath("/a/b/f/../", new String[0]);
        Path other = this.fileSystem.getPath("a/b/../c", new String[0]);
        Path pathNormalized = path.normalize();
        Path otherNormalized = other.normalize();
        Assertions.assertEquals((Object)pathNormalized.relativize(pathNormalized.resolve(otherNormalized)), (Object)otherNormalized, (String)"Failed check that relativize undoes resolve, taking into account normalization");
    }

    @Test
    public void resolveSibling() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolveSibling(other);
        Assertions.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test
    public void resolveSiblingNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolveSibling((Path)null));
    }

    @Test
    public void resolveSiblingString() {
        Path path = this.fileSystem.getPath("/toplevel/myDir/", new String[0]);
        String otherName = "/toplevel/myDir/myAsset";
        Path other = this.fileSystem.getPath("/toplevel/myDir/myAsset", new String[0]);
        Path resolved = path.resolveSibling("/toplevel/myDir/myAsset");
        Assertions.assertEquals((Object)other.toString(), (Object)resolved.toString());
    }

    @Test
    public void resolveSublingNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/myDir/", new String[0]).resolveSibling((String)null));
    }

    @Test
    public void compareToGreaterValue() {
        Path path = this.fileSystem.getPath("/toplevel/a", new String[0]);
        String otherName = "/toplevel/b";
        Path other = this.fileSystem.getPath("/toplevel/b", new String[0]);
        int compare = path.compareTo(other);
        Assertions.assertEquals((int)-1, (int)compare);
    }

    @Test
    public void compareToLesserValue() {
        Path path = this.fileSystem.getPath("/toplevel/b", new String[0]);
        String otherName = "/toplevel/a";
        Path other = this.fileSystem.getPath("/toplevel/a", new String[0]);
        int compare = path.compareTo(other);
        Assertions.assertEquals((int)1, (int)compare);
    }

    @Test
    public void compareToEqualValue() {
        Path path = this.fileSystem.getPath("/toplevel/a", new String[0]);
        String otherName = "/toplevel/a";
        Path other = this.fileSystem.getPath("/toplevel/a", new String[0]);
        int compare = path.compareTo(other);
        Assertions.assertEquals((int)0, (int)compare);
    }

    @Test
    public void compareToNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.fileSystem.getPath("/toplevel/a", new String[0]).compareTo(null));
    }
}

