/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapPath;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathsTestCase {
    private FileSystem fs;
    private Archive<?> archive;

    @BeforeEach
    public void createFileSystem() throws IOException {
        String name = "test.jar";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        this.fs = ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        this.archive = archive;
    }

    @AfterEach
    public void closeFileSystem() throws IOException {
        if (this.fs.isOpen()) {
            this.fs.close();
        }
    }

    @Test
    public void get() {
        Path path = Paths.get(ShrinkWrapFileSystems.getRootUri(this.archive));
        Assertions.assertInstanceOf(ShrinkWrapPath.class, (Object)path, (String)"Wrong Path implementation returned");
        Assertions.assertEquals((Object)ArchivePaths.root().get(), (Object)path.toString(), (String)"Path returned is not correct");
    }

    @Test
    public void getNonexistentFilesystem() {
        Assertions.assertThrows(FileSystemNotFoundException.class, () -> Paths.get(new URI("shrinkwrap://fakeId")));
    }

    @Test
    public void getClosedFilesystem() throws IOException {
        this.fs.close();
        Assertions.assertThrows(FileSystemNotFoundException.class, () -> Paths.get(ShrinkWrapFileSystems.getRootUri(this.archive)));
    }
}

