/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.nio2.file;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.util.HashMap;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.nio2.file.ShrinkWrapFileSystems;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.nio2.file.ShrinkWrapFileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShrinkWrapFileSystemsTestCase {
    @Test
    public void newFileSystemArchiveRequired() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShrinkWrapFileSystems.newFileSystem(null));
    }

    @Test
    public void getRootUriArchiveRequired() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShrinkWrapFileSystems.getRootUri(null));
    }

    @Test
    public void protocol() {
        Assertions.assertEquals((Object)"shrinkwrap", (Object)"shrinkwrap", (String)"Protocol is not as expected");
    }

    @Test
    public void fsEnvKeyArchive() {
        Assertions.assertEquals((Object)"archive", (Object)"archive", (String)"FS environment key for archives is not as expected");
    }

    @Test
    public void getRootUri() {
        GenericArchive archive = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        URI uri = ShrinkWrapFileSystems.getRootUri((Archive)archive);
        String expected = "shrinkwrap://" + archive.getId() + "/";
        Assertions.assertEquals((Object)expected, (Object)uri.toString(), (String)"Root URI is not as expected");
    }

    @Test
    public void newFileSystem() throws IOException {
        GenericArchive archive = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        ShrinkWrapFileSystem fs = (ShrinkWrapFileSystem)ShrinkWrapFileSystems.newFileSystem((Archive)archive);
        Assertions.assertNotNull((Object)fs, (String)"Did not obtain a new File System as expected");
        Assertions.assertSame((Object)archive, (Object)fs.getArchive(), (String)"Backing archive was not as expected");
    }

    @Test
    public void noArchiveInEnvShouldResultInIAE() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileSystems.newFileSystem(ShrinkWrapFileSystems.getRootUri((Archive)((Archive)ShrinkWrap.create(JavaArchive.class))), new HashMap()));
    }
}

