/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.path;

import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathUtilTestCase {
    private static final Logger log = Logger.getLogger(PathUtilTestCase.class.getName());

    @Test
    public void testRemovePrecedingSlash() {
        log.info("testRemovePrecedingSlash");
        String precedingSlash = "/test/something";
        String expected = "/test/something".substring(1);
        String result = PathUtil.optionallyRemovePrecedingSlash((String)"/test/something");
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Call to remove preceding slash should return everything in input except the first slash");
    }

    @Test
    public void testRemovePrecedingSlashWithNoPrecedingSlashEqualToInput() {
        log.info("testRemovePrecedingSlash");
        String noPrecedingSlash = "test/something";
        String result = PathUtil.optionallyRemovePrecedingSlash((String)"test/something");
        Assertions.assertEquals((Object)"test/something", (Object)result, (String)"Call to remove preceding slash on input with no preceding slash should return equal by value to input");
    }

    @Test
    public void testPrependSlash() {
        log.info("testRemovePrecedingSlash");
        String noPrecedingSlash = "test/something";
        String expected = "/test/something";
        String result = PathUtil.optionallyPrependSlash((String)"test/something");
        Assertions.assertEquals((Object)"/test/something", (Object)result, (String)"Call to prepend a slash failed");
    }

    @Test
    public void testNoOpPrependSlash() {
        log.info("testRemovePrecedingSlash");
        String precedingSlash = "/test/something";
        String result = PathUtil.optionallyPrependSlash((String)"/test/something");
        Assertions.assertEquals((Object)"/test/something", (Object)result, (String)"Call to optionally prepend a slash upon input with slash prefix should return no-op");
    }

    @Test
    public void testAppendSlash() {
        log.info("testRemovePrecedingSlash");
        String noFollowingSlash = "test/something";
        String expected = "test/something/";
        String result = PathUtil.optionallyAppendSlash((String)"test/something");
        Assertions.assertEquals((Object)"test/something/", (Object)result, (String)"Call to append a slash failed");
    }

    @Test
    public void testNoOpAppendSlash() {
        log.info("testRemovePrecedingSlash");
        String followingSlash = "/test/something/";
        String result = PathUtil.optionallyAppendSlash((String)"/test/something/");
        Assertions.assertEquals((Object)"/test/something/", (Object)result, (String)"Call to optionally append a slash upon input with slash suffix should return no-op");
    }

    @Test
    public void testAdjustToRelativeDirectoryContext() {
        log.info("testRemovePrecedingSlash");
        String absoluteWithoutTrailingSlash = "/test/something";
        String expected = "/test/something".substring(1) + '/';
        String result = PathUtil.adjustToRelativeDirectoryContext((String)"/test/something");
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Adjusting to relative form should strip preceding slash and append a trailing one");
    }

    @Test
    public void testAdjustToAbsoluteDirectoryContext() {
        log.info("testRemovePrecedingSlash");
        String relativeWithoutTrailingSlash = "test/something";
        String expected = "/test/something/";
        String result = PathUtil.adjustToAbsoluteDirectoryContext((String)"test/something");
        Assertions.assertEquals((Object)"/test/something/", (Object)result, (String)"Adjusting to absolute form should prepend preceding slash and append a trailing one");
    }

    @Test
    public void testComposeAbsoluteContext() {
        log.info("testComposeAbsoluteContext");
        String base = "something";
        String context = "somethingunder";
        String expected = "/something/somethingunder";
        String result = PathUtil.composeAbsoluteContext((String)"something", (String)"somethingunder");
        Assertions.assertEquals((Object)"/something/somethingunder", (Object)result, (String)"Composing an absolute context from base and context did not succeed");
    }

    @Test
    public void testParent() {
        log.info("testParent");
        String rootString = "/";
        String subpathString = "subpath/";
        String contextString = "context";
        String contextWithFollowingSlashString = "context/";
        ArchivePath root = ArchivePaths.create((String)"/");
        ArchivePath subpath = ArchivePaths.create((String)"subpath/");
        ArchivePath context = ArchivePaths.create((ArchivePath)subpath, (String)"context");
        BasicPath contextWithFollowingSlash = new BasicPath(subpath, "context/");
        Assertions.assertEquals((Object)subpath, (Object)PathUtil.getParent((ArchivePath)context), (String)"The parent of the context path should be equal to the initial subpath");
        Assertions.assertEquals((Object)subpath, (Object)PathUtil.getParent((ArchivePath)contextWithFollowingSlash), (String)"The parent of the context path with a following slash should be equal to the initial subpath");
        Assertions.assertEquals((Object)root, (Object)PathUtil.getParent((ArchivePath)subpath), (String)"The parent of the subpath should be the root");
        Assertions.assertNull((Object)PathUtil.getParent((ArchivePath)root), (String)"The parent of the root should be null");
    }
}

