/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.serialization.SerializableView;
import org.jboss.shrinkwrap.api.serialization.ZipSerializableView;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.serialization.ZipSerializableOriginalImpl;
import org.jboss.shrinkwrap.impl.base.serialization.ZipSerializableViewImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SerializationTestCase {
    private static final Logger log = Logger.getLogger(SerializationTestCase.class.getName());
    private static final String NAME_PAYLOAD_ARCHIVE = "serializedArchive.jar";
    private JavaArchive payload;

    @BeforeEach
    public void createPayload() {
        this.payload = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)NAME_PAYLOAD_ARCHIVE)).addClasses(new Class[]{SerializationTestCase.class, JavaArchive.class});
    }

    @Test
    public void zipSerializableView() throws Exception {
        this.testSerializableView(ZipSerializableView.class);
    }

    @Test
    public void serializableView() throws Exception {
        this.testSerializableView(SerializableView.class);
    }

    private <S extends SerializableView> void testSerializableView(Class<S> serializableView) throws Exception {
        log.info("Before: " + this.payload.toString(true));
        JavaArchive roundtrip = (JavaArchive)SerializationTestCase.serializeAndDeserialize((SerializableView)this.payload.as(serializableView)).as(JavaArchive.class);
        log.info("After: " + roundtrip.toString(true));
        this.testCurrentFields((Archive<?>)this.payload, (Archive<?>)roundtrip);
    }

    @Test
    public void zipWireProtocolCurrentToOriginal() throws Exception {
        SerializableView currentWireFormat = (SerializableView)this.payload.as(SerializableView.class);
        SerializableView roundtrip = this.testWireProtocol(currentWireFormat, ZipSerializableOriginalImpl.class);
        this.testOriginalFields((Archive<?>)this.payload, (Archive<?>)((Archive)roundtrip.as(JavaArchive.class)));
    }

    @Test
    public void zipWireProtocolOriginalToCurrent() throws Exception {
        ZipSerializableOriginalImpl originalWireFormat = new ZipSerializableOriginalImpl((Archive<?>)this.payload);
        SerializableView roundtrip = this.testWireProtocol((SerializableView)originalWireFormat, ZipSerializableViewImpl.class);
        this.testOriginalFields((Archive<?>)this.payload, (Archive<?>)((Archive)roundtrip.as(JavaArchive.class)));
    }

    private SerializableView testWireProtocol(SerializableView clientObject, Class<? extends SerializableView> targetType) throws IOException {
        SerializableView roundtrip = SerializationTestCase.serializeAndDeserialize(clientObject, targetType);
        Assertions.assertEquals(targetType, roundtrip.getClass());
        return roundtrip;
    }

    private void testOriginalFields(Archive<?> payload, Archive<?> roundtrip) {
        Map originalContents = payload.getContent();
        Map roundtripContents = roundtrip.getContent();
        Assertions.assertEquals((Object)originalContents, (Object)roundtripContents, (String)"Contents after serialization were not as expected");
        Assertions.assertEquals((Object)NAME_PAYLOAD_ARCHIVE, (Object)payload.getName(), (String)"Name of original archive was not as expected");
        Assertions.assertEquals((Object)payload.getName(), (Object)roundtrip.getName(), (String)"Name not as expected after serialization");
    }

    private void testCurrentFields(Archive<?> payload, Archive<?> roundtrip) {
        this.testOriginalFields(payload, roundtrip);
        Assertions.assertEquals((Object)payload.getId(), (Object)roundtrip.getId(), (String)"ID not as expected after serialization");
    }

    private static SerializableView serializeAndDeserialize(SerializableView archive) throws IOException, ClassNotFoundException {
        assert (archive != null) : "Archive must be specified";
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(archive);
        out.flush();
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        SerializableView roundtrip = (SerializableView)in.readObject();
        in.close();
        return roundtrip;
    }

    private static <S extends SerializableView> S serializeAndDeserialize(SerializableView archive, Class<S> targetType) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        SpoofingObjectOutputStream oout = new SpoofingObjectOutputStream(bout, archive.getClass(), targetType);
        oout.writeObject(archive);
        oout.flush();
        oout.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream oin = new ObjectInputStream(bin);
        try {
            Object obj = oin.readObject();
            oin.close();
            log.info("Original type " + archive.getClass().getName() + " now represented as " + obj.getClass().getName());
            return (S)((SerializableView)targetType.cast(obj));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static class SpoofingObjectOutputStream
    extends ObjectOutputStream {
        String oldName;
        String newName;

        public SpoofingObjectOutputStream(OutputStream out, Class<?> oldClass, Class<?> newClass) throws IOException {
            super(out);
            this.oldName = oldClass.getName();
            this.newName = newClass.getName();
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass descriptor) throws IOException {
            Class<?> clazz = descriptor.forClass();
            boolean externalizable = Externalizable.class.isAssignableFrom(clazz);
            boolean serializable = Serializable.class.isAssignableFrom(clazz);
            boolean hasWriteObjectData = this.hasWriteObjectMethod(clazz);
            boolean isEnum = Enum.class.isAssignableFrom(clazz);
            this.writeUTF(this.replace(descriptor.getName()));
            this.writeLong(descriptor.getSerialVersionUID());
            int flags = 0;
            if (externalizable) {
                flags = (byte)(flags | 4);
                flags = (byte)(flags | 8);
            } else if (serializable) {
                flags = (byte)(flags | 2);
            }
            if (hasWriteObjectData) {
                flags = (byte)(flags | 1);
            }
            if (isEnum) {
                flags = (byte)(flags | 0x10);
            }
            this.writeByte(flags);
            ObjectStreamField[] fields = descriptor.getFields();
            this.writeShort(fields.length);
            for (ObjectStreamField field : fields) {
                this.writeByte(field.getTypeCode());
                this.writeUTF(field.getName());
                if (field.isPrimitive()) continue;
                this.writeObject(this.replace(field.getTypeString()));
            }
        }

        String replace(String className) {
            if (className.equals(this.newName)) {
                throw new RuntimeException("Found instance of " + className + ". Expected instance of " + this.oldName + ".");
            }
            return className == this.oldName ? this.newName : className;
        }

        boolean hasWriteObjectMethod(Class<?> clazz) {
            try {
                Method method = clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                int modifiers = method.getModifiers();
                return method.getReturnType() == Void.TYPE && !Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
    }
}

