/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicWebContainerTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

@ArchiveType(value=WebArchive.class)
public class WebArchiveImplTestCase
extends DynamicWebContainerTestBase<WebArchive> {
    private static final ArchivePath PATH_WEB = ArchivePaths.root();
    private static final ArchivePath PATH_WEBINF = ArchivePaths.create((String)"WEB-INF");
    private static final ArchivePath PATH_LIBRARY = ArchivePaths.create((ArchivePath)PATH_WEBINF, (String)"lib");
    private static final ArchivePath PATH_CLASSES = ArchivePaths.create((ArchivePath)PATH_WEBINF, (String)"classes");
    private static final ArchivePath PATH_MANIFEST = ArchivePaths.create((String)"META-INF");
    private static final ArchivePath PATH_RESOURCE = ArchivePaths.create((ArchivePath)PATH_WEBINF, (String)"classes");
    private WebArchive archive;

    @BeforeEach
    public void createWebArchive() {
        this.archive = this.createNewArchive();
    }

    @Override
    @AfterEach
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected WebArchive getArchive() {
        return this.archive;
    }

    protected WebArchive createNewArchive() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @Override
    protected ManifestContainer<WebArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ServiceProviderContainer<WebArchive> getServiceProviderContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<WebArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ClassContainer<WebArchive> getClassContainer() {
        return this.archive;
    }

    @Override
    protected LibraryContainer<WebArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected ArchivePath getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected ArchivePath getClassPath() {
        return PATH_CLASSES;
    }

    @Override
    protected ArchivePath getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Override
    public WebContainer<WebArchive> getWebContainer() {
        return this.getArchive();
    }

    @Override
    public ArchivePath getWebPath() {
        return PATH_WEB;
    }

    @Override
    public ArchivePath getWebInfPath() {
        return PATH_WEBINF;
    }

    @Override
    protected ArchiveFormat getExpectedArchiveFormat() {
        return ArchiveFormat.ZIP;
    }
}

