/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.handler.ReplaceAssetHandler;
import org.jboss.shrinkwrap.impl.base.test.handler.SimpleHandler;
import org.jboss.shrinkwrap.spi.ArchiveFormatAssociable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class ArchiveTestBase<T extends Archive<T>> {
    public static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    public static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";

    protected abstract T getArchive();

    protected abstract Archive<T> createNewArchive();

    protected abstract ArchiveFormat getExpectedArchiveFormat();

    @Test
    public void testDefaultArchiveFormatIsSet() {
        Assertions.assertEquals((Object)this.getExpectedArchiveFormat(), (Object)this.getDefaultArchiveFormat(), (String)"Unexpected default archive format");
    }

    private ArchiveFormat getDefaultArchiveFormat() {
        return ((ArchiveFormatAssociable)this.getArchive()).getArchiveFormat();
    }

    @AfterEach
    public void ls() {
        T archive = this.getArchive();
        System.out.println("test@jboss:/$ ls -l " + archive.getName());
        System.out.println(archive.toString(true));
    }

    @Test
    public void testAddAssetToPath() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)location), (String)("Asset should be placed on " + location.get()));
    }

    @Test
    public void testAddRequiresPath() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveTestBase.lambda$testAddRequiresPath$0(archive, (Asset)asset), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddRequiresAssets() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.add((Asset)null, (ArchivePath)new BasicPath("/", "Test.properties")), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddWithStringPath() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, location.get());
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)location), (String)("Asset should be placed on " + new BasicPath("/", "test.properties")));
    }

    @Test
    public void testAddWithStringPathRequiresPath() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveTestBase.lambda$testAddWithStringPathRequiresPath$2(archive, (Asset)asset), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddWithStringPathRequiresAssets() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.add((Asset)null, "/Test.properties"), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddAssetWithArchivePathAndName() {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ArchivePath location = ArchivePaths.root();
        archive.add((Asset)asset, location, "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)expectedPath), (String)("Asset should be placed on " + expectedPath.get()));
    }

    @Test
    public void testAddAssetWithStringPathAndName() {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "/", "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)expectedPath), (String)("Asset should be placed on " + expectedPath.get()));
    }

    @Test
    public void testAddAssetWithNameRequiresArchivePath() {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveTestBase.lambda$testAddAssetWithNameRequiresArchivePath$4(archive, (Asset)asset), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddAssetWithNameRequiresStringPath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.add((Asset)EmptyAsset.INSTANCE, (String)null, "childPath"));
    }

    @Test
    public void testAddAssetWithNameRequiresName() {
        T archive = this.getArchive();
        BasicPath path = new BasicPath("/", "Test.properties");
        String resource = NAME_TEST_PROPERTIES;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveTestBase.lambda$testAddAssetWithNameRequiresName$6(archive, (ArchivePath)path), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddAssetWithNameRequiresAsset() {
        T archive = this.getArchive();
        String name = "test.properties";
        BasicPath path = new BasicPath("/", "Test.properties");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArchiveTestBase.lambda$testAddAssetWithNameRequiresAsset$7(archive, (ArchivePath)path), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddNamedAsset() {
        T archive = this.getArchive();
        String testName = "check.properties";
        ClassLoaderAsset testAsset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        NamedAsset namedAsset = new NamedAsset((Asset)testAsset){
            final /* synthetic */ Asset val$testAsset;
            {
                this.val$testAsset = asset;
            }

            public String getName() {
                return "check.properties";
            }

            public InputStream openStream() {
                return this.val$testAsset.openStream();
            }
        };
        archive.add(namedAsset);
        Assertions.assertTrue((boolean)archive.contains("check.properties"), (String)"Asset should be placed on check.properties");
    }

    @Test
    public void testAddEmptyDirectories() {
        T archive = this.getArchive();
        ArchivePath path1 = ArchivePaths.create((String)"path/to/dir");
        ArchivePath path2 = ArchivePaths.create((String)"path/to/dir2");
        ArchivePath path3 = ArchivePaths.create((String)"path/to");
        archive.addAsDirectories(new ArchivePath[]{path1, path2, path3});
        String message = "Should be able to add directory: ";
        Assertions.assertTrue((boolean)archive.contains(path1), (String)("Should be able to add directory: " + path1));
        Assertions.assertTrue((boolean)archive.contains(path2), (String)("Should be able to add directory: " + path2));
        Assertions.assertTrue((boolean)archive.contains(path3), (String)("Should be able to add directory: " + path3));
    }

    @Test
    public void testHandlerIsCalledWhenAddingDirectoriesWithArchivePath() {
        SimpleHandler simpleHandler1 = new SimpleHandler();
        SimpleHandler simpleHandler2 = new SimpleHandler();
        this.getArchive().addHandlers(new ArchiveEventHandler[]{simpleHandler1, simpleHandler2});
        this.getArchive().addAsDirectories(new ArchivePath[]{ArchivePaths.create((String)"/path/to/dir1")});
        Assertions.assertTrue((boolean)simpleHandler1.called, (String)"Handler not called");
        Assertions.assertTrue((boolean)simpleHandler2.called, (String)"Handler not called");
    }

    @Test
    public void testHandlerIsCalledWhenAddingDirectoriesWithStringPath() {
        SimpleHandler simpleHandler1 = new SimpleHandler();
        SimpleHandler simpleHandler2 = new SimpleHandler();
        this.getArchive().addHandlers(new ArchiveEventHandler[]{simpleHandler1, simpleHandler2});
        this.getArchive().addAsDirectories(new String[]{"/path/to/dir1"});
        Assertions.assertTrue((boolean)simpleHandler1.called, (String)"Handler not called");
        Assertions.assertTrue((boolean)simpleHandler2.called, (String)"Handler not called");
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithArchivePath() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir/test1.txt");
        StringAsset asset = new StringAsset("Asset content");
        this.getArchive().add((Asset)asset, path);
        Assertions.assertEquals((Object)"EXPECTED", (Object)this.readStringAsset(path), (String)"Handler not called");
        Assertions.assertEquals((Object)asset, (Object)handler1.savedAsset, (String)"Wrong asset received by handler");
        Assertions.assertEquals((Object)handler1.returnedAsset, (Object)handler2.savedAsset, (String)"Wrong asset received by handler");
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithArchivePathAndName() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir");
        StringAsset asset = new StringAsset("Original");
        this.getArchive().add((Asset)asset, path, "asset.txt");
        String actual = this.readStringAsset(ArchivePaths.create((ArchivePath)path, (String)"/asset.txt"));
        Assertions.assertEquals((Object)"EXPECTED", (Object)actual, (String)"Handler not called");
        Assertions.assertEquals((Object)asset, (Object)handler1.savedAsset, (String)"Wrong asset received by handler");
        Assertions.assertEquals((Object)handler1.returnedAsset, (Object)handler2.savedAsset, (String)"Wrong asset received by handler");
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithStringPathAndName() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir");
        StringAsset asset = new StringAsset("Original");
        this.getArchive().add((Asset)asset, path.get(), "asset.txt");
        String actual = this.readStringAsset(ArchivePaths.create((ArchivePath)path, (String)"asset.txt"));
        Assertions.assertEquals((Object)"EXPECTED", (Object)actual, (String)"Handler not called");
        Assertions.assertEquals((Object)asset, (Object)handler1.savedAsset, (String)"Wrong asset received by handler");
        Assertions.assertEquals((Object)handler1.returnedAsset, (Object)handler2.savedAsset, (String)"Wrong asset received by handler");
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithStringPath() throws Exception {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir/test1.txt");
        StringAsset asset = new StringAsset("Original");
        this.getArchive().add((Asset)asset, path.get());
        Assertions.assertEquals((Object)"EXPECTED", (Object)this.readStringAsset(path), (String)"Handler not called");
        Assertions.assertEquals((Object)asset, (Object)handler1.savedAsset, (String)"Wrong asset received by handler");
        Assertions.assertEquals((Object)handler1.returnedAsset, (Object)handler2.savedAsset, (String)"Wrong asset received by handler");
    }

    @Test
    public void testHandlerIsCalledWhenAddingAssetWithArchivePathAndExporter() {
        ReplaceAssetHandler handler1 = new ReplaceAssetHandler("unexpected");
        ReplaceAssetHandler handler2 = new ReplaceAssetHandler("EXPECTED");
        this.getArchive().addHandlers(new ArchiveEventHandler[]{handler1, handler2});
        ArchivePath path = ArchivePaths.create((String)"/path/to/dir");
        Archive asset = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"asset.zip")).add((Asset)new StringAsset("asset content"), "content.txt");
        this.getArchive().add(asset, path, ZipExporter.class);
        Assertions.assertTrue((boolean)handler1.called, (String)"Handler not called");
        Assertions.assertEquals((Object)handler1.returnedAsset, (Object)handler2.savedAsset, (String)"Wrong asset received by handler");
    }

    @Test
    public void testContainsPathAsString() {
        T archive = this.getArchive();
        String path = "testpath";
        archive.add((Asset)EmptyAsset.INSTANCE, "testpath");
        Assertions.assertTrue((boolean)archive.contains("testpath"), (String)"Archive should contain the path added");
    }

    @Test
    public void testContainsPathAsArchivePath() {
        T archive = this.getArchive();
        ArchivePath path = ArchivePaths.create((String)"testpath");
        archive.add((Asset)EmptyAsset.INSTANCE, path);
        Assertions.assertTrue((boolean)archive.contains(path), (String)"Archive should contain the path added");
    }

    @Test
    public void testDeleteAssetWithArchivePath() {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(resource);
        archive.add((Asset)asset, (ArchivePath)location);
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)location));
        Assertions.assertEquals((Object)asset, (Object)archive.delete((ArchivePath)location).getAsset(), (String)"Successfully deleting an Asset should return the removed Node");
        Assertions.assertFalse((boolean)archive.contains((ArchivePath)location), (String)("There should no longer be an asset at: " + location.get() + " after deleted"));
    }

    @Test
    public void testDeleteAssetWithStringPath() {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        String location = "/test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(resource);
        archive.add((Asset)asset, location);
        Assertions.assertTrue((boolean)archive.contains(location));
        Assertions.assertEquals((Object)asset, (Object)archive.delete(location).getAsset(), (String)"Successfully deleting an Asset should return the removed Node");
        Assertions.assertFalse((boolean)archive.contains(location), (String)("There should no longer be an asset at: " + location + " after deleted"));
    }

    @Test
    public void testDeleteMissingAsset() {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        Assertions.assertNull((Object)archive.delete((ArchivePath)location), (String)"Deleting a non-existent Asset should return null");
    }

    @Test
    public void testDeleteMissingAssetWithStringPath() {
        T archive = this.getArchive();
        String location = "/test.properties";
        Assertions.assertNull((Object)archive.delete(location), (String)"Deleting a non-existent Asset should return null");
    }

    @Test
    public void testDeleteAssetRequiresArchivePath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.delete((ArchivePath)null));
    }

    @Test
    public void testDeleteAssetRequiresStringPath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.delete((String)null));
    }

    @Test
    public void testDeletePathWithChildren() {
        T archive = this.getArchive();
        String dirName = "dir";
        archive.addAsDirectories(new String[]{"dir"});
        archive.add((Asset)new StringAsset("asset"), "dir", "abc.txt").add((Asset)new StringAsset("asset"), "dir", "cde.txt");
        archive.add((Asset)new StringAsset("other"), "other.txt");
        archive.delete("dir");
        Assertions.assertFalse((boolean)archive.contains("dir"));
        Assertions.assertEquals((int)1, (int)archive.getContent().size());
    }

    @Test
    public void testGetAsset() {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get((ArchivePath)location);
        Assertions.assertTrue((boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()), (String)("Asset should be returned from path: " + location.get()));
    }

    @Test
    public void testGetAssetRequiresPath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.get((ArchivePath)null), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testGetAssetWithString() {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get(location.get());
        Assertions.assertTrue((boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()), (String)("Asset should be returned from path: " + location.get()));
    }

    @Test
    public void testGetAssetWithStringRequiresPath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.get((String)null), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testImportArchiveAsTypeFromString() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, resourcePath, ArchiveFormat.ZIP)).add((Asset)new StringAsset("test file content"), "test.txt");
        Assertions.assertEquals((Object)resourcePath, (Object)jar.getName(), (String)"JAR imported with wrong name");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass.class"), (String)"Class in JAR not imported");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"), (String)"Inner Class in JAR not imported");
        Assertions.assertNotNull((Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"), (String)"Should contain a new asset");
    }

    @Test
    public void testImportArchiveAsTypeFromStringUsingDefaultFormat() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, resourcePath)).add((Asset)new StringAsset("test file content"), "test.txt");
        Assertions.assertEquals((Object)resourcePath, (Object)jar.getName(), (String)"JAR imported with wrong name");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass.class"), (String)"Class in JAR not imported");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"), (String)"Inner Class in JAR not imported");
        Assertions.assertNotNull((Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"), (String)"Should contain a new asset");
    }

    @Test
    public void testImportArchiveAsTypeFromArchivePath() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, ArchivePaths.create((String)resourcePath), ArchiveFormat.ZIP)).add((Asset)new StringAsset("test file content"), "test.txt");
        Assertions.assertEquals((Object)resourcePath, (Object)jar.getName(), (String)"JAR imported with wrong name");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass.class"), (String)"Class in JAR not imported");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"), (String)"Inner Class in JAR not imported");
        Assertions.assertNotNull((Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"), (String)"Should contain an archive asset");
    }

    @Test
    public void testImportArchiveAsTypeFromArchivePathUsingDefaultFormat() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        JavaArchive jar = (JavaArchive)((JavaArchive)archive.getAsType(JavaArchive.class, ArchivePaths.create((String)resourcePath))).add((Asset)new StringAsset("test file content"), "test.txt");
        Assertions.assertEquals((Object)resourcePath, (Object)jar.getName(), (String)"JAR imported with wrong name");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass.class"), (String)"Class in JAR not imported");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"), (String)"Inner Class in JAR not imported");
        Assertions.assertNotNull((Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"), (String)"Should contain an archive asset");
    }

    @Test
    public void testImportArchiveAsTypeFromFilter() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        Collection jars = archive.getAsType(JavaArchive.class, Filters.include((String)".*jar"), ArchiveFormat.ZIP);
        Assertions.assertEquals((int)1, (int)jars.size(), (String)"Unexpected result found");
        JavaArchive jar = (JavaArchive)((JavaArchive)jars.iterator().next()).add((Asset)new StringAsset("test file content"), "test.txt");
        Assertions.assertEquals((Object)resourcePath, (Object)jar.getName(), (String)"JAR imported with wrong name");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass.class"), (String)"Class in JAR not imported");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"), (String)"Inner Class in JAR not imported");
        Assertions.assertNotNull((Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"), (String)"Should contain a new asset");
    }

    @Test
    public void testImportArchiveAsTypeFromFilterUsingDefaultFormat() throws Exception {
        String resourcePath = "/test/cl-test.jar";
        GenericArchive archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new FileAsset(TestIOUtil.createFileFromResourceName("cl-test.jar")), resourcePath);
        Collection jars = archive.getAsType(JavaArchive.class, Filters.include((String)".*jar"));
        Assertions.assertEquals((int)1, (int)jars.size(), (String)"Unexpected result found");
        JavaArchive jar = (JavaArchive)((JavaArchive)jars.iterator().next()).add((Asset)new StringAsset("test file content"), "test.txt");
        Assertions.assertEquals((Object)resourcePath, (Object)jar.getName(), (String)"JAR imported with wrong name");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass.class"), (String)"Class in JAR not imported");
        Assertions.assertNotNull((Object)jar.get("test/classloader/DummyClass$DummyInnerClass.class"), (String)"Inner Class in JAR not imported");
        Assertions.assertNotNull((Object)((ArchiveAsset)archive.get(resourcePath).getAsset()).getArchive().get("test.txt"), (String)"Should contain a new asset");
    }

    @Test
    public void testFilter() throws Exception {
        GenericArchive archive = (GenericArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).importFrom(TestIOUtil.createFileFromResourceName("cl-test.jar"))).as(GenericArchive.class);
        GenericArchive filtered = (GenericArchive)archive.filter(Filters.include((String)".*MANIFEST\\.MF"));
        Assertions.assertEquals((int)2, (int)filtered.getContent().size());
        Assertions.assertTrue((boolean)filtered.contains(ArchivePaths.create((String)"META-INF/MANIFEST.MF")));
    }

    @Test
    public void testImportArchiveFromStringThrowExceptionIfClassIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            GenericArchive cfr_ignored_0 = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType((Class)null, "/path", ArchiveFormat.ZIP);
        });
    }

    @Test
    public void testImportArchiveFromStringThrowExceptionIfPathIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, (String)null, ArchiveFormat.ZIP);
        });
    }

    @Test
    public void testImportArchiveFromStringThrowExceptionIfFormatIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, "/path", null);
        });
    }

    @Test
    public void testImportArchiveFromArchivePathThrowExceptionIfClassIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            GenericArchive cfr_ignored_0 = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType((Class)null, ArchivePaths.create((String)"/path"), ArchiveFormat.ZIP);
        });
    }

    @Test
    public void testImportArchiveFromArchivePathThrowExceptionIfPathIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, (ArchivePath)null, ArchiveFormat.ZIP);
        });
    }

    @Test
    public void testImportArchiveFromArchivePathThrowExceptionIfFormatIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, ArchivePaths.create((String)"/path"), null);
        });
    }

    @Test
    public void testImportArchiveFromFilterThrowExceptionIfClassIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType((Class)null, Filters.includeAll(), ArchiveFormat.ZIP));
    }

    @Test
    public void testImportArchiveFromFilterThrowExceptionIfPathIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, (Filter)null, ArchiveFormat.ZIP));
    }

    @Test
    public void testImportArchiveFromFilterThrowExceptionIfFormatIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).getAsType(JavaArchive.class, Filters.includeAll(), null));
    }

    @Test
    public void testGetAsTypeString() {
        T archive = this.getArchive();
        GenericArchive child = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        archive.add((Archive)child, "/", ZipExporter.class);
        GenericArchive found = (GenericArchive)archive.getAsType(GenericArchive.class, child.getName());
        Assertions.assertNotNull((Object)found);
    }

    @Test
    public void testGetAsTypeArchivePath() {
        T archive = this.getArchive();
        GenericArchive child = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        archive.add((Archive)child, "/", ZipExporter.class);
        GenericArchive found = (GenericArchive)archive.getAsType(GenericArchive.class, ArchivePaths.create((String)child.getName()));
        Assertions.assertNotNull((Object)found);
    }

    @Test
    public void testGetAsTypeWithFilter() {
        GenericArchive child1 = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        GenericArchive child2 = (GenericArchive)ShrinkWrap.create(GenericArchive.class);
        GenericArchive child3 = (GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"SHOULD_NOT_BE_FOUND.xxx");
        Archive archive = this.getArchive().add((Archive)child1, "/", ZipExporter.class).add((Archive)child2, "/", ZipExporter.class).add((Archive)child3, "/", ZipExporter.class);
        Collection matches = archive.getAsType(GenericArchive.class, Filters.include((String)".*\\.jar"));
        Assertions.assertNotNull((Object)matches);
        Assertions.assertEquals((int)2, (int)matches.size(), (String)"Two archives should be found");
        for (GenericArchive match : matches) {
            if (match.getName().equals(child1.getName()) || match.getName().equals(child2.getName())) continue;
            Assertions.fail((String)("Wrong archive found, " + match.getName() + ". Expected " + child1.getName() + " or " + child2.getName()));
        }
    }

    @Test
    public void testToGetContent() {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent();
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assertions.assertTrue((boolean)this.compareAssets((Asset)asset, node1.getAsset()), (String)("Asset should existing in content with key: " + location.get()));
        Assertions.assertTrue((boolean)this.compareAssets((Asset)assetTwo, node2.getAsset()), (String)("Asset should existing in content with key: " + locationTwo.get()));
    }

    @Test
    public void testToGetContentFiltered() {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent(Filters.include((String)".*test2.*"));
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assertions.assertEquals((int)1, (int)content.size(), (String)"Only 1 Asset should have been included");
        Assertions.assertNull((Object)node1, (String)"Should not be included in content");
        Assertions.assertNotNull((Object)node2, (String)"Should be included in content");
    }

    @Test
    public void testAddArchiveToPathRequireArchivePath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.add((Archive)ShrinkWrap.create(JavaArchive.class), (ArchivePath)null, ZipExporter.class), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testAddArchiveToPathRequireStringPath() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.add((Archive)ShrinkWrap.create(JavaArchive.class), (String)null, ZipExporter.class));
    }

    @Test
    public void testAddArchiveToPathRequireArchive() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.add((Archive)null, ArchivePaths.root(), ZipExporter.class), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void shouldNotBeAbleToAddAssetOnIllegalPath() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        ArchivePath locationTwo = ArchivePaths.create((String)"/test.properties/somewhere");
        Assertions.assertThrows(IllegalArchivePathException.class, () -> ArchiveTestBase.lambda$shouldNotBeAbleToAddAssetOnIllegalPath$24(archive, (Asset)assetTwo, locationTwo));
    }

    @Test
    public void shouldNotBeAbleToAddDirectoryOnIllegalPath() {
        Object archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/somewhere/test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        Assertions.assertThrows(IllegalArchivePathException.class, () -> archive.addAsDirectory("/somewhere/test.properties/test"));
    }

    @Test
    public void testMergeRequiresSource() {
        Object archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.merge(null), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testMerge() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive);
        Node node1 = archive.get((ArchivePath)location);
        Node node2 = archive.get((ArchivePath)locationTwo);
        Assertions.assertTrue((boolean)this.compareAssets(node1.getAsset(), (Asset)asset), (String)("Asset should have been added to path: " + location.get()));
        Assertions.assertTrue((boolean)this.compareAssets(node2.getAsset(), (Asset)assetTwo), (String)("Asset should have been added to path: " + location.get()));
    }

    @Test
    public void testMergeToPath() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assertions.assertTrue((boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset), (String)("Asset should have been added to path: " + expectedPath.get()));
        Assertions.assertTrue((boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo), (String)("Asset should have been added to path: " + expectedPathTwo.getClass()));
    }

    @Test
    public void testMergeToStringPath() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        String baseLocation = "somewhere";
        archive.merge(sourceArchive, baseLocation);
        BasicPath expectedPath = new BasicPath(baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath(baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assertions.assertTrue((boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset), (String)("Asset should have been added to path: " + expectedPath.get()));
        Assertions.assertTrue((boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo), (String)("Asset should have been added to path: " + expectedPathTwo.getClass()));
    }

    @Test
    public void testMergeToPathWithFilter() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation, Filters.include((String)".*test2.*"));
        Assertions.assertEquals((int)1, (int)this.numAssets((Archive<?>)archive), (String)"Should only have merged 1");
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Assertions.assertTrue((boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset), (String)("Asset should have been added to path: " + expectedPath.get()));
    }

    @Test
    public void testMergeToStringPathWithFilter() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        String baseLocation = "somewhere";
        archive.merge(sourceArchive, baseLocation, Filters.include((String)".*test2.*"));
        Assertions.assertEquals((int)1, (int)this.numAssets((Archive<?>)archive), (String)"Should only have merged 1");
        BasicPath expectedPath = new BasicPath(baseLocation, (ArchivePath)locationTwo);
        Assertions.assertTrue((boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset), (String)("Asset should have been added to path: " + expectedPath.get()));
    }

    @Test
    public void testMergeWithFilter() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive, Filters.include((String)".*test2.*"));
        Assertions.assertEquals((int)1, (int)this.numAssets((Archive<?>)archive), (String)"Should only have merged 1");
        Assertions.assertTrue((boolean)this.compareAssets(archive.get((ArchivePath)locationTwo).getAsset(), (Asset)asset), (String)("Asset should have been added to path: " + locationTwo.get()));
    }

    @Test
    public void testMergeToPathRequiresPath() {
        T archive = this.getArchive();
        Assertions.assertThrows(IllegalArgumentException.class, () -> archive.merge(this.createNewArchive(), (ArchivePath)null), (String)"Should have throw an IllegalArgumentException");
    }

    @Test
    public void testMergeWithDirectories() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/dir/", "test.properties");
        BasicPath locationTwo = new BasicPath("/dir/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.add((Asset)asset, (ArchivePath)location);
        archive.merge(sourceArchive);
        Assertions.assertTrue((boolean)archive.contains("/dir/test.properties"), (String)"Archive should contain given element");
        Assertions.assertTrue((boolean)archive.contains("/dir/test2.properties"), (String)"Archive should contain given element");
        Assertions.assertEquals((int)2, (int)this.countChildren((Archive<?>)archive), (String)"Archive children count is invalid");
    }

    private int countChildren(Archive<?> archive) {
        Node node = archive.get("/");
        return this.countChildren(node);
    }

    private int countChildren(Node node) {
        int count = 0;
        for (Node child : node.getChildren()) {
            if (child.getAsset() != null) {
                ++count;
            }
            count += this.countChildren(child);
        }
        return count;
    }

    @Test
    public void testAddArchiveToPath() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation, ZipExporter.class);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        Node node = archive.get((ArchivePath)expectedPath);
        Assertions.assertNotNull((Object)node, (String)("Asset should have been added to path: " + expectedPath.get()));
        Assertions.assertInstanceOf(ArchiveAsset.class, (Object)node.getAsset(), (String)("An instance of ArchiveAsset should have been added to path: " + expectedPath.get()));
        ArchiveAsset archiveAsset = (ArchiveAsset)node.getAsset();
        Archive nestedArchive = archiveAsset.getArchive();
        Assertions.assertEquals(sourceArchive, (Object)nestedArchive, (String)"Nested Archive should be same archive that was added");
    }

    @Test
    public void testNestedArchiveContains() {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        sourceArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation, ZipExporter.class);
        BasicPath archivePath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)archivePath, "test.properties");
        Assertions.assertTrue((boolean)archive.contains((ArchivePath)expectedPath), (String)"Nested archive assets should be verified through a fully qualified path");
    }

    @Test
    public void testNestedArchiveGet() {
        T archive = this.getArchive();
        Archive<T> nestedArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(nestedArchive, (ArchivePath)baseLocation, ZipExporter.class);
        Archive<T> nestedNestedArchive = this.createNewArchive();
        nestedArchive.add(nestedNestedArchive, ArchivePaths.root(), ZipExporter.class);
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        nestedNestedArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath nestedArchivePath = new BasicPath((ArchivePath)baseLocation, nestedArchive.getName());
        BasicPath nestedNestedArchivePath = new BasicPath((ArchivePath)nestedArchivePath, nestedNestedArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)nestedNestedArchivePath, "test.properties");
        Node nestedNode = archive.get((ArchivePath)expectedPath);
        Assertions.assertNotNull((Object)nestedNode.getAsset(), (String)("Nested archive asset should be available through parent archive at " + expectedPath.get()));
    }

    @Test
    public void shouldMoveAsset() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "path1";
        String targetPath = "path2";
        archive.add((Asset)EmptyAsset.INSTANCE, "path1");
        archive.move("path1", "path2");
        Assertions.assertEquals((int)1, (int)this.numAssets(archive), (String)"The archive should have only one asset");
        Assertions.assertNotNull((Object)archive.get("path2"), (String)"The asset should be at the target path");
    }

    @Test
    public void shouldMoveDirectory() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "path1";
        String targetPath = "path2";
        archive.addAsDirectory("path1");
        archive.move("path1", "path2");
        Assertions.assertNull((Object)archive.get("path2").getAsset(), (String)"Directory should be at the new path");
    }

    @Test
    public void shouldMoveNotEmptyDirectory() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "path1";
        String targetPath = "path2";
        String childDirName = "childDir";
        String childDirPath = "path1/childDir";
        String childDirTargetPath = "path2/childDir";
        String childFileName1 = "file1";
        String childFilePath1 = "path1/childDir/file1";
        String childFileTargetPath1 = "path2/childDir/file1";
        String childFileName2 = "file2";
        String childFilePath2 = "path1/childDir/file2";
        String childFileTargetPath2 = "path2/childDir/file2";
        archive.addAsDirectory("path1");
        archive.addAsDirectory("path1/childDir");
        archive.add((Asset)EmptyAsset.INSTANCE, "path1/childDir/file1");
        archive.add((Asset)EmptyAsset.INSTANCE, "path1/childDir/file2");
        archive.move("path1", "path2");
        Assertions.assertNull((Object)archive.get("path2").getAsset(), (String)"Directory should be at the new path");
        Assertions.assertNull((Object)archive.get("path2/childDir").getAsset(), (String)"Child dir should be at the new path");
        Assertions.assertNotNull((Object)archive.get("path2/childDir/file1").getAsset(), (String)"Child asset1 should be at the new path");
        Assertions.assertNotNull((Object)archive.get("path2/childDir/file2").getAsset(), (String)"Child asset2 should be at the new path");
    }

    @Test
    public void shouldNotMoveAssetBecauseOfNonexistentPath() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        String sourcePath = "non-existent-path1";
        String targetPath = "path2";
        Assertions.assertThrows(IllegalArchivePathException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)archive.move("non-existent-path1", "path2");
        });
    }

    @Test
    public void ensureShallowCopyPreservesPointers() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "location");
        Archive copyArchive = archive.shallowCopy();
        Assertions.assertTrue((boolean)copyArchive.contains("location"));
        Assertions.assertSame((Object)copyArchive.get("location").getAsset(), (Object)archive.get("location").getAsset());
    }

    @Test
    public void ensureShallowCopyHasASeparateCollectionOfTheSamePointers() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "location");
        Archive copyArchive = archive.shallowCopy();
        archive.delete("location");
        Assertions.assertTrue((boolean)copyArchive.contains("location"));
    }

    @Test
    public void ensureShallowCopyOperatesOnNestedAssets() {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, "location/sublocation");
        Archive copyArchive = archive.shallowCopy();
        Assertions.assertTrue((boolean)copyArchive.contains("location"));
        Assertions.assertTrue((boolean)copyArchive.contains("location/sublocation"));
        Assertions.assertSame((Object)copyArchive.get("location/sublocation").getAsset(), (Object)archive.get("location/sublocation").getAsset());
    }

    @Test
    public void testId() {
        JavaArchive one = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        JavaArchive two = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"archive.jar");
        System.out.println("ALR: " + one.getId());
    }

    private boolean compareAssets(Asset one, Asset two) throws IllegalArgumentException {
        Validate.notNull((Object)one, (String)"Asset one must be specified");
        Validate.notNull((Object)two, (String)"Asset two must be specified");
        byte[] oneData = IOUtil.asByteArray((InputStream)one.openStream());
        byte[] twoData = IOUtil.asByteArray((InputStream)two.openStream());
        return Arrays.equals(oneData, twoData);
    }

    protected int numAssets(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        int assets = 0;
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            if (((Node)entry.getValue()).getAsset() == null) continue;
            ++assets;
        }
        return assets;
    }

    private String readStringAsset(ArchivePath path) throws IOException {
        Asset addedAsset = this.getArchive().get(path).getAsset();
        return new BufferedReader(new InputStreamReader(addedAsset.openStream())).readLine();
    }

    private static /* synthetic */ void lambda$shouldNotBeAbleToAddAssetOnIllegalPath$24(Archive archive, Asset assetTwo, ArchivePath locationTwo) throws Throwable {
        archive.add(assetTwo, locationTwo);
    }

    private static /* synthetic */ void lambda$testAddAssetWithNameRequiresAsset$7(Archive archive, ArchivePath path) throws Throwable {
        archive.add(null, path, "test.properties");
    }

    private static /* synthetic */ void lambda$testAddAssetWithNameRequiresName$6(Archive archive, ArchivePath path) throws Throwable {
        archive.add((Asset)new ClassLoaderAsset(NAME_TEST_PROPERTIES), path, null);
    }

    private static /* synthetic */ void lambda$testAddAssetWithNameRequiresArchivePath$4(Archive archive, Asset asset) throws Throwable {
        archive.add(asset, (ArchivePath)null, "test.properties");
    }

    private static /* synthetic */ void lambda$testAddWithStringPathRequiresPath$2(Archive archive, Asset asset) throws Throwable {
        archive.add(asset, (String)null);
    }

    private static /* synthetic */ void lambda$testAddRequiresPath$0(Archive archive, Asset asset) throws Throwable {
        archive.add(asset, (ArchivePath)null);
    }
}

