/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.util.Optional;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ContainerTestExtension
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<ArchiveType> classAnnotation = context.getTestClass().map(cls -> cls.getAnnotation(ArchiveType.class));
        Optional<ArchiveType> methodAnnotation = context.getTestMethod().map(mth -> mth.getAnnotation(ArchiveType.class));
        if (methodAnnotation.isPresent()) {
            if (classAnnotation.isPresent() && this.supportsArchiveType(methodAnnotation.get().value(), classAnnotation.get().value())) {
                return ConditionEvaluationResult.enabled((String)"Method annotation matches class annotation.");
            }
            return ConditionEvaluationResult.disabled((String)"Method annotation does not match class annotation.");
        }
        return ConditionEvaluationResult.enabled((String)"No method annotation present.");
    }

    private boolean supportsArchiveType(Class<?> archiveType, Class<?> testCaseArchiveType) {
        Class<?>[] supportedInterfaces;
        for (Class<?> supportedInterface : supportedInterfaces = testCaseArchiveType.getInterfaces()) {
            if (!archiveType.isAssignableFrom(supportedInterface)) continue;
            return true;
        }
        return false;
    }
}

