/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.IllegalOverwriteException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassA;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassParent;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestExtension;
import org.jboss.shrinkwrap.impl.base.test.SecurityActions;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyClassForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyInterfaceForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.nested1.EmptyClassForFiltersTest1;
import org.jboss.shrinkwrap.impl.base.test.dummy.nested2.EmptyClassForFiltersTest2;
import org.jboss.shrinkwrap.impl.base.test.dummy.nested3.EmptyClassForFiltersTest3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ContainerTestExtension.class})
public abstract class DynamicContainerTestBase<T extends Archive<T>>
extends ArchiveTestBase<T> {
    public static String MANIFEST_FILE = "MANIFEST.MF";

    protected abstract ArchivePath getResourcePath();

    protected abstract ResourceContainer<T> getResourceContainer();

    protected abstract ArchivePath getClassPath();

    protected abstract ClassContainer<T> getClassContainer();

    protected abstract ArchivePath getManifestPath();

    protected abstract ManifestContainer<T> getManifestContainer();

    protected abstract ServiceProviderContainer<T> getServiceProviderContainer();

    protected abstract ArchivePath getLibraryPath();

    protected abstract LibraryContainer<T> getLibraryContainer();

    protected URL getURLForClassResource(String name) {
        return SecurityActions.getThreadContextClassLoader().getResource(name);
    }

    protected File getFileForClassResource(String name) throws Exception {
        return new File(this.getURLForClassResource(name).toURI());
    }

    protected Asset getAssetForClassResource(String name) {
        return new ClassLoaderAsset(name);
    }

    @BeforeEach
    public void createEmptyDirectory() {
        File emptyDir = this.createDirectory("org/jboss/shrinkwrap/impl/base/recursion/empty");
        Assertions.assertTrue((boolean)emptyDir.exists(), (String)("Empty directory not found at " + emptyDir.getAbsolutePath()));
        Assertions.assertEquals((int)0, (int)emptyDir.list().length, (String)"Directory not empty");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestResource() {
        this.getManifestContainer().setManifest("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestResourceInPackage() {
        this.getManifestContainer().setManifest(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestFile() throws Exception {
        this.getManifestContainer().setManifest(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestURL() {
        this.getManifestContainer().setManifest(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestAsset() {
        this.getManifestContainer().setManifest(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResource() {
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddNonExistentManifestResource() {
        String nonExistentResourceName = "ejb/security/ejb-jar.xml";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getManifestContainer().addAsManifestResource("ejb/security/ejb-jar.xml"));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResourceRecursively() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolder), this.getManifestPath(), baseFolder);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFile() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResourceRecursivelyWithTarget() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource(baseFolder, baseFolder);
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolder), this.getManifestPath(), baseFolder);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testArchiveContainsEmptyManifestResourceDirectory() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource(baseFolder);
        String emptyFolderPath = baseFolder + "/empty";
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(emptyFolderPath), this.getManifestPath(), emptyFolderPath);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFileRecursively() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getManifestContainer().addAsManifestResource(baseFolder);
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getManifestPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFileRecursivelyWithTarget() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getManifestContainer().addAsManifestResource(baseFolder, "/new-name");
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFileRecursivelyWithArchivePath() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getManifestContainer().addAsManifestResource(baseFolder, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResourceRecursivelyWithTargetArchivePath() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource(baseFolderPath, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getManifestContainer().addAsManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getManifestPath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestURLRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        URL baseFolderURL = this.getURLForClassResource(baseFolderPath);
        this.getManifestContainer().addAsManifestResource(baseFolderURL, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetResource() {
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetFile() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetURL() {
        this.getManifestContainer().addAsManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetAsset() {
        this.getManifestContainer().addAsManifestResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetResource() {
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetFile() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetURL() {
        this.getManifestContainer().addAsManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetAsset() {
        this.getManifestContainer().addAsManifestResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProvider() {
        this.getManifestContainer().addAsServiceProvider(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + DummyInterfaceForTest.class.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderString() throws Exception {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        String serviceInterface = "do.not.exist.api.Dummy";
        this.getManifestContainer().addAsServiceProvider(serviceInterface, impls);
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + serviceInterface);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        this.assertServiceProviderContent(this.getArchive().get((ArchivePath)testPath), impls);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderStringInterfaceValidation() {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getManifestContainer().addAsServiceProvider(null, impls));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderStringImplementationsValidation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getManifestContainer().addAsServiceProvider("do.not.exist.impl.Dummy1", (String[])null));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderStringImplementationsValueValidation() {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", null};
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getManifestContainer().addAsServiceProvider("do.not.exist.impl.Dummy", impls));
    }

    protected void assertServiceProviderContent(Node node, String[] impls) throws IOException {
        try (BufferedReader reader = this.createReader(node.getAsset());){
            for (String impl : impls) {
                Assertions.assertEquals((Object)impl, (Object)reader.readLine(), (String)("Wrong entry in service provider: " + impl));
            }
        }
    }

    private BufferedReader createReader(Asset asset) {
        InputStream openStream = asset.openStream();
        return new BufferedReader(new InputStreamReader(openStream));
    }

    @Test
    @ArchiveType(value=ServiceProviderContainer.class)
    public void testAddServiceProviderWithClasses() {
        Class[] expectedResources;
        this.getServiceProviderContainer().addAsServiceProviderAndClasses(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + DummyInterfaceForTest.class.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        for (Class expectedResource : expectedResources = new Class[]{DummyInterfaceForTest.class, DummyClassForTest.class}) {
            BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((Class)expectedResource));
            this.assertContainsClass((ArchivePath)expectedClassPath);
        }
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackage() {
        this.getManifestContainer().addAsManifestResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackages() {
        this.getManifestContainer().addAsManifestResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackageStringTarget() {
        this.getManifestContainer().addAsManifestResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackagePathTarget() {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getManifestContainer().addAsManifestResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getManifestPath(), targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceResource() {
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFile() throws Exception {
        this.getResourceContainer().addAsResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFileRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        File baseFolder = this.getFileForClassResource(baseFolderPath);
        this.getResourceContainer().addAsResource(baseFolder);
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getResourcePath(), "/recursion");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFileRecursivelyWithTarget() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getResourceContainer().addAsResource(baseFolder, "/new-name");
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolderPath);
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), baseFolderPath);
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceRecursivelyWithTarget() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolderPath, "/new-name");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceRecursivelyWithTargetPath() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolderPath, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getResourceContainer().addAsResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getResourcePath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetResourceFromJar() {
        this.getManifestContainer().addAsManifestResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "String.class");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResourceFromJar() {
        this.getResourceContainer().addAsResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "String.class");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Logger.getAnonymousLogger().info(this.getArchive().toString(true));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResource() {
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResourceOverride() {
        BasicPath targetPath = new BasicPath("META-INF/Test.txt");
        BasicPath targetPath2 = new BasicPath("META-INF");
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)targetPath);
        boolean gotExpectedException = false;
        try {
            this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)targetPath2);
        }
        catch (IllegalOverwriteException ioe) {
            gotExpectedException = true;
        }
        BasicPath testPath = new BasicPath(this.getResourcePath(), "META-INF/Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)gotExpectedException);
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetFile() throws Exception {
        this.getResourceContainer().addAsResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetURL() {
        this.getResourceContainer().addAsResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceUrlWithTargetStringRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        URL baseFolderUrl = this.getURLForClassResource(baseFolderPath);
        this.getResourceContainer().addAsResource(baseFolderUrl, "/new-name");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceUrlWithTargetArchivePathRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        URL baseFolderUrl = this.getURLForClassResource(baseFolderPath);
        this.getResourceContainer().addAsResource(baseFolderUrl, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testArchiveContainsEmptyResourceDirectory() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolder);
        String emptyFolderPath = baseFolder + "/empty";
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(emptyFolderPath), this.getResourcePath(), emptyFolderPath);
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetAsset() {
        this.getResourceContainer().addAsResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetResource() {
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetFile() throws Exception {
        this.getResourceContainer().addAsResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetURL() {
        this.getResourceContainer().addAsResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetAsset() {
        this.getResourceContainer().addAsResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackage() {
        this.getResourceContainer().addAsResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackages() {
        this.getResourceContainer().addAsResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackageStringTarget() {
        this.getResourceContainer().addAsResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackagePathTarget() {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getResourceContainer().addAsResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getResourcePath(), targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClass() {
        this.getClassContainer().addClass(DummyClassA.class);
        this.ensureClassesAdded();
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClasses() {
        this.getClassContainer().addClasses(new Class[]{DummyClassA.class});
        this.ensureClassesAdded();
    }

    private void ensureClassesAdded() {
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
        BasicPath expectedPathInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class));
        BasicPath expectedPathInnerClassParent = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassParent.ParentInnerClass.class));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPathInnerClass), (String)"Adding a class should also add its inner classes");
        Assertions.assertFalse((boolean)this.getArchive().contains((ArchivePath)expectedPathInnerClassParent), (String)"Adding a class should not add the public inner classes of its parent");
        BasicPath expectedPathPrivateInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class).get().replaceAll("InnerClass", "Test"));
        BasicPath expectedPathAnonymousInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class).get().replaceAll("InnerClass", "1"));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPathPrivateInnerClass), (String)"Adding a class should also add its private inner classes");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPathAnonymousInnerClass), (String)"Adding a class should also add the anonymous inner classes");
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesByFqn() {
        Class<DummyClassA> classToAdd = DummyClassA.class;
        this.getClassContainer().addClass(classToAdd.getName());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(classToAdd));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesByFqnAndTccl() {
        Class<DummyClassA> classToAdd = DummyClassA.class;
        this.getClassContainer().addClass(classToAdd.getName(), classToAdd.getClassLoader());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(classToAdd));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassByFqnAndClassLoader() throws Exception {
        ClassLoader emptyClassLoader = new ClassLoader(null){};
        ClassLoader originalClassLoader = SecurityActions.getThreadContextClassLoader();
        ClassLoaderTester classCl = new ClassLoaderTester("cl-test.jar");
        try {
            Thread.currentThread().setContextClassLoader(emptyClassLoader);
            this.getClassContainer().addClass("test.classloader.DummyClass", (ClassLoader)classCl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        Assertions.assertTrue((boolean)classCl.isUsedForInnerClasses(), (String)"Classloader not used to load inner class");
        BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((String)"/test/classloader/DummyClass"));
        this.assertContainsClass((ArchivePath)expectedClassPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassFromBootstrapCl() {
        ClassContainer<T> archive = this.getClassContainer();
        archive.addClass(String.class);
        ArchivePath classRoot = this.getClassPath();
        Assertions.assertTrue((boolean)((Archive)archive).contains(ArchivePaths.create((ArchivePath)classRoot, (String)"/java/lang/String.class")), (String)"Archive does not contain class added from bootstrap CL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassFromCustomClassloader() throws Exception {
        ClassLoader emptyClassLoader = new ClassLoader(null){};
        ClassLoader originalClassLoader = SecurityActions.getThreadContextClassLoader();
        ClassLoaderTester myClassLoader = new ClassLoaderTester("cl-test.jar");
        try {
            Thread.currentThread().setContextClassLoader(emptyClassLoader);
            Class<?> dummyClass = myClassLoader.loadClass("test.classloader.DummyClass");
            this.getClassContainer().addClass(dummyClass);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        Assertions.assertTrue((boolean)myClassLoader.isUsedForInnerClasses(), (String)"Classloader not used to load inner class");
        BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((String)"/test/classloader/DummyClass"));
        this.assertContainsClass((ArchivePath)expectedClassPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesFromCustomClassloader() throws Exception {
        String[] expectedResources;
        ClassLoader emptyClassLoader = new ClassLoader(null){};
        ClassLoader originalClassLoader = SecurityActions.getThreadContextClassLoader();
        ClassLoaderTester myClassLoader = new ClassLoaderTester("cl-test.jar");
        try {
            Thread.currentThread().setContextClassLoader(emptyClassLoader);
            Class<?> dummyClass = myClassLoader.loadClass("test.classloader.DummyClass");
            Class<?> dummyInnerClass = myClassLoader.loadClass("test.classloader.DummyClass$DummyInnerClass");
            this.getClassContainer().addClasses(new Class[]{dummyClass, dummyInnerClass});
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        Assertions.assertTrue((boolean)myClassLoader.isUsedForInnerClasses(), (String)"Classloader not used to load inner class");
        for (String expectedResource : expectedResources = new String[]{"/test/classloader/DummyClass", "/test/classloader/DummyClass$DummyInnerClass"}) {
            BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((String)expectedResource));
            this.assertContainsClass((ArchivePath)expectedClassPath);
        }
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackage() {
        this.getClassContainer().addPackage(DummyClassA.class.getPackage());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageNonRecursive() {
        this.getClassContainer().addPackages(false, new Package[]{DummyClassA.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageRecursiveFiltered() {
        this.getClassContainer().addPackages(true, Filters.include((Class[])new Class[]{DynamicContainerTestBase.class}), new Package[]{DynamicContainerTestBase.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        Assertions.assertEquals((int)1, (int)this.numAssets((Archive<?>)this.getArchive()), (String)"Should only be one class added");
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageAsString() {
        this.getClassContainer().addPackage(DummyClassA.class.getPackage().getName());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageAsStringNonRecursive() {
        this.getClassContainer().addPackages(false, new String[]{DummyClassA.class.getPackage().getName()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageAsStringRecursiveFiltered() {
        this.getClassContainer().addPackages(true, Filters.include((Class[])new Class[]{DynamicContainerTestBase.class}), new String[]{DynamicContainerTestBase.class.getPackage().getName()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        Assertions.assertEquals((int)1, (int)this.numAssets((Archive<?>)this.getArchive()), (String)"Should only be one class added");
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    public void testAddNonExistentPackage() {
        String packageName = "non.existent.package";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            JavaArchive cfr_ignored_0 = (JavaArchive)archive.addPackages(true, new Package[]{Package.getPackage("non.existent.package")});
        });
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testShouldIncludeOnlySelectedPackages() {
        Package parent = DummyClassForTest.class.getPackage();
        Package nested1 = EmptyClassForFiltersTest1.class.getPackage();
        Package nested2 = EmptyClassForFiltersTest2.class.getPackage();
        this.getClassContainer().addPackages(true, Filters.include((Package[])new Package[]{nested1, nested2}), new String[]{parent.getName()});
        BasicPath expectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest1.class));
        BasicPath expectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest2.class));
        BasicPath notExpectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest3.class));
        BasicPath notExpectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassForTest.class));
        Assertions.assertEquals((int)2, (int)this.numAssets((Archive<?>)this.getArchive()), (String)"Should only include selected packages");
        this.assertContainsClass((ArchivePath)expectedPath1);
        this.assertContainsClass((ArchivePath)expectedPath2);
        this.assertNotContainsClass((ArchivePath)notExpectedPath1);
        this.assertNotContainsClass((ArchivePath)notExpectedPath2);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testShouldExcludeOnlySelectedPackages() {
        Package parent = DummyClassForTest.class.getPackage();
        Package nested1 = EmptyClassForFiltersTest1.class.getPackage();
        Package nested2 = EmptyClassForFiltersTest2.class.getPackage();
        this.getClassContainer().addPackages(true, Filters.exclude((Package[])new Package[]{nested1, nested2}), new String[]{parent.getName()});
        BasicPath expectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest3.class));
        BasicPath expectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassForTest.class));
        BasicPath notExpectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest1.class));
        BasicPath notExpectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest2.class));
        this.assertContainsClass((ArchivePath)expectedPath1);
        this.assertContainsClass((ArchivePath)expectedPath2);
        this.assertNotContainsClass((ArchivePath)notExpectedPath1);
        this.assertNotContainsClass((ArchivePath)notExpectedPath2);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void shouldIncludeOnlySelectedClasses() {
        this.getClassContainer().addPackages(true, Filters.include((Class[])new Class[]{DynamicContainerTestBase.class, ArchiveType.class}), new String[]{DynamicContainerTestBase.class.getPackage().getName()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        BasicPath expectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(ArchiveType.class));
        Assertions.assertEquals((int)2, (int)this.numAssets((Archive<?>)this.getArchive()), (String)"Should only include selected classes");
        this.assertContainsClass((ArchivePath)expectedPath);
        this.assertContainsClass((ArchivePath)expectedPath2);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void shouldExcludeOnlySelectedClasses() {
        this.getClassContainer().addPackages(true, Filters.exclude((Class[])new Class[]{DynamicContainerTestBase.class, ArchiveType.class}), new String[]{DynamicContainerTestBase.class.getPackage().getName()});
        BasicPath notExpectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        BasicPath notExpectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(ArchiveType.class));
        Assertions.assertFalse((boolean)this.getArchive().contains((ArchivePath)notExpectedPath), (String)("Archive should not contain " + notExpectedPath.get()));
        Assertions.assertFalse((boolean)this.getArchive().contains((ArchivePath)notExpectedPath2), (String)("Archive should not contain " + notExpectedPath2.get()));
    }

    private void addExemplaryClasses() {
        this.getClassContainer().addPackages(true, new Package[]{DummyClassA.class.getPackage(), DummyClassForTest.class.getPackage()});
        this.getClassContainer().addDefaultPackage();
        ArchivePath classPath1 = this.getArchivePathFromClass(DummyClassA.class);
        ArchivePath classPath2 = this.getArchivePathFromClass(DummyClassForTest.class);
        ArchivePath classPath3 = this.getArchivePathFromClass(EmptyClassForFiltersTest1.class);
        this.assertContainsClass(classPath1);
        this.assertContainsClass(classPath2);
        this.assertContainsClass(classPath3);
    }

    String getPrivInnerClassPath(Class<?> clazz, String className) {
        String innerClassPath = "/" + clazz.getName().replace(".", "/");
        String privInnerClassPath = innerClassPath + "$" + className;
        return privInnerClassPath + ".class";
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClass() {
        this.addExemplaryClasses();
        this.getClassContainer().deleteClass(DummyClassA.class);
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassA.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassA.InnerClass.class));
        this.assertNotContainsClass(this.getPrivInnerClassPath(DummyClassA.class, "Test"));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClassNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deleteClass((Class)null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClassByFqn() {
        this.addExemplaryClasses();
        this.getClassContainer().deleteClass(DummyClassA.class.getName());
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassA.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClassByFqnNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deleteClass((String)null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClasses() {
        this.addExemplaryClasses();
        this.getClassContainer().deleteClasses(new Class[]{DummyClassA.class, DummyClassForTest.class});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassA.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClassesNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deleteClasses((Class[])null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteClassesOneClassNull() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deleteClasses(new Class[]{DummyClassA.class, null, DummyClassForTest.class}));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeleteDefaultPackage() {
        this.addExemplaryClasses();
        this.getClassContainer().deleteDefaultPackage();
        boolean actual = this.getArchive().contains("ClassInDefaultPackage.class");
        Assertions.assertFalse((boolean)actual, (String)"Class from default package should not be in the archive");
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackage() {
        this.addExemplaryClasses();
        this.getClassContainer().deletePackage(DummyClassForTest.class.getPackage());
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackageNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackage((Package)null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackageAsString() {
        this.addExemplaryClasses();
        this.getClassContainer().deletePackage(DummyClassForTest.class.getPackage().getName());
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackageAsStringNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackage((String)null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesWithoutSubpackages() {
        this.addExemplaryClasses();
        this.getClassContainer().deletePackages(false, new Package[]{DummyClassForTest.class.getPackage(), EmptyClassForFiltersTest2.class.getPackage()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest2.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesWithSubpackages() {
        this.addExemplaryClasses();
        this.getClassContainer().deletePackages(true, new Package[]{DummyClassForTest.class.getPackage(), EmptyClassForFiltersTest2.class.getPackage()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, (Package[])null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesOnePackageNull() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, new Package[]{DummyClassForTest.class.getPackage(), null, EmptyClassForFiltersTest1.class.getPackage()}));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringWithoutSubpackages() {
        this.addExemplaryClasses();
        this.getClassContainer().deletePackages(false, new String[]{DummyClassForTest.class.getPackage().getName(), EmptyClassForFiltersTest2.class.getPackage().getName()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest2.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringWithSubpackages() {
        this.addExemplaryClasses();
        this.getClassContainer().deletePackages(true, new String[]{DummyClassForTest.class.getPackage().getName(), EmptyClassForFiltersTest2.class.getPackage().getName()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
        this.assertNotContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringNullParam() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, (String[])null));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringOnePackageNull() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, new String[]{DummyClassForTest.class.getPackage().getName(), null, EmptyClassForFiltersTest1.class.getPackage().getName()}));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesFilteredWithoutSubpackages() {
        this.addExemplaryClasses();
        Filter filter = Filters.include((Class[])new Class[]{DummyClassForTest.class});
        this.getClassContainer().deletePackages(false, filter, new String[]{DummyClassForTest.class.getPackage().getName()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
        this.assertContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesFilteredWithSubpackages() {
        this.addExemplaryClasses();
        Filter filter = Filters.include((Class[])new Class[]{DummyClassForTest.class});
        this.getClassContainer().deletePackages(true, filter, new String[]{DummyClassForTest.class.getPackage().getName()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
        this.assertContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesFilteredNullFilter() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, (Filter)null, new Package[]{DummyClassForTest.class.getPackage()}));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesFilteredNullPackage() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, Filters.includeAll(), new Package[]{null}));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringsFilteredWithoutSubpackages() {
        this.addExemplaryClasses();
        Filter filter = Filters.include((Class[])new Class[]{DummyClassForTest.class});
        this.getClassContainer().deletePackages(false, filter, new String[]{DummyClassForTest.class.getPackage().getName()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
        this.assertContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringsFilteredWithSubpackages() {
        this.addExemplaryClasses();
        Filter filter = Filters.include((Class[])new Class[]{DummyClassForTest.class});
        this.getClassContainer().deletePackages(true, filter, new String[]{DummyClassForTest.class.getPackage().getName()});
        this.assertNotContainsClass(this.getArchivePathFromClass(DummyClassForTest.class));
        this.assertContainsClass(this.getArchivePathFromClass(EmptyClassForFiltersTest1.class));
        this.assertContainsClass(this.getArchivePathFromClass(DummyInterfaceForTest.class));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringsFilteredNullFilter() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, (Filter)null, new String[]{DummyClassForTest.class.getPackage().getName()}));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testDeletePackagesAsStringsFilteredNullPackage() {
        this.addExemplaryClasses();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getClassContainer().deletePackages(false, Filters.includeAll(), (String[])null));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResource() {
        this.getLibraryContainer().addAsLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryFile() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResourceRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolderPath);
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getLibraryPath(), baseFolderPath);
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testArchiveContainsEmptyLibraryDirectory() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolder);
        String emptyFolderPath = baseFolder + "/empty";
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(emptyFolderPath), this.getLibraryPath(), emptyFolderPath);
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResourceWithTargetRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolderPath, "/new-name");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getLibraryPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResourceWithTargetPathRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolderPath, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getLibraryPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryFileRecursively() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getLibraryContainer().addAsLibrary(baseFolder);
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getLibraryPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURLRecursively() {
        URL baseFolder = this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getLibraryContainer().addAsLibrary(baseFolder, "/recursion");
        this.assertArchiveContainsFolderRecursively(new File(baseFolder.getFile()), this.getLibraryPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURLWithArchivePathRecursively() {
        URL baseFolder = this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getLibraryContainer().addAsLibrary(baseFolder, (ArchivePath)new BasicPath("/recursion"));
        this.assertArchiveContainsFolderRecursively(new File(baseFolder.getFile()), this.getLibraryPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getLibraryContainer().addAsLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetResource() {
        this.getLibraryContainer().addAsLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetFile() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetURL() {
        this.getLibraryContainer().addAsLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetAsset() {
        this.getLibraryContainer().addAsLibrary(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetResource() {
        this.getLibraryContainer().addAsLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetFile() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetURL() {
        this.getLibraryContainer().addAsLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetAsset() {
        this.getLibraryContainer().addAsLibrary(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryArchive() {
        Archive archive = this.createNewArchive();
        this.getLibraryContainer().addAsLibrary(archive);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesResource() {
        this.getLibraryContainer().addAsLibraries(new String[]{"org/jboss/shrinkwrap/impl/base/asset/Test.properties", "org/jboss/shrinkwrap/impl/base/asset/Test2.properties"});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesFile() throws Exception {
        this.getLibraryContainer().addAsLibraries(new File[]{this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test2.properties")});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), "Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchive() {
        Archive archive = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        this.getLibraryContainer().addAsLibraries(new Archive[]{archive, archive2});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveCollection() {
        Archive archive = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        ArrayList archives = new ArrayList();
        archives.add(archive);
        archives.add(archive2);
        this.getLibraryContainer().addAsLibraries(archives);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveArrays() {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        Archive archive3 = this.createNewArchive();
        Archive archive4 = this.createNewArchive();
        Archive[] archiveArray1 = new Archive[]{archive1, archive2};
        Archive[] archiveArray2 = new Archive[]{archive3, archive4};
        this.getLibraryContainer().addAsLibraries((Archive[][])new Archive[][]{archiveArray1, archiveArray2});
        BasicPath testPath1 = new BasicPath(this.getLibraryPath(), archive1.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive2.getName());
        BasicPath testPath3 = new BasicPath(this.getLibraryPath(), archive3.getName());
        BasicPath testPath4 = new BasicPath(this.getLibraryPath(), archive4.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath1), (String)("Archive should contain " + testPath1));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath3), (String)("Archive should contain " + testPath3));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath4), (String)("Archive should contain " + testPath4));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveArraysWithNullArguments() {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        Archive archive3 = this.createNewArchive();
        Archive archive4 = this.createNewArchive();
        Archive[] archives = new Archive[]{archive1, archive2, archive3, archive4};
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getLibraryContainer().addAsLibraries((Archive[][])new Archive[][]{archives, null, null}));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveArraysWithNullValues() {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        Archive archive3 = this.createNewArchive();
        Archive archive4 = this.createNewArchive();
        Archive[] archives = new Archive[]{archive1, archive2, archive3, null, archive4, null};
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getLibraryContainer().addAsLibraries(archives));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryNotExistingResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getLibraryContainer().addAsLibrary("notExistingPath/notExistingJar.jar", "notExistingJar.jar"));
    }

    @Test
    public void testAddManifest() {
        String expectedManifestPath = "META-INF/MANIFEST.MF";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        Assertions.assertFalse((boolean)archive.contains(expectedManifestPath), (String)"Archive should not contain manifest file");
        archive.addManifest();
        Assertions.assertTrue((boolean)archive.contains(expectedManifestPath), (String)("Archive should contain manifest file: " + expectedManifestPath));
    }

    @Test
    public void testAddFileWithWhitespaceInFilename() {
        String manifest = "Whitespace manifest.MF";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        Assertions.assertFalse((boolean)archive.contains(manifest), (String)"Archive should not contain file");
        archive.addAsResource(manifest);
        Assertions.assertTrue((boolean)archive.contains(manifest), (String)("Archive should contain file: " + manifest));
    }

    @Test
    public void testAddingEmptyResourceDirectory() throws Exception {
        File directory = File.createTempFile("resources", null);
        directory.delete();
        directory.deleteOnExit();
        File svn = new File(directory, ".svn");
        svn.deleteOnExit();
        svn.mkdirs();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ((ZipExporter)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource(directory, "/")).as(ZipExporter.class)).exportTo((OutputStream)out);
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(out.toByteArray()));
        ZipEntry entry = zis.getNextEntry();
        Assertions.assertNotNull((Object)entry, (String)"Missing '.svn/' Entry from Exported Archive");
        Assertions.assertEquals((Object)".svn/", (Object)entry.getName(), (String)"Zip Entry Missing Expected Name '.svn/'");
        Assertions.assertTrue((boolean)entry.isDirectory(), (String)"Zip Entry '.svn/' Not A Directory");
        zis.closeEntry();
        zis.close();
    }

    @Test
    public void addDuplicateResourceMakesOverwrite() throws IOException {
        Archive archive = this.createNewArchive();
        ArchivePath path = ArchivePaths.create((String)"testPath");
        archive.add((Asset)EmptyAsset.INSTANCE, path);
        String content = "newContent";
        archive.add((Asset)new StringAsset("newContent"), path);
        String contentFound = new BufferedReader(new InputStreamReader(archive.get(path).getAsset().openStream())).readLine();
        Assertions.assertEquals((Object)"newContent", (Object)contentFound);
    }

    @Test
    public void addResourceToExistingDirThrowsIllegalOverwriteException() {
        Archive archive = this.createNewArchive();
        ArchivePath path = ArchivePaths.create((String)"testPath");
        archive.addAsDirectories(new ArchivePath[]{path});
        Assertions.assertThrows(IllegalOverwriteException.class, () -> archive.add((Asset)new StringAsset("failContent"), path), (String)"Expected IllegalOverwriteException not received");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void containsShouldReturnFalseWhenParentNodeHasBeenDeleted() {
        Archive archive = this.createNewArchive();
        String archivePath = "WEB-INF/classes/org/drools/guvnor/gwtutil/";
        String file = "WEB-INF/classes/org/drools/guvnor/gwtutil/file";
        archive.add((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        Assertions.assertTrue((boolean)archive.contains("WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        archive.delete(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil"));
        Assertions.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/")));
        Assertions.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file")));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void shouldDeleteArchivePathWithTrailingSlash() {
        Archive archive = this.createNewArchive();
        String archivePath = "WEB-INF/classes/org/drools/guvnor/gwtutil/";
        String file = "WEB-INF/classes/org/drools/guvnor/gwtutil/file";
        archive.add((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        Assertions.assertTrue((boolean)archive.contains("WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        archive.delete(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/"));
        Assertions.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/")));
        Assertions.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file")));
    }

    private void assertNotContainsClass(ArchivePath notExpectedPath) {
        Assertions.assertFalse((boolean)this.getArchive().contains(notExpectedPath), (String)("Located unexpected class at " + notExpectedPath.get()));
    }

    private void assertNotContainsClass(String notExpectedPath) {
        Assertions.assertFalse((boolean)this.getArchive().contains(notExpectedPath), (String)("Located unexpected class at " + notExpectedPath));
    }

    private void assertContainsClass(ArchivePath expectedPath) {
        Assertions.assertTrue((boolean)this.getArchive().contains(expectedPath), (String)("A class should be located at " + expectedPath.get()));
    }

    private void assertArchiveContainsFolderRecursively(File file, ArchivePath base, String target) {
        BasicPath testPath = new BasicPath(base, target);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.assertArchiveContainsFolderRecursively(child, base, target + "/" + child.getName());
            }
            int folderInArchiveSize = this.getArchive().get((ArchivePath)testPath).getChildren().size();
            Assertions.assertEquals((int)file.listFiles().length, (int)folderInArchiveSize, (String)("Wrong number of files in the archive folder: " + testPath.get()));
        }
    }

    protected File getTarget() {
        try {
            return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Could not obtain the target URI", urise);
        }
    }

    private File createDirectory(String resourcePath) {
        String[] split;
        File directory = this.getTarget();
        for (String folder : split = resourcePath.split("/")) {
            boolean created;
            if ((directory = new File(directory, folder)).exists() || (created = directory.mkdir())) continue;
            throw new RuntimeException("Impossible to create directory at path:" + directory.getAbsolutePath());
        }
        return directory;
    }

    private ArchivePath getArchivePathFromClass(Class<?> clazz) {
        return new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(clazz));
    }

    private class ClassLoaderTester
    extends URLClassLoader {
        private boolean usedForInnerClasses;

        public ClassLoaderTester(String resource) throws MalformedURLException, URISyntaxException {
            this(TestIOUtil.createFileFromResourceName(resource));
        }

        private ClassLoaderTester(File jar) throws MalformedURLException {
            super(new URL[]{jar.toURI().toURL()}, (ClassLoader)null);
            this.usedForInnerClasses = false;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            this.usedForInnerClasses = true;
            return super.getResources(name);
        }

        public boolean isUsedForInnerClasses() {
            return this.usedForInnerClasses;
        }
    }
}

