/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.File;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class DynamicEnterpriseContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    protected abstract ArchivePath getModulePath();

    protected abstract ArchivePath getApplicationPath();

    protected abstract EnterpriseContainer<T> getEnterpriseContainer();

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLResource() {
        this.getEnterpriseContainer().setApplicationXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLResourceInPackage() {
        this.getEnterpriseContainer().setApplicationXML(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLFile() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLURL() {
        this.getEnterpriseContainer().setApplicationXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLAsset() {
        this.getEnterpriseContainer().setApplicationXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResource() {
        this.getEnterpriseContainer().addAsApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationFile() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addAsApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetResource() {
        this.getEnterpriseContainer().addAsApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetURL() {
        this.getEnterpriseContainer().addAsApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetAsset() {
        this.getEnterpriseContainer().addAsApplicationResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetResource() {
        this.getEnterpriseContainer().addAsApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetURL() {
        this.getEnterpriseContainer().addAsApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetAsset() {
        this.getEnterpriseContainer().addAsApplicationResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackage() {
        this.getEnterpriseContainer().addAsApplicationResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackages() {
        this.getEnterpriseContainer().addAsApplicationResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath2), (String)("Archive should contain " + testPath2));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackageStringTarget() {
        this.getEnterpriseContainer().addAsApplicationResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackagePathTarget() {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getEnterpriseContainer().addAsApplicationResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getApplicationPath(), targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleResource() {
        this.getEnterpriseContainer().addAsModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulesResources() {
        this.getEnterpriseContainer().addAsModules(new String[]{"org/jboss/shrinkwrap/impl/base/asset/Test.properties", "org/jboss/shrinkwrap/impl/base/asset/Test2.properties"});
        BasicPath expectedPath1 = new BasicPath(this.getModulePath(), "Test.properties");
        BasicPath expectedPath2 = new BasicPath(this.getModulePath(), "Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath1), (String)("Archive should contain " + expectedPath1));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath2), (String)("Archive should contain " + expectedPath2));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleFile() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulesFiles() throws Exception {
        this.getEnterpriseContainer().addAsModules(new File[]{this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test2.properties")});
        BasicPath expectedPath1 = new BasicPath(this.getModulePath(), "Test.properties");
        BasicPath expectedPath2 = new BasicPath(this.getModulePath(), "Test2.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath1), (String)("Archive should contain " + expectedPath1));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath2), (String)("Archive should contain " + expectedPath2));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleURL() {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addAsModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), (ArchivePath)targetPath);
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetResource() {
        this.getEnterpriseContainer().addAsModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetURL() {
        this.getEnterpriseContainer().addAsModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetAsset() {
        this.getEnterpriseContainer().addAsModule(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetResource() {
        this.getEnterpriseContainer().addAsModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetURL() {
        this.getEnterpriseContainer().addAsModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetAsset() {
        this.getEnterpriseContainer().addAsModule(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleArchive() {
        Archive archive = this.createNewArchive();
        this.getEnterpriseContainer().addAsModule(archive);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), archive.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath), (String)("Archive should contain " + expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulesArchives() {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        this.getEnterpriseContainer().addAsModules(new Archive[]{archive1, archive2});
        BasicPath expectedPath1 = new BasicPath(this.getModulePath(), archive1.getName());
        BasicPath expectedPath2 = new BasicPath(this.getModulePath(), archive2.getName());
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath1), (String)("Archive should contain " + expectedPath1));
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)expectedPath2), (String)("Archive should contain " + expectedPath2));
    }
}

