/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.container.ResourceAdapterContainer;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class DynamicResourceAdapterContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    protected abstract ArchivePath getResourceAdapterPath();

    protected abstract ResourceAdapterContainer<T> getResourceAdapterContainer();

    @Test
    @ArchiveType(value=ResourceAdapterContainer.class)
    public void testSetResourceAdapterXMLResource() {
        this.getResourceAdapterContainer().setResourceAdapterXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourceAdapterPath(), "ra.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceAdapterContainer.class)
    public void testSetResourceAdapterXMLResourceInPackage() {
        this.getResourceAdapterContainer().setResourceAdapterXML(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getResourceAdapterPath(), "ra.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceAdapterContainer.class)
    public void testSetResourceAdapterXMLFile() throws Exception {
        this.getResourceAdapterContainer().setResourceAdapterXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourceAdapterPath(), "ra.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceAdapterContainer.class)
    public void testSetResourceAdapterXMLURL() {
        this.getResourceAdapterContainer().setResourceAdapterXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourceAdapterPath(), "ra.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }

    @Test
    @ArchiveType(value=ResourceAdapterContainer.class)
    public void testSetResourceAdapterXMLAsset() {
        this.getResourceAdapterContainer().setResourceAdapterXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourceAdapterPath(), "ra.xml");
        Assertions.assertTrue((boolean)this.getArchive().contains((ArchivePath)testPath), (String)("Archive should contain " + testPath));
    }
}

